unit SB16Mixr;  {Only supports the CT1745 mixer used in the Sound Blaster 16}
    interface {-------------------------------------------------------------}
      procedure InitMixer(BaseIO: word); { $220, $240, $260, $280 }

      procedure ResetMixer;

      procedure SetMasterVolume(Left, Right: byte); {0..31}
      procedure SetVoiceVolume(Left, Right: byte);  {0..31}
      procedure SetFMVolume(Left, Right: byte);     {0..31}
      procedure SetCDVolume(Left, Right: byte);     {0..31}
      procedure SetLineVolume(Left, Right: byte);   {0..31}
      procedure SetMicVolume(Volume: byte);         {0..31}
      procedure SetPCSpeakerVolume(Volume: byte);   {0..3}

      const {Switches to use with SetInputMixer and SetOutputMixer}
        Mic    = $01;                 {Use for Input, Output}
        CD_R   = $02;  CD_L   = $04;  {Use for Input, Output}
        Line_R = $08;  Line_L = $10;  {Use for Input, Output}
        FM_R   = $20;  FM_L   = $40;  {Use for Input}
      procedure SetOutputMixer(Switches: byte); {FM and Voice are always on}
      procedure SetInputMixer(Left, Right: byte);

      procedure SetInputGain(Left, Right: byte);    {0..3 = (1, 2, 4, 8)}
      procedure SetOutputGain(Left, Right: byte);   {0..3 = (1, 2, 4, 8)}

      const {Settings to use with SetMicAGC}
        On  = true; Off = false;
      procedure SetMicAGC(Setting: boolean);        {On, Off}

      procedure SetTreble(Left, Right: byte);       {0..15}
      procedure SetBass(Left, Right: byte);         {0..15}

     {This will only work one level deep}
      procedure SaveMixerState;
      procedure RestoreMixerState;
    implementation {--------------------------------------------------------}
      var
        SavedMixerState: array[$30..$47] of byte;
        AddressPort: word;
        DataPort:    word;
      procedure WriteMixer(Reg: byte; Value: byte);
        begin
          Port[AddressPort] := Reg;
          Port[DataPort]    := Value;
        end;
      function ReadMixer(Reg: byte): byte;
        begin
          Port[AddressPort] := Reg;
          ReadMixer := Port[DataPort];
        end;
      procedure WriteReg(Reg: byte; Value: byte; Shift: byte);
        var
          Data: byte;
        begin
          Data := Value shl Shift;
          WriteMixer(Reg, Data);
        end;

      procedure InitMixer(BaseIO: word);
        begin
          AddressPort := BaseIO+4;  {2x4}
          DataPort    := BaseIO+5;  {2x5}
        end;

      procedure ResetMixer;
        begin
          WriteMixer($00, $FF);
        end;

      procedure SetMasterVolume(Left, Right: byte);
        begin
          WriteReg($30, Left,  3);    {LLLLLxxx}
          WriteReg($31, Right, 3);    {RRRRRxxx}
        end;
      procedure SetVoiceVolume(Left, Right: byte);
        begin
          WriteReg($32, Left,  3);    {LLLLLxxx}
          WriteReg($33, Right, 3);    {RRRRRxxx}
        end;
      procedure SetFMVolume(Left, Right: byte);
        begin
          WriteReg($34, Left,  3);    {LLLLLxxx}
          WriteReg($35, Right, 3);    {RRRRRxxx}
        end;
      procedure SetCDVolume(Left, Right: byte);
        begin
          WriteReg($36, Left,  3);    {LLLLLxxx}
          WriteReg($37, Right, 3);    {RRRRRxxx}
        end;
      procedure SetLineVolume(Left, Right: byte);
        begin
          WriteReg($38, Left,  3);    {LLLLLxxx}
          WriteReg($39, Right, 3);    {RRRRRxxx}
        end;
      procedure SetMicVolume(Volume: byte);
        begin
          WriteReg($3A, Volume, 3);   {VVVVVxxx}
        end;
      procedure SetPCSpeakerVolume(Volume: byte);
        begin
          WriteReg($3B, Volume, 6);   {VVxxxxxx}
        end;

      procedure SetOutputMixer(Switches: byte);
        begin
          WriteReg($3C, Switches, 0); {xxxSSSSS}
        end;
      procedure SetInputMixer(Left, Right: byte);
        begin
          WriteReg($3D, Left,  0);  {xLLLLLLL}
          WriteReg($3E, Right, 0);  {xRRRRRRR}
        end;

      procedure SetInputGain(Left, Right: byte);
        begin
          WriteReg($3F, Left,  6);  {LLxxxxxx}
          WriteReg($40, Right, 6);  {RRxxxxxx}
        end;
      procedure SetOutputGain(Left, Right: byte);
        begin
          WriteReg($41, Left,  6);  {LLxxxxxx}
          WriteReg($42, Right, 6);  {RRxxxxxx}
        end;

      procedure SetMicAGC(Setting: boolean);
        begin
          WriteReg($43, byte(not(Setting)), 0); {xxxxxxxS}
        end;

      procedure SetTreble(Left, Right: byte);
        begin
          WriteReg($44, Left,  4);    {LLLLxxxx}
          WriteReg($45, Right, 4);    {RRRRxxxx}
        end;
      procedure SetBass(Left, Right: byte);
        begin
          WriteReg($46, Left,  4);    {LLLLxxxx}
          WriteReg($47, Right, 4);    {RRRRxxxx}
        end;
      procedure SaveMixerState;
        var
          i: byte;
        begin
          for i := $30 to $47 do
            SavedMixerState[i] := ReadMixer(i);
        end;
      procedure RestoreMixerState;
        var
          i: byte;
        begin
          for i := $30 to $47 do
            WriteMixer(i, SavedMixerState[i]);
        end;
    end. {------------------------------------------------------------------}