/* Input sources */
#define inpmicdefault 0
#define inpcdaudio    1
#define inpmicrophone 2
#define inplinein     3
/* Input filters */
#define lowfilter  0
#define highfilter 1
#define nofilter   4

/* Output modes */
#define mono   0
#define stereo 1
/* Output filters */
#define filteron     0
#define filterbypass 1

/* Function prototypes */
void init(unsigned int baseio);
void resetmixer(void);
void setinputsettings (unsigned char source, unsigned char filter);
void setoutputsettings(unsigned char mode,   unsigned char filter);

void setmicvolume   (unsigned char volume);
void setmastervolume(unsigned char left, unsigned char right);
void setvoicevolume (unsigned char left, unsigned char right);
void setfmvolume    (unsigned char left, unsigned char right);
void setcdvolume    (unsigned char left, unsigned char right);
void setlinevolume  (unsigned char left, unsigned char right);

/****************************************************************************/

void out(unsigned int port, unsigned char value)
  {
    asm {
      mov    dx, port
      mov    al, value
      out    dx, al
     }
  }
unsigned char in(unsigned int port)
  {
    asm {
      mov    dx, port
      in     al, dx
     }
  }

unsigned int mixeraddrport;
unsigned int mixerdataport;

void init(unsigned int baseio)
  {
    mixeraddrport = baseio+4;  /* 2x4 */
    mixerdataport = baseio+5;  /* 2x5 */
  }

void writemixer(unsigned char reg, unsigned char value)
  {
    out(mixeraddrport, reg);
    out(mixerdataport, value);
  }
unsigned char readmixer(unsigned char reg)
  {
    out(mixeraddrport, reg);
    return in(mixerdataport);
  }

void resetmixer(void)
  {
    writemixer(0x00, 0xFF);
  }
void setinputsettings(unsigned char source, unsigned char filter)
  {
    writemixer(0x0C, (source << 1) + (filter << 3));
  }
void setoutputsettings(unsigned char mode, unsigned char filter)
  {
    writemixer(0x0E, (mode << 1) + (filter << 5));
  }
void setmicvolume(unsigned char volume)
  {
    writemixer(0x0A, volume);
  }
void setmastervolume(unsigned char left, unsigned char right)
  {
    writemixer(0x22, (left << 4) + right);
  }
void setvoicevolume(unsigned char left, unsigned char right)
  {
    writemixer(0x04, (left << 4) + right);
  }
void setfmvolume(unsigned char left, unsigned char right)
  {
    writemixer(0x26, (left << 4) + right);
  }
void setcdvolume(unsigned char left, unsigned char right)
  {
    writemixer(0x28, (left << 4) + right);
  }
void setlinevolume(unsigned char left, unsigned char right)
  {
    writemixer(0x2E, (left << 4) + right);
  }

