/* sbsample.c */

void writedsp(unsigned char value);
unsigned char readdsp(void);
int resetdsp(void);
void turnspeakeron(void);
void turnspeakeroff(void);
unsigned char getsample(void);
void outputsample(unsigned char sample);

#define TRUE  1
#define FALSE 0

/* ---- */

#include <conio.h>

#define RESETPORT 0x226
#define READPORT  0x22A
#define WRITEPORT 0x22C
#define POLLPORT  0x22E

void writedsp(unsigned char value)
  {
    while (inp(WRITEPORT) & 0x80);
    outp(WRITEPORT, value);
  }

unsigned char readdsp(void)
  {
    while (!(inp(POLLPORT) & 0x80));
    return(inp(READPORT));
  }

int resetdsp(void)
  {
    int i;

    outp(RESETPORT, 1);
    outp(RESETPORT, 0);
    i = 100;
    while (!i && (readdsp() != 0xAA)) i++;
    return(i);
  }

void turnspeakeron()
  {
    writedsp(0xD1);
  }

void turnspeakeroff()
  {
    writedsp(0xD3);
  }

unsigned char getsample(void)
  {
    writedsp(0x20);
    return(readdsp());
  }

void outputsample(unsigned char sample)
  {
    writedsp(0x10);
    writedsp(sample);
  }
