unit SBSample;
    interface
        function ResetDSP: boolean;
        procedure TurnSpeakerOn;
        procedure TurnSpeakerOff;
        function GetSample: byte;
        procedure OutputSample(Sample: byte);
    implementation
        uses
            CRT;
        const
            ResetPort    = $226;
            ReadPort     = $22A;
            WritePort    = $22C;
            PollPort     = $22E;

            CmdDirectDAC    = $10;
            CmdDirectADC    = $20;
            CmdSpeakerOn    = $D1;
            CmdSpeakerOff   = $D3;
        procedure WriteDSP(Value: byte);
            Inline
              (
                $BA/>WritePort/        {MOV   DX, WritePort (Constant)  }
                $EC/                   {IN    AL, DX                    }
                $24/$80/               {AND   AL, 80h                   }
                $75/$FB/               {JNZ   -05                       }
                $58/                   {POP   AX                        }
                $BA/>WritePort/        {MOV   DX, WritePort (Constant)  }
                $EE                    {OUT   DX, AL                    }
              );
        function ReadDSP: byte;
            Inline
              (
                $BA/>PollPort/         {MOV   DX, PollPort  (Constant)  }
                $EC/                   {IN    AL, DX                    }
                $24/$80/               {AND   AL, 80h                   }
                $74/$FB/               {JZ    -05                       }
                $BA/>ReadPort/         {MOV   DX, ReadPort  (Constant)  }
                $EC                    {IN    AL,DX                     }
              );
        function ResetDSP: boolean;
            var
                i: byte;
            begin
                Port[ResetPort] := 1;
                Delay(1);
                Port[ResetPort] := 0;
                i := 0;
                repeat
                    Inc(i);
                until (ReadDSP = $AA) or (i = 100);
                if i < 100
                    then ResetDSP := true
                    else ResetDSP := false;
            end;
        procedure TurnSpeakerOn;
            begin
                WriteDSP(CmdSpeakerOn);
            end;
        procedure TurnSpeakerOff;
            begin
                WriteDSP(CmdSpeakerOff);
            end;
        function GetSample: byte;
            begin
                WriteDSP(CmdDirectADC);
                GetSample := ReadDSP;
            end;
        procedure OutputSample(Sample: byte);
            begin
                WriteDSP(CmdDirectDAC);
                WriteDSP(Sample);
            end;
    begin
    end.
