/* sinemix.c */

#include <conio.h>
#include "sbsample.h"
#include <math.h>

#define WAVELENGTH 10
#define AMPLITUDE  64

#define PI 3.141592653589793240

signed char sines[WAVELENGTH];
unsigned int x;

void initsines(void)
  {
    char i;
    for (i = 0; i < WAVELENGTH; i++)
      sines[i] = sin((2*PI)*((float)i/WAVELENGTH))*AMPLITUDE;
  }

void clipsample(signed int *sample)
  {
    if (*sample > 127)  *sample = 127;
    if (*sample < -128) *sample = -128;
  }

void processsample(unsigned char *sample)
  {
    signed int temp;

    temp = *sample - 128;

    /* Process sample here */
    temp = temp + sines[x];

    clipsample(&temp);
    *sample = temp + 128;
  }

int main(void)
  {
    unsigned char sample;

    initsines();
    resetdsp();
    x = 0;
    while (!kbhit())
      {
        sample = getsample();
        processsample(&sample);
        outputsample(sample);
        x = (++x % WAVELENGTH);
      }
    getch();

    return(0);
  }