program SineMix; {$R-} {$S-} {$Q-}
    uses
        SBSample,
        CRT;
    const
        WaveLength = 32; {In samples, freq varies depending on CPU speed}
        Amplitude  = 8; {Keep it low to eliminate wave-top clipping}
    var
        Sines: array[0..WaveLength-1] of ShortInt;
        Sample: byte;
        x: word;
    procedure InitSines;
        var
            i: word;
        begin
            for i := 0 to WaveLength-1 do
                Sines[i] := Round(Sin((2*Pi) * (i/WaveLength))*Amplitude);
        end;
    procedure ClipSample(var Sample: integer);
        begin
            if Sample > 127 then Sample := 127;
            if Sample < -128 then Sample := -128;
        end;
    procedure ProcessSample(var Sample: byte);
      {Make sure that you clip the sample so it stays in the proper range}
        var
            Temp: integer;
        begin
            Temp := Sample-128;

            {Process the sample here}
            Temp := Temp*2+Sines[x];

            ClipSample(Temp);
            Sample := Temp+128;
        end;
    begin
        ResetDSP;
        InitSines;
        x := 0;
        repeat
            Sample := GetSample;
            ProcessSample(Sample);
            OutputSample(Sample);
            Inc(x);
            x := x mod WaveLength;
        until KeyPressed; ReadKey;
    end.