{$M 16384, 0, 333000} {Save some of the heap for the DOS shell}
program PlayVOC;
    uses
        CRT,
        DOS,
        SBVox;
    const
        DefaultVOC    = 'FROGS.VOC';
         {Put the name of the VOC file to play here}
         {or pass it as a parameter to the program}
        InterruptNum  = 5;     {/ YOU WILL PROBABLY HAVE}
        BaseIOAddress = $220;  {\ TO CHANGE THESE CONSTS}
{$IFNDEF LinkDriver}
        DriverPath    = ''; {'' if the driver is in the current directory}
{$ENDIF}
    var
        VOCFileName : string;
        SoundSize   : LongInt;
        Header      : PVOCHeader;
        Result      : integer;
        Sound       : PSound;
        Chr         : char;
        VersionWord : word;
    procedure WriteInstructions;
        begin
            writeln('Begining output of sound file');
            writeln('Press <P> to pause');
            writeln('Press <C> to continue');
            writeln('Press <S> to stop');
            writeln('Press <B> to stop at end of next repeat loop (If repeating)');
            writeln('Press <N> to stop immediately');
            writeln('Press <D> to shell to DOS');
        end;
    begin
        writeln; writeln;

        if ParamCount = 0
            then VOCFileName := DefaultVOC
            else VOCFileName := ParamStr(1);

{$IFNDEF LinkDriver}
        Result := LoadDriver(DriverPath + 'CT-VOICE.DRV');   writeln('Attempting to install Sound Blaster driver:   ');
{$ELSE}
        writeln('Sound Blaster driver linked in'); Result := LoadDrvSuccess;
{$ENDIF}
        case Result
            of
                LoadDrvSuccess:   writeln('Sound Blaster driver loaded successfully');
                LoadDrvIOerror:   writeln('IO error loading Sound Blaster driver');
                LoadDrvNoMemory:  writeln('Not enough memory to load Sound Blaster driver');
                LoadDrvBadDriver: writeln('Sound Blaster driver is corrupted (Well at least the header is)');
            end;
        if Result <> LoadDrvSuccess then Halt(255);
        VersionWord := GetDriverVersion;
        writeln('Sound Blaster Driver Version: ', Hi(VersionWord), '.', Lo(VersionWord));
        SetInterrupt(InterruptNum);       writeln('Interrupt Number set to ', InterruptNum);
        SetBaseIOAddress(BaseIOAddress);  writeln('Base IO address set');
        Result := InitSB; write('Attempting to initialize Sound Blaster:   ');
        case Result
            of
                SBInitSuccess:                writeln('SB Initialized Correctly');
                SBInitSoundCardFailure:       writeln('Sound Card Failure');
                SBInitIOFailure:              writeln('IO Failure');
                SBInitDMAorInterruptFailure:  writeln('DMA or Interrupt Failure');
            end;
        if Result <> 0 then Halt(255);
        InitStatusWord;

        Header := nil; Sound := nil;
        SoundSize := LoadVOCfile(VOCFileName, Header, Sound);  writeln('Sound file loaded');
        if SoundSize = 0
            then
                begin
                    writeln('Error loading VOC file');
                    Halt;
                end;

        TurnSpeakerOn;
        WriteInstructions;
        PlaySound(Sound);
        repeat
            if KeyPressed
                then
                    begin
                        Chr := UpCase(ReadKey);
                        case Chr
                            of
                                'P': PauseSound;
                                'C': ContinueSound;
                                'S': StopSound;
                                'B': BreakLoop(BreakLoopAtEnd);
                                'N': BreakLoop(BreakLoopNow);
                                'D':
                                    begin
                                        SwapVectors;
                                        Exec(GetEnv('COMSPEC'), '');
                                        if DOSError <> 0
                                            then
                                                begin
                                                    writeln('Error running COMMAND.COM.   Probably not enough memory');
                                                    Halt;
                                                end;
                                        SwapVectors;
                                        WriteInstructions;
                                    end;
                            end;
                    end;
        until StatusWord = SoundCompleted; writeln('Sound output completed');
        TurnSpeakerOff;                    writeln('Speaker turned off');

        Dispose(Header);
        FreeSoundBuffer(Sound, SoundSize); writeln('Sound buffer deallocated');
{$IFDEF LinkDriver}
        ShutDownDriver;                    writeln('Sound Blaster driver unloaded');
{$ELSE}
        UnloadDriver;                      writeln('Sound Blaster driver uninstalled');
{$ENDIF}
    end.