/*-------------------------------------------------------*/
/* Originally part of SOUNDHAX v1 by John M. Trindle     */
/*                 FREEWARE 12/19/91                     */
/*-------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>


#define  CMS_AVAILABLE  1
#define  FM_AVAILABLE   2
#define  CV_AVAILABLE   4

#define  OFF            0
#define  ON             1

#define  FALSE          0
#define  TRUE           1

extern ct_io_addx;
extern ct_int_num;
extern ct_voice_status;
extern ct_music_status;

static int StatusWord;

char *VoiceDriver;

/* Disables Text Driver!! 
   sbts_unload();
*/

/* Says ASCIIZ string in buffer 
      sbts_say(buffer);
*/

typedef struct
{
   char length;
   char Text[255];
} WordString;

extern int sbts_parser(char *buffer1, char *buffer2, int p1);

main(int argc, char *argv[])
{
   int DriverFeatures,VersionCode,RetVal;

   int gender,tone,volume,pitch,speed,i,j;
   char buffer[255],buffer2[255],*TempPtr;

   char AsciiText[255],Phonetic[255];

   FILE *DictFP,*ExceptFP,*GoodFP,*RemainFP;

   WordString SubWord;

   DictFP = fopen("dict.sbt","r");
   ExceptFP = fopen("dict.exc","wa");
   RemainFP = fopen("dict.rem","wa");
   GoodFP = fopen("dict.acc","wa");


   ct_io_addx = 0x220;    /* I/O Base */

   DriverFeatures = ct_card_here();

   if (DriverFeatures & CMS_AVAILABLE)
      printf("C/MS Music Available\n");

   if (DriverFeatures & FM_AVAILABLE)
      printf("FM Music Available\n");

   if (DriverFeatures & CV_AVAILABLE)
      printf("Creative Voice Available\n");
   else
   {
      printf("Sound Blaster or Compatible NOT detected\n");
      exit(1);
   }


   VersionCode = sbc_version();
   printf("SBV Version = %d.%d\n",VersionCode >> 8, VersionCode & 0xff);

   sbc_scan_int();

   printf("Interrupt = %d\n",ct_int_num);

   RetVal = ctvd_init(6);
   printf("ctvd_init = RetVal = %d\n",RetVal);

   RetVal = sbts_init();
   printf("Init RetVal = %d\n",RetVal);

   gender = 1;
   tone = 3;
   volume = 13;
   pitch = 8;
   speed = 8;

   /* _sbts(gender,tone,volume,pitch,speed) */


   while(fgets(buffer,254,DictFP)!=NULL)
   {  
top_loop:
      printf("%s\n",buffer);
      sscanf(buffer,"%s %s",AsciiText,Phonetic);
      printf("%s\n",AsciiText);
      printf("%s\n",Phonetic);
      sbts_dict_ins(AsciiText,Phonetic);
      sbts_say(AsciiText);
      delay(2000);
      sbts_dict_del(AsciiText);
      if (kbhit())
         i = getch();
      else
         i = 0;
      switch(i)
      {
         case 'E':
         case 'e':
            fprintf(ExceptFP,"%-30s %s\n",AsciiText,Phonetic);
            break;

         case 'H':
         case 'h':
            fprintf(RemainFP,"%-30s %s\n",AsciiText,Phonetic);
            break;

         case 'a':
         case 'A':
            goto top_loop;

         case 0x1b:
            break;

         default:
            fprintf(GoodFP,"%-30s %s\n",AsciiText,Phonetic);
            break;

      }
      if (i == 0x1b)
          break;
   }
   while(fgets(buffer,254,DictFP)!=NULL)
   {
      fprintf(RemainFP,"%s",buffer);
   }
   fclose(DictFP);
   fclose(ExceptFP);
   fclose(RemainFP);
   ctvd_speaker(OFF);

   ctvd_terminate();
}
