	DOSSEG
	.MODEL  SMALL
	.STACK  100h
	.DATA
m_notes dw      016bh, 0181h, 0198h, 01b0h, 01cah, 01e5h
	dw      0202h, 0220h, 0241h, 0263h, 0287h, 02aeh ; octave 0
	dw      056bh, 0581h, 0598h, 05b0h, 05cah, 05e5h
	dw      0602h, 0620h, 0641h, 0663h, 0687h, 06aeh ; octave 1
	dw      096bh, 0981h, 0998h, 09b0h, 09cah, 09e5h
	dw      0a02h, 0a20h, 0a41h, 0a63h, 0a87h, 0aaeh ; octave 2
	dw      0d6bh, 0d81h, 0d98h, 0db0h, 0dcah, 0de5h
	dw      0e02h, 0e20h, 0e41h, 0e63h, 0e87h, 0eaeh ; octave 3
	dw      116bh, 1181h, 1198h, 11b0h, 11cah, 11e5h
	dw      1202h, 1220h, 1241h, 1263h, 1287h, 12aeh ; octave 4
	dw      156bh, 1581h, 1598h, 15b0h, 15cah, 15e5h
	dw      1602h, 1620h, 1641h, 1663h, 1687h, 16aeh ; octave 5
	dw      196bh, 1981h, 1998h, 19b0h, 19cah, 19e5h
	dw      1a02h, 1a20h, 1a41h, 1a63h, 1a87h, 1aaeh ; octave 6
	dw      1d6bh, 1d81h, 1d98h, 1db0h, 1dcah, 1de5h
	dw      1e02h, 1e20h, 1e41h, 1e63h, 1e87h, 1eaeh ; octave 7

m_patstart      dw      0
m_patpointer    dw      0
m_stepstart     dw      0
m_steppointer   dw      0
m_voicepointer  dw      0
m_count         db      1
m_speed         db      8
m_arp           db      0
m_reg           db      0
m_voicedat      db      4*9 DUP (0)
m_tr            db      0
m_st            db      0

m_voices db      20h,40h,60h,80h,0e0h,23h,43h,63h,83h,0e3h,0c0h    ;voice 1
	 db      21h,41h,61h,81h,0e1h,24h,44h,64h,84h,0e4h,0c1h    ;voice 2
	 db      22h,42h,62h,82h,0e2h,25h,45h,65h,85h,0e5h,0c2h    ;voice 3
	 db      28h,48h,68h,88h,0e8h,2bh,4bh,6bh,8bh,0ebh,0c3h    ;voice 4
	 db      29h,49h,69h,89h,0e9h,2ch,4ch,6ch,8ch,0ech,0c4h    ;voice 5
	 db      2ah,4ah,6ah,8ah,0eah,2dh,4dh,6dh,8dh,0edh,0c5h    ;voice 6
	 db      30h,50h,70h,90h,0f0h,33h,53h,73h,93h,0f3h,0c6h    ;voice 7
	 db      31h,51h,71h,91h,0f1h,34h,54h,74h,94h,0f4h,0c7h    ;voice 8
	 db      32h,52h,72h,92h,0f2h,35h,55h,75h,95h,0f5h,0c8h    ;voice 9

m_song  db      'BPSM:(C)1992 BRIAN POSTMA '            ;replayer info
	db      'TESTSONG                '              ;name of song
	db      'BRIAN POSTMA            '              ;name of composer
	dw      76*36                                   ;length in steps*36
	dw      7*11                                    ;number of instr*11
	db      0,0,0,0,0,0,0,0                         ;not used yet, future

	db      42h,0fh,042h,051h,01h,01h,0fh,091h,0c1h,01h,00h
	db      0e1h,07h,0d3h,0ffh,0h,01h,0bh,0f4h,077h,00h,02h
	db      42h,0dh,0a8h,0e6h,01h,01h,03h,0b7h,097h,01h,00h
	db      01h,00h,0a8h,085h,00h,02h,00h,0b7h,096h,03h,00h
	db      06h,0fh,0aah,0a7h,00h,01h,0fh,0aah,098h,00h,00h
	db      41h,0fh,09ah,099h,01h,01h,0fh,088h,0a9h,03h,01h
	db      44h,0fh,046h,057h,01h,0c8h,0fh,93h,0c1h,01h,03h

 dw     1,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 2,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 2,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 2,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 3,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 
 dw     1,00h, 2,00h, 5,0ch, 9,00h, 9,10ch, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 4,00h, 6,0ch, 9,00h, 9,10ch, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 2,00h, 7,0ch, 9,00h, 9,10ch, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 4,00h, 8,0ch, 9,00h, 9,10ch, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 2,00h, 5,0ch, 9,00h, 9,10ch, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 4,00h, 6,0ch, 9,00h, 9,10ch, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 2,00h, 7,0ch, 9,00h, 9,10ch, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 4,00h, 8,0ch, 9,00h, 9,10ch, 0,00h, 0,00h, 0,00h, 0,00h

 dw     1,05h, 2,00h, 5,11h, 9,00h, 9,111h, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,05h, 4,00h, 6,11h, 9,00h, 9,111h, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,05h, 2,00h, 7,11h, 9,00h, 9,111h, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,05h, 4,00h, 8,11h, 9,00h, 9,111h, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,05h, 2,00h, 5,11h, 9,00h, 9,111h, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,05h, 4,00h, 6,11h, 9,00h, 9,111h, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,05h, 2,00h, 7,11h, 9,00h, 9,111h, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,05h, 4,00h, 8,11h, 9,00h, 9,111h, 0,00h, 0,00h, 0,00h, 0,00h

 dw     1,00h, 2,00h, 5,0ch, 9,00h, 9,10ch, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 4,00h, 6,0ch, 9,00h, 9,10ch, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 2,00h, 7,0ch, 9,00h, 9,10ch, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 4,00h, 8,0ch, 9,00h, 9,10ch, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 2,00h, 5,0ch, 9,00h, 9,10ch, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 4,00h, 6,0ch, 9,00h, 9,10ch, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 2,00h, 7,0ch, 9,00h, 9,10ch, 0,00h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 4,00h, 8,0ch, 9,00h, 9,10ch, 0,00h, 0,00h, 0,00h, 0,00h

 dw    10,00h,11,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 dw    10,00h,11,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 dw    10,00h,11,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 dw    10,00h,11,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 
 dw    10,00h, 2,00h, 8,13h, 9,00h, 0,00h, 8,607h, 0,00h, 0,00h, 0,00h
 dw    10,00h, 4,00h,12,0ch, 9,00h, 0,00h,12,600h, 0,00h, 0,00h, 0,00h
 dw    10,00h, 2,00h,13,0ch, 9,00h, 0,00h,13,600h, 0,00h, 0,00h, 0,00h
 dw    10,00h, 4,00h,14,0ch, 9,00h, 0,00h,14,600h, 0,00h, 0,00h, 0,00h
 dw    18,00h, 2,00h,13,08h, 9,00h, 0,00h,13,6fch, 0,00h, 0,00h, 0,00h
 dw    18,00h, 4,00h,15,0ch, 9,00h, 0,00h,15,600h, 0,00h, 0,00h, 0,00h
 dw    19,00h, 2,00h,16,0ch, 9,00h, 0,00h,16,600h, 0,00h, 0,00h, 0,00h
 dw    19,00h, 4,00h,17,0ch, 9,00h, 0,00h,17,600h, 0,00h, 0,00h, 0,00h

 dw    10,00h,11,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 dw    10,00h,11,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 dw    10,00h,11,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 dw    10,00h,11,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h

 dw     1,00h, 2,00h, 5,0ch, 9,00h, 9,10ch, 5,600h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 4,00h, 6,0ch, 9,00h, 9,10ch, 6,600h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 2,00h, 7,0ch, 9,00h, 9,10ch, 7,600h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 4,00h, 8,0ch, 9,00h, 9,10ch, 8,600h, 0,00h, 0,00h, 0,00h
 dw     1,05h, 2,00h, 5,11h, 9,00h, 9,111h, 5,605h, 0,00h, 0,00h, 0,00h
 dw     1,05h, 4,00h, 6,11h, 9,00h, 9,111h, 6,605h, 0,00h, 0,00h, 0,00h
 dw     1,05h, 2,00h, 7,11h, 9,00h, 9,111h, 7,605h, 0,00h, 0,00h, 0,00h
 dw     1,05h, 4,00h, 8,11h, 9,00h, 9,111h, 8,605h, 0,00h, 0,00h, 0,00h
 
 dw     1,00h, 2,00h, 5,0ch, 9,00h, 9,10ch, 5,600h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 4,00h, 6,0ch, 9,00h, 9,10ch, 6,600h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 2,00h, 7,0ch, 9,00h, 9,10ch, 7,600h, 0,00h, 0,00h, 0,00h
 dw     1,00h, 4,00h, 8,0ch, 9,00h, 9,10ch, 8,600h, 0,00h, 0,00h, 0,00h
 dw    10,00h,11,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 dw    10,00h,11,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 dw    10,00h,11,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 dw    10,00h,11,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h

 dw    10,00h, 2,00h, 8,13h, 9,00h, 0,00h, 8,607h, 0,00h, 0,00h, 0,00h
 dw    10,00h, 4,00h,12,0ch, 9,00h, 0,00h,12,600h, 0,00h, 0,00h, 0,00h
 dw    10,00h, 2,00h,13,0ch, 9,00h, 0,00h,13,600h, 0,00h, 0,00h, 0,00h
 dw    10,00h, 4,00h,14,0ch, 9,00h, 0,00h,14,600h, 0,00h, 0,00h, 0,00h
 dw    18,00h, 2,00h,13,08h, 9,00h, 0,00h,13,6fch, 0,00h, 0,00h, 0,00h
 dw    18,00h, 4,00h,15,0ch, 9,00h, 0,00h,15,600h, 0,00h, 0,00h, 0,00h
 dw    19,00h, 2,00h,16,0ch, 9,00h, 0,00h,16,600h, 0,00h, 0,00h, 0,00h
 dw    19,00h, 4,00h,17,0ch, 9,00h, 0,00h,17,600h, 0,00h, 0,00h, 0,00h

 dw    10,00h,11,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 dw    10,00h,11,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 dw    10,00h,11,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h
 dw    10,00h,11,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h, 0,00h


	db      64 DUP (0)                              ;pattern 0 = empty
	db      24,2,0,0, 0,0,0,0, 24,2,0,0, 0,0,0,0
	db      27,2,0,0, 0,0,0,0, 27,2,0,0, 0,0,0,0
	db      29,2,0,0, 0,0,0,0, 29,2,0,0, 0,0,0,0
	db      30,2,0,0, 0,0,0,0, 31,2,0,0, 0,0,0,0    ;patt 1
	db      36,3,9,6ch, 0,0,0,0, 0,0,0,0, 0,0,0,0
	db      36,4,9,6ch, 0,0,0,0, 0,0,0,0, 0,0,0,0
	db      36,3,9,6ch, 0,0,0,0, 36,3,9,6ch, 0,0,0,0
	db      36,4,9,6ch, 0,0,0,0, 0,0,0,0, 0,0,0,0     ;patt 2
	db      36,3,9,6ch, 0,0,0,0, 0,0,0,0, 0,0,0,0
	db      36,4,9,6ch, 0,0,0,0, 0,0,0,0, 0,0,0,0
	db      36,4,9,6ch, 0,0,0,0, 36,4,9,6ch, 36,4,9,6ch
	db      36,4,9,6ch, 0,0,0,0, 36,4,9,6ch, 36,4,9,6ch  ;patt 3
	db      36,3,9,6ch, 0,0,0,0, 0,0,0,0, 0,0,0,0
	db      36,4,9,6ch, 0,0,0,0, 0,0,0,0, 0,0,0,0
	db      36,3,9,6ch, 0,0,0,0, 36,3,9,6ch, 36,3,9,6ch
	db      36,4,9,6ch, 0,0,0,0, 36,4,9,6ch, 0,0,0,0  ;patt 4
	db      48,1,0,0, 36 DUP (0), 43,1,0,0, 0,0,0,0
	db      44,1,0,0, 0,0,0,0, 41,1,0,0, 0,0,0,0    ;patt 5
	db      43,1,0,0, 36 DUP (0), 39,1,0,0, 0,0,0,0
	db      41,1,0,0, 0,0,0,0, 38,1,0,0, 0,0,0,0    ;patt 6
	db      39,1,0,0, 36 DUP (0), 36,1,0,0, 0,0,0,0
	db      38,1,0,0, 0,0,0,0, 35,1,0,0, 0,0,0,0    ;patt 7
	db      36,1,0,0, 60 DUP (0)                    ;patt 8
	db      48,5,9,37h, 0,0,0,0, 48,5,9,37h, 0,0,0,0
	db      48,5,9,37h, 0,0,0,0, 48,5,9,37h, 0,0,0,0
	db      48,5,9,37h, 0,0,0,0, 48,5,9,37h, 0,0,0,0
	db      48,5,9,37h, 0,0,0,0, 48,5,9,37h, 0,0,0,0;patt 9
	db      24,2,0,0, 0,0,0,0, 24,2,0,0, 0,0,0,0
	db      27,2,0,0, 0,0,0,0, 27,2,0,0, 0,0,0,0
	db      29,2,0,0, 0,0,0,0, 29,2,0,0, 0,0,0,0
	db      29,2,0,0, 31,2,0,0, 29,2,0,0, 27,2,0,0 ;patt 10
	db      36,3,9,6ch, 0,0,0,0, 0,0,0,0, 0,0,0,0
	db      36,3,9,6ch, 0,0,0,0, 36,3,9,6ch, 0,0,0,0
	db      36,3,9,6ch, 0,0,0,0, 0,0,0,0, 0,0,0,0
	db      36,3,9,6ch, 0,0,0,0, 36,3,9,6ch, 0,0,0,0 ; patt 11
	db      0,0,0,0, 0,0,0,0, 42,1,0,0, 0,0,0,0
	db      43,1,0,0, 0,0,0,0, 44,1,0,0, 0,0,0,0
	db      43,1,0,0, 0,0,0,0, 41,1,0,0, 0,0,0,0
	db      39,1,0,0, 0,0,0,0, 36,1,0,0, 0,0,0,0    ; patt 12
	db      38,1,0,0, 28 DUP (0), 36,1,0,0, 28 DUP (0) ; patt 13
	db      16 DUP (0)
	db      36,1,0,0, 0,0,0,0, 39,1,0,0, 0,0,0,0
	db      38,1,0,0, 0,0,0,0, 36,1,0,0, 0,0,0,0
	db      31,1,0,0, 0,0,0,0, 27,1,0,0, 0,0,0,0    ;patt 14
	db      16 DUP (0)
	db      32,1,0,0, 0,0,0,0, 35,1,0,0, 0,0,0,0
	db      34,1,0,0, 0,0,0,0, 32,1,0,0, 0,0,0,0
	db      29,1,0,0, 0,0,0,0, 27,1,0,0, 0,0,0,0    ;patt 15
	db      26,1,0,0, 0,0,0,0, 0,0,0,0 ,0,0,0,0
	db      31,1,0,0, 0,0,0,0, 31,1,0,0, 0,0,0,0
	db      31,1,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
	db      35,1,0,0, 0,0,0,0, 35,1,0,0, 0,0,0,0    ;patt 16
	db      35,1,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
	db      38,1,0,0, 0,0,0,0, 38,1,0,0, 0,0,0,0
	db      38,1,0,0, 28 DUP (0)                    ;patt 17
	db      29,2,0,0, 0,0,0,0, 29,2,0,0, 0,0,0,0
	db      32,2,0,0, 0,0,0,0, 32,2,0,0, 0,0,0,0
	db      34,2,0,0, 0,0,0,0, 34,2,0,0, 0,0,0,0
	db      35,2,0,0, 36,2,0,0, 34,2,0,0, 32,2,0,0  ;patt 18
	db      31,2,0,0, 0,0,0,0, 31,2,0,0, 0,0,0,0
	db      35,2,0,0, 0,0,0,0, 35,2,0,0, 0,0,0,0
	db      38,2,0,0, 0,0,0,0, 38,2,0,0, 0,0,0,0
	db      36,2,0,0, 36,2,0,0, 38,2,0,0, 36,2,0,0  ;patt 19



	.CODE
start:  mov     ax,@data
	mov     ds,ax

	call    m_checkadlib
	cmp     ax,00
	jnz     error
	call    m_clearadlib
	call    m_init
	cli
waitkey:mov     dx,03dah
wait1:  in      al,dx
	test    al,08
	jnz     wait1
wait2:  in      al,dx
	test    al,08
	jz      wait2

	call    m_music

	mov     ah,0bh
	int     21h
	cmp     al,0h
	je      waitkey
	sti
	call    m_clearadlib
error:  mov     ax,4c00h
	int     21h

m_checkadlib:
	mov     cl,04
	mov     ch,0060h
	call    writeport
	mov     ch,0080h
	call    writeport
	mov     dx,0388h
	in      al,dx
	mov     ah,al
	mov     cl,02
	mov     ch,00ffh
	call    writeport
	mov     cl,04
	mov     ch,0021h
	call    writeport
	call    delay
	mov     dx,0388h
	in      al,dx
	mov     cl,04h
	mov     ch,0060h
	call    writeport
	and     al,00e0h
	and     ah,00e0h
	cmp     ah,00h
	jnz     noadlib
	cmp     al,00c0h
	jnz     noadlib
	mov     ax,0000h
	ret
noadlib:mov     ax,0ffffh
	ret

delay:  mov     cx,140
	mov     dx,0338h
dloop:  in      al,dx
	dec     cx
	jnz     dloop
	ret

m_clearadlib:
	mov     cl,01
clrloop:mov     ch,00
	call    writeport
	inc     cl
	cmp     cl,00f4h
	jnz     clrloop
	mov     cl,01
	mov     ch,0020h
	call    writeport
	ret

; this sub needs the port adress in cl, the data in ch
writeport:
	push    ax
	push    dx
	mov     al,cl     
	mov     dx,388h
	out     dx,al
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	mov     al,ch
	inc     dx
	out     dx,al
	mov     dx,0388h
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	in      al,dx
	pop     dx
	pop     ax
	ret

m_init: mov     bx,OFFSET m_song+74
	mov     ax,[bx]                 ;ax is steps*length
	mov     cx,[bx+2]               ;cx is nr.instruments*length
	add     cx,OFFSET m_song+86
	mov     m_steppointer,cx        ;pointer to current step
	mov     m_stepstart,cx          ;pointer to first step
	add     cx,ax                   ;cx is start of patterns
	mov     m_patpointer,00h        ;pointer within pattern
	mov     m_patstart,cx           ;pointer to first pattern
	ret

m_music:call    m_playarp
	call    m_playnext
	ret

m_playarp:
	inc     m_arp
	cmp     m_arp,03h
	jnz     m_skip1
	mov     m_arp,00h
m_skip1:mov     si,9                    ;number of voices
	mov     di,OFFSET m_voicedat
	mov     dh,0a0h
m_loop1:mov     bx,di
	cmp     BYTE PTR[bx+1],00h
	jz      m_noarp
	mov     al,[bx+3]               ;al is current note
	cmp     al,00h
	jz      m_noarp
	
	mov     dl,[bx+1]               ;arpeggio byte
	mov     ah,m_arp                ;ah is arp status
	cmp     ah,00h                  ;00=play at current note
	jz      m_skip2                 ;so don't add
	
	cmp     ah,01h                  ;01=lower nibble
	jnz     m_skip3                 ;else is 02
	and     dl,0fh
	add     al,dl                   ;new note
	jmp     m_skip2
m_skip3:shr     dl,01h
	shr     dl,01h
	shr     dl,01h
	shr     dl,01h
	and     dl,0fh
	add     al,dl
m_skip2:mov     bx,OFFSET m_notes
	mov     ah,00h
	dec     al                      ;correction coz zero=no play
	add     ax,ax                   ;add bx with 2 times ax
	add     bx,ax                   ;becoz 1 note is 2 bytes
	mov     ax,[bx]                 ;al is f-number, ah-octave etc.
	mov     bx,di
	or      ah,[bx+2]               ;or with key on/off value
	mov     cl,dh
	mov     ch,al
	call    writeport
	add     dh,010h
	mov     cl,dh
	mov     ch,ah
	call    writeport
	sub     dh,010h
m_noarp:dec     si
	add     di,04h
	inc     dh
	cmp     si,00h
	jnz     m_loop1
	ret
	
m_playnext:
	dec     m_count
	cmp     m_count,00h
	jz      m_skip4
	ret
m_skip4:mov     al,m_speed
	mov     m_count,al
	mov     si,09h
	mov     bx,OFFSET m_voices
	mov     m_voicepointer,bx
	mov     m_reg,0a0h
	mov     dx,OFFSET m_voicedat
m_loop2:mov     bx,m_steppointer
	mov     ax,[bx]                 ;ax is now pattern number
	
	mov     cl,[bx+2]
	mov     m_tr,cl                 ;transpose
	mov     cl,[bx+3]
	mov     m_st,cl                 ;soundtranspose
	
	shl     ax,01h
	shl     ax,01h
	shl     ax,01h
	shl     ax,01h
	shl     ax,01h
	shl     ax,01h                  ;6 times shift left = x64=length pat
	add     ax,m_patstart
	add     ax,m_patpointer         ;ax is now pointer to note to play
	mov     bx,ax
	mov     di,bx                   ;save pointer to pattern in di
	
	mov     al,[bx]
	cmp     al,00h                  ;should I play note
	jnz     m_skip8
	jmp     m_noplay
m_skip8:cmp     al,0ffh
	jnz     m_skip5
	mov     bx,dx                   ;this part here keys tone off
	mov     BYTE PTR[bx+2],00h
	mov     BYTE PTR[bx],00h
	mov     cl,[bx]
	mov     ch,00h
	cmp     cx,00h
	jnz     m_skip6
	dec     cx
	add     cx,cx
	add     cx,OFFSET m_notes
	mov     bx,cx
	mov     cx,[bx]
	and     ch,01fh
	mov     cl,m_reg
	add     cl,010h
	call    writeport
m_skip6:jmp     m_noplay

m_skip5:mov     bx,dx
	add     al,m_tr
	mov     [bx+3],al               ;save current note
	mov     BYTE PTR[bx+1],00h      ;arpeggio off
	mov     BYTE PTR[bx+2],020h     ;keyon value
	mov     bx,di
	mov     al,[bx+1]               ;get instrument
	add     al,m_st                 ;add soundtranspose
	mov     bx,dx
	cmp     al,[bx]                 ;is instrument current instrument
	jnz     m_skipa
	jmp     m_skip7      
m_skipa:mov     [bx],al                 ;save instrument
	dec     al
	mov     cl,0bh
	mul     cl                      ;x11 for instruments
	mov     bx,OFFSET m_song+86
	add     ax,bx                   ;ax now holds source
	mov     bx,m_voicepointer
	
	mov     cl,[bx]         ;now we'll copy the instrument data 11 bytes
	push    bx
	mov     bx,ax
	mov     ch,[bx]
	call    writeport
	pop     bx
	mov     cl,[bx+1]
	push    bx
	mov     bx,ax
	mov     ch,[bx+1]
	call    writeport
	pop     bx
	mov     cl,[bx+2]
	push    bx
	mov     bx,ax
	mov     ch,[bx+2]
	call    writeport
	pop     bx
	mov     cl,[bx+3]
	push    bx
	mov     bx,ax
	mov     ch,[bx+3]
	call    writeport
	pop     bx
	mov     cl,[bx+4]
	push    bx
	mov     bx,ax
	mov     ch,[bx+4]
	call    writeport
	pop     bx
	mov     cl,[bx+5]
	push    bx
	mov     bx,ax
	mov     ch,[bx+5]
	call    writeport
	pop     bx
	mov     cl,[bx+6]
	push    bx
	mov     bx,ax
	mov     ch,[bx+6]
	call    writeport
	pop     bx
	mov     cl,[bx+7]
	push    bx
	mov     bx,ax
	mov     ch,[bx+7]
	call    writeport
	pop     bx
	mov     cl,[bx+8]
	push    bx
	mov     bx,ax
	mov     ch,[bx+8]
	call    writeport
	pop     bx
	mov     cl,[bx+9]
	push    bx
	mov     bx,ax
	mov     ch,[bx+9]
	call    writeport
	pop     bx
	mov     cl,[bx+10]
	push    bx
	mov     bx,ax
	mov     ch,[bx+10]
	call    writeport
	pop     bx              ;this part copied the instrument data

m_skip7:mov     bx,di
	mov     al,[bx]         ;get note
	add     al,m_tr         ;add transpose
	mov     bx,OFFSET m_notes
	mov     ah,00h
	dec     al              ;-1 correction
	add     ax,ax           ;ax times two
	add     bx,ax
	mov     ax,[bx]         ;here is the note to play

	mov     cl,m_reg
	mov     ch,al
	call    writeport
	add     cl,010h
	mov     ch,ah
	call    writeport
	or      ch,020h
	call    writeport
	
m_noplay:
	mov     bx,di
	mov     al,[bx+2]       ;get effect byte
	mov     ah,[bx+3]       ;and data byte
	cmp     al,02h          ;set tempo
	jnz     m_nopt2
	mov     m_speed,ah
	mov     m_count,ah
m_nopt2:cmp     al,09h          ;set arpeggio
	jnz     m_nopt9
	mov     bx,dx
	mov     [bx+1],ah
m_nopt9:
	inc     m_reg
	add     m_voicepointer,0bh
	add     m_steppointer,04h
	add     dx,04h
	dec     si
	cmp     si,00h
	jz      m_skip9
	jmp     m_loop2
m_skip9:
	sub     m_steppointer,9*4
m_advance:
	mov     ax,m_steppointer
	add     m_patpointer,04h
	cmp     m_patpointer,040h
	jnz     m_skip
	mov     m_patpointer,00h
	mov     ax,m_steppointer
	add     ax,36
	cmp     ax,m_patstart
	jnz     m_skip
	mov     ax,m_stepstart
m_skip: mov     m_steppointer,ax
	ret
	END


