; Resident CD-Audio player
; Assemble with TASM /ml CDTSR
; Link with     TLINK /t CDTSR (option /t for .COM generation)
;
; Remember when using this programm with a soundcard as interface
; you set the line input/output enabled
;
; To load it into your memory type (LH) CDTSR

                P386                    ; using standard TASM model
                IDEAL
                DOSSEG
                MODEL   tiny

Time_Wait       EQU     9               ; wait 1/2 sec between commands

STRUC   PlayReq
 length         db      22
 subunit        db      0
 command        db      132             ; command 132 = play audio
 status         dw      0
 reserved       db      8 DUP (0)
 adressmode     db      0
 start          dd      0
 number         dd      0
ENDS

STRUC   StopReq
 length         db      13
 subunit        db      0
 command        db      133             ; command 133 = stop audio
 status         dw      0
 reserved       db      8 DUP (0)
ENDS

STRUC   IOoutput
 length         db      26
 subunit        db      0
 command        db      12              ; command 12 = IOCTL send output request
 status         dw      0
 reserved       db      8 DUP (0)
 media          db      0               ; media discriptor byte
 transferoff    dw      ?               ; transfer adress segment
 transferseg    dw      ?               ; transfer adress offset
 number         dw      ?               ; number of bytes to read
 start          dw      0               ; starting sector
 pointer        dd      0               ; pointer to requested volume (not used)
ENDS

STRUC   IOinput
 length         db      26
 subunit        db      0
 command        db      3               ; command 3 = IOCTL send input request
 status         dw      0
 reserved       db      8 DUP (0)
 media          db      0               ; media discriptor byte
 transferoff    dw      ?               ; transfer adress segment
 transferseg    dw      ?               ; transfer adress offset
 number         dw      ?               ; number of bytes to read
 start          dw      0               ; starting sector
 pointer        dd      0               ; pointer to requested volume (not used)
ENDS
                CODESEG

                ORG     100h            ; base adress of .COM files

Start:          jmp     Begin           ; do temporary part first

;--------------------------------------------------------------------------
; interrupt data part
;--------------------------------------------------------------------------
BusyByte        db      0               ; no re-entrance
CD_drive        db      0               ; drive number
CD_track        dw      1               ; current track
DriveInfo       db      26 DUP (0)      ; list of all CD-Rom drives
CD_InfoSect     db      6 DUP (0)       ; header in sector format
                db      26*8 DUP (0)    ; max. 26 tracks (make larger for more CD tracks)
CDA_PlayReq     PlayReq         <>      ; record for play request
CDA_StopReq     StopReq         <>      ; record for stop request
CDA_OutputReq   IOoutput        <>      ; record for output request
CDA_InputReq    IOinput         <>      ; record for input request
;---- control blocks for output
ControlReset    db      2               ; code for reset
;---- control blocks for input
ControlVolume   db      8               ; code for volume size
                dd      ?               ; volume size set after call
ControlDisk     db      10              ; code for disk info
                db      ?               ; lowest track set after call
                db      ?               ; highest track set after call
                dd      ?               ; starting point of the lead-out track set after call
ControlTrack    db      11              ; code for track info
                db      ?               ; track to get info from
                dd      ?               ; starting point of the track set after call
                db      ?               ; track control information
ControlStatus   db      15              ; code for general status
                dw      ?               ; audio status bit set after call
                dd      ?               ; starting location of last
                                        ; play or for next resume set after call
                dd      ?               ; ending location for last
                                        ; play or for next resume set after call
ControlStatus2  db      6               ; code for disk status
                dd      ?               ; status bits
                                ; bit 00 = 0 : door closed
                                ;        = 1 : door open
                                ; bit 01 = 0 : door locked
                                ;        = 1 : door un-locked
                                ; bit 02 = 0 : supports only cooked reading
                                ;        = 1 : supports cooked & raw reading
                                ; bit 03 = 0 : read only
                                ;        = 1 : read/write
                                ; bit 04 = 0 : data read only
                                ;        = 1 : data read and play audio/video tracks
                                ; bit 05 = 0 : no interleaving
                                ;        = 1 : supports ISO-9660 interleaving using interleave size
                                ; bit 06 = reserved
                                ; bit 07 = 0 : no pre-fetching
                                ;        = 1 : supports pre-fetching requests
                                ; bit 08 = 0 : no audio channel manipulation
                                ;        = 1 : supports audio channel manipulation
                                ; bit 09 = 0 : supports HSG adressing mode
                                ;        = 1 : supports HSG and Red Book adressing mode
                                ; bit 10 = reserved
                                ; bit 11 = 0 : disc is present in drive
                                ;        = 1 : no disc is present in drive
                                ; bit 12 = 0 : doesn't support R-W sub-channels
                                ;        = 1 : supports R-W sub-channels
                                ; bits (13-31) = reserved
ControlLocation db      12              ; code for location
                db      1               ; control and adr byte (sony red book)
                db      ?               ; track number (in sony format...)
                db      ?               ; point or index
                                        ; running time within a track
                db      ?               ; min
                db      ?               ; sec
                db      ?               ; frame
                db      ?               ; always zero
                                        ; running time on the disk
                db      ?               ; min
                db      ?               ; sec
                db      ?               ; frame
InfoScreen11_T  db      'Ŀ'
InfoScreen12_T  db      'No disc present '
InfoScreen13_T  db      ''    ; screen message 1
InfoScreen21_T  db      'Ŀ'
InfoScreen22_T  db      'Playing track 00'
InfoScreen23_T  db      ''    ; screen message 2
InfoScreen31_T  db      '                  '
                db      '                  '
                db      '                  '    ; clear screen after X seconds
Tijd            dw      ?               ; dummy variable

;--------------------------------------------------------------------------
; interrupt code part
;--------------------------------------------------------------------------
INT_05:         sti                     ; permit interrupts (like devices)
                push    ax
                push    bx
                push    cx
                push    dx
                push    si
                push    di
                push    bp
                push    ds
                push    es
                pushf                   ; save all registers
                push    cs
                pop     ds
                push    cs
                pop     es
                cmp     [BusyByte],0    ; no re-entrance please
                jne     short INT05_End
                inc     [BusyByte]
                call    CD_Main         ; do main audio player part
                dec     [BusyByte]
INT05_End:      popf                    ; restore all registers
                pop     es
                pop     ds
                pop     bp
                pop     di
                pop     si
                pop     dx
                pop     cx
                pop     bx
                pop     ax
                iret

CD_Main:        mov     al,[CD_drive]
                call    CDA_DiscPresent         ; check if disc is inserted
                jc      short NoDisc
                mov     al,[CD_drive]
                call    CDA_PlayPause           ; check if playing
                jnc     short NoPlay
                mov     al,[CD_drive]
                call    CDA_Position            ; get position when playing
                mov     [CD_track],cx           ; set track
                mov     al,[CD_drive]
                call    CDA_Stop                ; stop playing
                call    NextTrack               ; play next track
StartCont:      mov     ax,[CD_track]   ; display information (which track)
                mov     cx,10           ; convert sony track number to decimal
                div     cl
                push    ax
                and     ax,0fh
                or      ax,30h
                mov     si, OFFSET InfoScreen22_T + 15
                mov     [ds:si],al
                pop     ax
                rol     ax,8
                and     ax,0fh
                or      ax,30h
                mov     si, OFFSET InfoScreen22_T + 16
                mov     [ds:si],al
                mov     si, OFFSET InfoScreen21_T       ; display info-box
                call    PrintInfo
                call    WaitTime                        ; wait X seconds
                mov     si, OFFSET InfoScreen31_T       ; clear info-box
                call    PrintInfo
                ret                                     ; return/exit
NoDisc:         mov     si, OFFSET InfoScreen11_T
                call    PrintInfo                       ; display no-disc message
                call    WaitTime                        ; wait X seconds
                mov     si, OFFSET InfoScreen31_T       ; clear info-box
                call    PrintInfo
                ret                                     ; return/exit
NoPlay:         mov     al,[CD_drive]
                mov     di, OFFSET CD_InfoSect          ; get extended info
                call    CDA_DiskExtInfoSec              ; of all tracks in sector format
StartNew:       mov     bx,1
                mov     [CD_track],bx           
                call    ContinuePlaying                 ; start playing at track 1
                jmp     short startCont                 ; jump to information part...
NextTrack:      mov     si, OFFSET CD_InfoSect
                mov     ax,[ds:si+4]                    ; get max. track
                mov     bx,[CD_track]                   ; get current track
                cmp     ax,bx
                je      short StartNew                  ; if equal, start all over again
                inc     bx                              ; otherwise, increase track number
                mov     [CD_track],bx                   ; store it
                call    ContinuePlaying                 ; play track number in BX
                ret                                     ; return to caller

; input : BX = track number
ContinuePlaying:mov     si, OFFSET CD_InfoSect          ; get information table
                dec     bx
                add     bx,bx
                add     bx,bx
                add     bx,bx                           ; BX = (BX-1)*8
                mov     eax,[ds:si+bx+6]                ; get start sector
                mov     ecx,[ds:si]                     ; get max. sector
                mov     ebx,eax
                mov     al,[CD_drive]
                call    CDA_Play                        ; send play command
                ret

; simple routine to plot an information box (18x3) at top of screen
PrintInfo:      push    es
                mov     ax,0b000h                       ; make 0b800h if color
                mov     es,ax
                mov     di,124                          ; right corner
                mov     cx,18
                mov     ah,2                            ; attribute = green
PrintLoop:      mov     al,[ds:si]                      ;  or normal on monochrome
                mov     [es:di],ax
                mov     al,[ds:si+18]
                mov     [es:di+160],ax
                mov     al,[ds:si+36]
                mov     [es:di+320],ax
                inc     si
                inc     di
                inc     di
                dec     cx
                jnz     short PrintLoop
                pop     es
                ret

; simple routine to wait for X timer ticks (1sec = 18.2444444ticks)
WaitTime:       mov     [Tijd],Time_Wait
		mov	ah,0
		int	1ah			; Read time ticker
		add	[Tijd],dx		; add to wait_time
Wacht_Wait:	mov	ah,0
		int	1ah
		cmp	[Tijd],dx		; time equals real time ?
		jne	Wacht_Wait		; no ?, wait until
		ret

;--------------------------------------------------------------
; set of standard routines to acces the CD-Rom drive
; to use them elsewhere copy them, including the STRUC
; at the top of the source, also copy the Control????? blocks
;--------------------------------------------------------------
; input  : AL - drive
;          EBX - start SECTOR
;          ECX - end SECTOR
; output : some noice if succesfull, otherwise carry flag set
CDA_Play:       push    ax
                push    ebx
                push    ecx
                mov     [CDA_PlayReq.start],ebx
                sub     ecx,ebx
                mov     [CDA_PlayReq.number],ecx
                xor     ecx,ecx
                mov     cl,al
                mov     ax,1510h
                mov     bx, OFFSET CDA_PlayReq
                int     2fh                             ; start playing
                pop     ecx
                pop     ebx
                pop     ax
                ret

; input  : AL - drive
CDA_Stop:       push    ax
                push    bx
                push    cx
                xor     cx,cx
                mov     cl,al
                mov     ax,1510h
                mov     bx, OFFSET CDA_StopReq
                int     2fh
                pop     cx
                pop     bx
                pop     ax
                ret

; input : AL - drive
CDA_Reset:      xor     cx,cx
                mov     cl,al
                mov     ax,1                            ; length of control block
                mov     [CDA_OutputReq.number],ax
                mov     bx, OFFSET ControlReset
                mov     [CDA_OutputReq.transferoff],bx
                mov     [CDA_OutputReq.transferseg],ds
                mov     ax,1510h
                mov     bx, OFFSET CDA_OutputReq
                int     2fh
                ret

; input : AL - drive
; output: EAX - position of cd-rom drive on the disk
;         EBX - position of cd-rom drive within the track
;         CX - track number
CDA_Position:   xor     cx,cx
                mov     cl,al
                mov     ax,11                           ; length of control block
                mov     [CDA_InputReq.number],ax
                mov     bx, OFFSET ControlLocation
                mov     [CDA_InputReq.transferoff],bx
                mov     [CDA_InputReq.transferseg],ds
                mov     ax,1510h
                mov     bx, OFFSET CDA_InputReq
                int     2fh
                mov     bl,[byte ptr ControlLocation + 8]
                mov     bh,[byte ptr ControlLocation + 9]
                mov     cl,[byte ptr ControlLocation + 10]
                xor     eax,eax
                mov     al,bl
                rol     eax,8
                mov     al,bh
                rol     eax,8
                mov     al,cl
                mov     dl,[byte ptr ControlLocation + 4]
                mov     dh,[byte ptr ControlLocation + 5]
                mov     cl,[byte ptr ControlLocation + 6]
                xor     ebx,ebx
                mov     bl,dl
                rol     ebx,8
                mov     bl,dh
                rol     ebx,8
                mov     bl,cl
                xor     cx,cx
                mov     cl,[byte ptr ControlLocation + 2]
                ; cl = 10 -> track 10
                ;      20 -> track 20
                ; should be
                ; cl = 0A -> track 10
                ;      14 -> track 20
                xor     dx,dx
@@20:           cmp     cl,10
                jl      short @@10
                sub     cl,16
                add     dx,10
                jmp     short @@20
@@10:           add     cx,dx
                ret

; input : AL - drive
; output: AX - audio status bits
;         EBX - starting location of last play or for next resume
;         ECX - ending location for last play or for next resume
;         EDX - status bits (32)
CDA_Status:     xor     cx,cx
                mov     cl,al
                push    cx
                mov     ax,11                           ; length of control block
                mov     [CDA_InputReq.number],ax
                mov     bx, OFFSET ControlStatus
                mov     [CDA_InputReq.transferoff],bx
                mov     [CDA_InputReq.transferseg],ds
                mov     ax,1510h
                mov     bx, OFFSET CDA_InputReq
                int     2fh
                mov     ax,[word ptr ControlStatus+1]
                mov     ebx,[dword ptr ControlStatus+3]
                mov     ecx,[dword ptr ControlStatus+7]
                pop     cx
                push    ax
                push    ebx
                push    ecx
                mov     ax,5                            ; length of control block
                mov     [CDA_InputReq.number],ax
                mov     bx, OFFSET ControlStatus2
                mov     [CDA_InputReq.transferoff],bx
                mov     [CDA_InputReq.transferseg],ds
                mov     ax,1510h
                mov     bx, OFFSET CDA_InputReq
                int     2fh
                mov     edx,[dword ControlStatus2 + 1]
                pop     ecx
                pop     ebx
                pop     ax
                ret

; input : AL - drive
; output: AL = 0 / CF = 1 : playing
;         AL = 1 / CF = 0 : stopped
CDA_PlayPause:  call    CDA_Status      ; get current status
                ror     ebx,16          ; get last resume position
                ror     ecx,16          ; get last play position
                and     ebx,0ffh                ; if stopped, ther'e the same
                and     ecx,0ffh                ; otherwise ther'e totally different
                sub     ebx,ecx
                jz      short @@10      ; so comapring minutes is enough
                xor     ax,ax
                stc
                ret
@@10:           mov     al,1
                clc
                ret

; input : AL - drive
; output: AL = 0 / CF = 1 : no disc present
;         AL = 1 / CF = 0 : disc present
CDA_DiscPresent:call    CDA_Status              ; get current status
                and     edx,0100000000000b      ; get disc bit
                jnz     short @@10
                mov     ax,1
                clc
                ret
@@10:           xor     ax,ax
                stc
                ret

; input : AL - drive
; output: EAX - volume size in sectors
CDA_VolumeSize: xor     cx,cx
                mov     cl,al
                mov     ax,5                            ; length of control block
                mov     [CDA_InputReq.number],ax
                mov     bx, OFFSET ControlVolume
                mov     [CDA_InputReq.transferoff],bx
                mov     [CDA_InputReq.transferseg],ds
                mov     ax,1510h
                mov     bx, OFFSET CDA_InputReq
                int     2fh
                mov     eax,[dword ptr ControlVolume + 1]
                sub     eax,150
                ret

; input : AL - drive
; output: AL - first track
;         AH - last track
;         EBX - first sector of first track
CDA_DiskInfo:   xor     cx,cx
                mov     cl,al
                mov     ax,7                            ; length of control block
                mov     [CDA_InputReq.number],ax
                mov     bx, OFFSET ControlDisk
                mov     [CDA_InputReq.transferoff],bx
                mov     [CDA_InputReq.transferseg],ds
                mov     ax,1510h
                mov     bx, OFFSET CDA_InputReq
                int     2fh
                mov     al,[byte ptr ControlDisk+1]
                mov     ah,[byte ptr ControlDisk+2]
                mov     ebx,[dword ptr ControlDisk+3]
                ret

; input : AL - drive
;         AH - track number to get info from
; output: EAX - starting point of track in Red Sony Book format (aaargh)
;         BL - track control information
CDA_TrackInfo:  xor     cx,cx
                mov     cl,al
                mov     [byte ptr ControlTrack+1],ah    ; set track number
                mov     ax,7                            ; length of control block
                mov     [CDA_InputReq.number],ax
                mov     bx, OFFSET ControlTrack
                mov     [CDA_InputReq.transferoff],bx
                mov     [CDA_InputReq.transferseg],ds
                mov     ax,1510h
                mov     bx, OFFSET CDA_InputReq
                int     2fh
                mov     eax,[dword ptr ControlTrack+2]
                call    ConvertSonySec
                mov     bl,[byte ptr ControlTrack+6]
                ret

; input : AL - drive
;         DI - offset of large table to filled with info :
;              00 dword - volume size in sectors
;              04  word - number of tracks
;              06 dword - starting point of track 1
;              10 dword - length of track 1
;              14 dword - starting point of track 2
;              18 dword - length of track 2
;              22 etc....
CDA_DiskExtInfoSec:
                push    di
                push    ax
                call    CDA_VolumeSize
                mov     si, OFFSET DriveInfo
                mov     [ds:si],eax
                pop     ax
                push    ax
                call    CDA_DiskInfo
                mov     si, OFFSET DriveInfo
                mov     [ds:si+4],ah
                pop     ax
                pop     di
                mov     ebx,[ds:si]
                mov     [ds:di],ebx
                mov     bl,[ds:si+4]
                xor     bh,bh
                mov     [ds:di+4],bx
                add     di,6
                add     si,4
; ax = drive
; di = offset of table + 6
; si = offset of driveinfo + 4
                push    di
                mov     cx,1                    ; start at track 1
@@10:           push    ax
                push    cx
                push    si
                push    di
                mov     ah,cl
                call    CDA_TrackInfo
                mov     ebx,eax
                pop     di
                pop     si
                pop     cx
                pop     ax
                mov     [ds:di],ebx
                add     di,8
                inc     cx
                cmp     cl,[ds:si]
                jbe     short @@10
                pop     di
                sub     di,6
                mov     edx,[ds:di]
                mov     bp,[ds:di+4]
                add     di,6
                mov     cx,1
@@20:           mov     eax,[ds:di+8]
                sub     eax,[ds:di]
                mov     [ds:di+4],eax
                add     di,8
                inc     cx
                cmp     cx,bp
                jne     short @@20
                mov     eax,edx
                sub     eax,[ds:di]
                mov     [ds:di+4],eax
                ret

; input : EAX - Sector
; output: EAX - Sony Red Book sector
ConvertSecSony: add     eax,150
                or      eax,eax
                jz      short @@99
                mov     ecx,4500
                xor     edx,edx
                div     ecx                     ; eax = eax/ecx, edx = rest
                mov     bx,ax                   ; bx = minutes
                mov     eax,edx
                xor     edx,edx
                or      eax,eax
                jz      short @@98
                mov     ecx,75
                div     ecx                     ; eax = eax/ecx, edx = rest
                ; bx = minutes
                ; ax = seconds
                ; dx = frames
@@10:           mov     cx,ax
                xor     eax,eax
                mov     al,bl
                rol     eax,8
                mov     al,cl
                rol     eax,8
                mov     al,dl
@@99:           ret
@@98:           ; bx = minutes
                ; seconds = zero
                ; frames = zero
                xor     ax,ax
                xor     dx,dx
                jmp     short @@10


; input : EAX - Sony Red Book sector
; output: EAX - Normal sector
ConvertSonySec: push    eax
                and     eax,0ffh
                mov     ebx,eax                 ; ebx = frame
                pop     eax
                push    eax
                ror     eax,8
                and     eax,0ffh
                mov     ecx,75
                mul     ecx
                add     ebx,eax                 ; ebx = frame + 75*second
                pop     eax
                ror     eax,16
                and     eax,0ffh
                mov     ecx,4500
                mul     ecx
                add     ebx,eax                 ; eax = frame + 75*second + 60*minute
                mov     eax,ebx
                sub     eax,150
                ret

;--------------------------------------------------------------------------
; Temporary code part
;--------------------------------------------------------------------------
Begin:          cld
                call    CDA_GetDrive            ; get first CD-Rom drive
                mov     [CD_drive],al           ; store it
                call    CDA_Reset               ; reset the CD-Rom drive
                mov     al,[CD_drive]
                add     al,65
                mov     si, OFFSET Intro1_T + 47
                mov     [ds:si],al              ; place drive in intro text
                mov     ah,9
                mov     dx, OFFSET Intro1_T
                int     21h                     ; print first intro line
                mov     dx, OFFSET Intro2_T
                int     21h                     ; print second intro line
                mov     ax,2505h
                mov     dx, OFFSET INT_05
                int     21h                     ; Set new vector
                mov     dx, OFFSET Begin
                int     27h                     ; int27h - Terminate & Stay Resident

; output: AX = first CD-Rom drive
;
; Here DriveInfo is used as a block where all CD-Roms are placed
; as you see at the top, there's room for 26 CD-Rom drives
; to get the second drive instead of the first, change the line (*)
;   MOV AL,[BYTE PTR DRIVEINFO]
; into
;   MOV AL,[BYTE PTR DRIVEINFO+1]
CDA_GetDrive:   push    bx
                mov     ax,150dh
                mov     bx, OFFSET DriveInfo
                int     2fh
                xor     ax,ax
                mov     al,[byte ptr DriveInfo]         ; (*)
                pop     bx
                ret
;--------------------------------------------------------------------------
; temporary data part
;--------------------------------------------------------------------------
Intro1_T        db      13,10,'Resident CD-Audio player (p) M.Kuperus at drive : X',13,10,10,'$'
Intro2_T        db      'When pressing PrintScreen :',13,10
                db      '      - Message if no disc present',13,10
                db      '      - If not playing, start playing at track 1',13,10
                db      '      - If playing, jump to next track',13,10,10,'$'
;--------------------------------------------------------------------------
                END     Start
