#include <windows.h>
#include <string.h>             // for _fmemcpy
#include <stdlib.h>             // for atol conversion  
#include "..\filters.h"
#include "common.h"
#include "encoder.h" 
#include "resource.h"


    typedef double SBS[2][3][SCALE_BLOCK][SBLIMIT];
    SBS  FAR        *sb_sample;
typedef double JSBS[3][SCALE_BLOCK][SBLIMIT];
    JSBS FAR        *j_sample;
typedef double IN[2][HAN_SIZE];
    IN   FAR        *win_que;
typedef unsigned int SUB[2][3][SCALE_BLOCK][SBLIMIT];
    SUB  FAR        *subband;
 
    frame_params fr_ps;
    layer info;
    char original_file_name[MAX_NAME_SIZE];
    char encoded_file_name[MAX_NAME_SIZE];
    short FAR **win_buf;
static short FAR buffer[2][1152];
static unsigned int bit_alloc[2][SBLIMIT], scfsi[2][SBLIMIT];
static unsigned int scalar[2][3][SBLIMIT], j_scale[3][SBLIMIT];
static double FAR ltmin[2][SBLIMIT], lgmin[2][SBLIMIT], max_sc[2][SBLIMIT];
    FLOAT snr32[32];
    short sam[2][1056];
    int whole_SpF, extra_slot = 0;
    double avg_slots_per_frame, frac_SpF, slot_lag;
    int model, stereo, error_protection;
static unsigned int crc;
    int i, j, k, adb;
    unsigned long bitsPerSlot, samplesPerFrame, frameNum = 0;
    unsigned long frameBits, sentBits = 0;
    unsigned long num_samples;
    
    Bit_stream_struc   bs;
    
    
typedef struct output_tag  // any special vars associated with output file
	{long lSize;
	} MYOUTPUT;

typedef struct input_tag // any special vars associated with input file
	{long lSize; 
	 DWORD options;
	} MYINPUT;

/****************************************************************************/
//      LibMain
//
//      PURPOSE:  Standard LibMain called from LIBENTRY.OBJ
//         
/****************************************************************************/

HANDLE myInstance=NULL;

int FAR PASCAL LibMain(HANDLE hModule, WORD wDataSeg, WORD cbHeapSize, LPSTR lpszCmdLine)
{   myInstance=hModule;
    return 1;
}


/****************************************************************************/
//    WEP
//
//    PURPOSE:  No tasks to unload.  Returns success.
//
/*****************************************************************************/

int FAR PASCAL __export _WEP (int bSystemExit)
{   myInstance=NULL;
    return(1);
}

// Fill COOLQUERY structure with information regarding this file filter

int FAR PASCAL __export QueryCoolFilter(COOLQUERY far * cq)
{   lstrcpy(cq->szName,"MPEG");         
	lstrcpy(cq->szCopyright,"MPEG II Encoder (GNU General Public License)");
	
	lstrcpy(cq->szExt,"MPG"); 
	cq->lChunkSize=16384; 
	cq->dwFlags=QF_RATEADJUSTABLE|QF_CANSAVE|QF_HASOPTIONSBOX;
	cq->Stereo8=0; 
	cq->Stereo16=R_32075|R_44100|R_48000;
	cq->Stereo24=0;
	cq->Stereo32=0;
	cq->Mono8=0; 
	cq->Mono16=R_32075|R_44100|R_48000;
	cq->Mono24=0;
	cq->Mono32=0;
	cq->Quad32=0;
	cq->Quad16=0;
	cq->Quad8=0;
	return C_VALIDLIBRARY;
}

long FAR PASCAL __export FilterGetFileSize(HANDLE hInput)
{       long lSize=0L;
	//char m[50];
	//wsprintf(m,"FilterGetSize: Handle=%04X\n",hInput);
	//OutputDebugString(m);
	if (hInput)
	{       MYINPUT far *mi;
		mi=(MYINPUT far *)GlobalLock(hInput);
		lSize=mi->lSize;
		//wsprintf(m,"FilterGetSize: Size = %ld\n",lSize);
		//OutputDebugString(m);
		GlobalUnlock(hInput);
	}
    return lSize;
}

BOOL FAR PASCAL __export FilterUnderstandsFormat(LPSTR filename)
{	//char m[100];
	//wsprintf(m,"Checking VOC support for %s\n",filename);
	//OutputDebugString(m);
	if ((filename[lstrlen(filename)-4]=='.') &&
	    (filename[lstrlen(filename)-3]=='M') &&
	    (filename[lstrlen(filename)-2]=='P') &&
	    (filename[lstrlen(filename)-1]=='G')    )
  	{	//OutputDebugString("Supported VOC!\n");
  		return TRUE;
  	}
  	return FALSE;
}


static long nDialogReturn=0L; 
#define MPEG_LAYER1 1
#define MPEG_LAYER2 2
#define MPEG_MODEL1 4
#define MPEG_MODEL2 8
#define MPEG_EMPHANO 16
#define MPEG_EMPHA1 32
#define MPEG_EMPHA2 64
#define MPEG_JOINTSTEREO 128
#define MPEG_ERRORPROTECTION 0x010000
#define MPEG_COPYRIGHT		 0x020000
#define MPEG_ORIGINAL		 0x040000

static long lTheSamprate=44100L;
static WORD wTheChannels=2;

DWORD FAR PASCAL __export FilterGetOptions(HWND hWnd, HINSTANCE hInst, long lSamprate, WORD wChannels, WORD wBitsPerSample, DWORD dwDefaults) // return 0 if no options box
{   int nRc;
	FARPROC lpfnDIALOGMsgProc;
	
	lpfnDIALOGMsgProc = GetProcAddress(hInst,(LPCSTR)MAKELONG(20,0));			
			
	
	if (dwDefaults==0)
		nDialogReturn=MPEG_LAYER2|MPEG_MODEL2|MPEG_EMPHANO|(9<<8)|MPEG_ORIGINAL;
	else
		nDialogReturn=dwDefaults;
		
	lTheSamprate=lSamprate;
	wTheChannels=wChannels;
	
	nRc = DialogBox((HINSTANCE)hInst,(LPCSTR)MAKEINTRESOURCE(IDD_MPEG), (HWND)hWnd, (DLGPROC)lpfnDIALOGMsgProc);
	
	if (!nRc)
	   return 0;
	else
		return nDialogReturn;
}

long totalread=0;
long mysum=0;

DWORD FAR PASCAL __export FilterCanWriteSpecial(HANDLE hOutput, DWORD idType)
{
 return 0L;
}

DWORD FAR PASCAL __export FilterCanReadSpecial(HANDLE hInput, DWORD idType)
{
 return 0L;
}
					 
DWORD FAR PASCAL __export FilterWriteSpecial(HANDLE hOutput, DWORD idType, unsigned char far *buf, DWORD dwSize)
{
 return 0L;
}

DWORD FAR PASCAL __export FilterReadSpecial(HANDLE hOutput, DWORD idType, unsigned char far *buf, DWORD dwSize)
{
 return 0L;
}

HANDLE hMemory=NULL;
unsigned char far *memory=NULL;
long bbuflen=0;
long bbufat=0;

int doing8bit=0;

HANDLE FAR PASCAL __export OpenFilterOutput(LPSTR lpstrFilename,long lSamprate,WORD wBitsPerSample,WORD wChannels,long lSize,long far *lpChunkSize,DWORD dwOptions)
{   HANDLE hOutput;
	int compression;  
	int errorprot=0;
	int copyright=0;
	int original=0;
	//char m[100];
    char lpszFilename[128];
	
	if (dwOptions==0)
		dwOptions=MPEG_LAYER2|MPEG_MODEL2|MPEG_EMPHANO|(9<<8)|MPEG_ORIGINAL;

	if (wBitsPerSample==8) 
    	doing8bit=1;
    	
	compression=(int)((dwOptions>>8)&0x0F);
	if (dwOptions&MPEG_ERRORPROTECTION)
		errorprot=1;
	if (dwOptions&MPEG_COPYRIGHT)
		copyright=1;
	if (dwOptions&MPEG_ORIGINAL)
		original=1;
	
	
	{//char m[100];
     //wsprintf(m,"My instance = %04X\n",myInstance);
     //OutputDebugString(m);
     GetModuleFileName(myInstance,(LPSTR)lpszFilename,128);
     //OutputDebugString(lpszFilename);
     //OutputDebugString("\n");
     lstrcpy(_fstrrchr((LPSTR)lpszFilename,'\\'),"\\MPEG.DAT");
    };
    
    if (table_ready(lpszFilename)==1)  // davej@microsoft.com compiled data files into one
    {	char m[100];
     	wsprintf(m,"Could not open %s!\n",(LPSTR)lpszFilename);
     	OutputDebugString(m);
     	return NULL;
    }
   	
	hOutput=GlobalAlloc(GMEM_MOVEABLE|GMEM_SHARE,sizeof(MYOUTPUT));
    if (hOutput)
    {   MYOUTPUT far *mo;
	mo=(MYOUTPUT far *)GlobalLock(hOutput);
	mo->lSize=lSize;

    *lpChunkSize=8192;  
    num_samples=(unsigned long)(lSize/2); // over size of sample
    if (doing8bit)
    {	*lpChunkSize=4096;
     	num_samples=(unsigned long)(lSize); 
    }
    
    //wsprintf(m,"OpenFilterOutput, size = %ld samples\n",lSize);
    //OutputDebugString(m);
   
   
    if (lSamprate<=32075) info.sampling_frequency = 2;
    else if (lSamprate<=44100) info.sampling_frequency = 0;
    else if (lSamprate<=48000) info.sampling_frequency = 1;
    else info.sampling_frequency = 1;
  	    
    
    if (dwOptions&MPEG_LAYER1)
    	info.lay = 1;
    else
    	info.lay = 2;
    
    if (dwOptions&MPEG_MODEL1)
    	model=1;
    else
    	model=2;
    
    if (dwOptions&MPEG_EMPHA1)
    	info.emphasis = 1;
    else if (dwOptions&MPEG_EMPHA2)
    	info.emphasis = 3;
    else	              
    	info.emphasis = 0;
        
    if (wChannels==2)
   	{	info.mode = MPG_MD_STEREO; 
   		info.mode_ext = 0;
   		if (dwOptions&MPEG_JOINTSTEREO)
   			info.mode=MPG_MD_JOINT_STEREO;
   	}
   	else
   	{	info.mode = MPG_MD_MONO; 
   		info.mode_ext = 0;
   	}
   	
    info.bitrate_index = compression;
    
    // ask for this in the future.
    info.extension = 0;
    info.error_protection = errorprot;
    info.copyright = copyright;
    info.original = original;
    lstrcpy(encoded_file_name,lpstrFilename);
    
    open_bit_stream_w(&bs, encoded_file_name, BUFFER_SIZE);
     
    sb_sample = (SBS FAR *) mem_alloc(sizeof(SBS), "sb_sample");
    j_sample = (JSBS FAR *) mem_alloc(sizeof(JSBS), "j_sample");
    win_que = (IN FAR *) mem_alloc(sizeof(IN), "Win_que");
    subband = (SUB FAR *) mem_alloc(sizeof(SUB),"subband");
    win_buf = (short FAR **) mem_alloc(sizeof(short *)*2, "win_buf");
 
    /* clear buffers */
    memset((char *) buffer, 0, sizeof(buffer));
    memset((char *) bit_alloc, 0, sizeof(bit_alloc));
    memset((char *) scalar, 0, sizeof(scalar));
    memset((char *) j_scale, 0, sizeof(j_scale));
    memset((char *) scfsi, 0, sizeof(scfsi));
    memset((char *) ltmin, 0, sizeof(ltmin));
    memset((char *) lgmin, 0, sizeof(lgmin));
    memset((char *) max_sc, 0, sizeof(max_sc));
    memset((char *) snr32, 0, sizeof(snr32));
    memset((char *) sam, 0, sizeof(sam));
 
    fr_ps.header = &info;
    fr_ps.tab_num = -1;             /* no table loaded */
    fr_ps.alloc = NULL;
    info.version = MPEG_AUDIO_ID;

    hdr_to_frps(&fr_ps);
    stereo = fr_ps.stereo;
    error_protection = info.error_protection;
 
    if (info.lay == 1) { bitsPerSlot = 32; samplesPerFrame = 384;  }
    else               { bitsPerSlot = 8;  samplesPerFrame = 1152; }
    /* Figure average number of 'slots' per frame. */
    /* Bitrate means TOTAL for both channels, not per side. */
    avg_slots_per_frame = ((double)samplesPerFrame /
                           s_freq[info.sampling_frequency]) *
                          ((double)bitrate[info.lay-1][info.bitrate_index] /
                           (double)bitsPerSlot);
    whole_SpF = (int) avg_slots_per_frame;
    
    //wsprintf(m,"slots/frame = %d\n",whole_SpF);
    //OutputDebugString(m);
    
    frac_SpF  = avg_slots_per_frame - (double)whole_SpF;
    slot_lag  = -frac_SpF;
    
    //sprintf(m,"frac SpF=%.3f, tot bitrate=%d kbps, s freq=%.1f kHz\n",
    //       frac_SpF, bitrate[info.lay-1][info.bitrate_index],
    //       s_freq[info.sampling_frequency]);                          
     
    //OutputDebugString(m);      
 
    if (frac_SpF != 0)
       {//OutputDebugString("Fractional number of slots, padding required\n");
       }
    else info.padding = 0;
     
     //wsprintf(m,"Samples per Frame = %ld\n",(long)num_samples);
     //OutputDebugString(m);
    
    
	GlobalUnlock(hOutput);
    }
    
	hMemory=GlobalAlloc(GMEM_MOVEABLE,18000);
	memory=(unsigned char far *)GlobalLock(hMemory);
	bbuflen=0;
	bbufat=0;  
	totalread=0; 
	mysum=0;
    
    return hOutput;
}

void FAR PASCAL __export CloseFilterOutput(HANDLE hOutput)
{   //OutputDebugString("Closing Filter Output\n");
	if (hOutput)
	{   MYOUTPUT far *mo;
		mo=(MYOUTPUT far *)GlobalLock(hOutput);
		
		//OutputDebugString("Closing bitstream\n");
	    close_bit_stream_w(&bs);
	
		//OutputDebugString("Freeing old mems\n");
		mem_free((void **)&sb_sample);
	    mem_free((void **)&j_sample);
	    mem_free((void **)&win_que);
	    mem_free((void **)&subband);
	    mem_free((void **)&win_buf);
	    
	    //OutputDebugString("Unlocking and cleaning up\n");
    	GlobalUnlock(hOutput);
		GlobalFree(hOutput);
		GlobalUnlock(hMemory);
		GlobalFree(hMemory);
		hMemory=NULL;
		memory=NULL;
   	}
}

DWORD FAR PASCAL __export WriteFilterOutput(HANDLE hOutput, unsigned char far *buf, long lBytes)
{   DWORD written=0L;
	//char m[100];
	BOOL onlastone=FALSE;
	
	if (doing8bit)
		lBytes*=2;
	
	mysum+=lBytes;
	//wsprintf(m,"*** Total read = %ld (given=%ld), >> Words=%ld <<, num_samples=%ld  bbuflen=%ld, bbufat=%ld\n",
	//		   totalread,mysum,lBytes/2,num_samples,bbuflen,bbufat);
 	//OutputDebugString(m);
	if ((totalread+lBytes/2+(bbuflen-bbufat)/2)>=(long)num_samples) onlastone=TRUE;
	//if (onlastone)
	//	OutputDebugString("ON LAST ONE!\n");
	
	
	if (hOutput)
	{   MYOUTPUT far *mo;
		unsigned long samples_read;
		mo=(MYOUTPUT far *)GlobalLock(hOutput);
		// written=(DWORD)_lwrite(mo->nFile,buf,(UINT)lBytes);
	   
	   if (doing8bit)
	   {	int t;            
		    int half;                   
		    int q;
		    //char m[50];
		    half=(int)lBytes/2;
		    q=half-1;
		    //wsprintf(m,"In... lBytes-2 = %d\n",(int)(lBytes-2));
		    //OutputDebugString(m);
		    
		    _fmemset(memory+bbuflen,0,(int)lBytes);
		    //OutputDebugString("!");
		    for (t=(int)(lBytes-2);t>=0;t-=2)
		    {	*(memory+bbuflen+t+1)=*(buf+q)-128;
		    	q--;
		    }
	   		//OutputDebugString("out.\n");
	   }                                
	   
	   else
	   {
	   		_fmemcpy(memory+bbuflen,buf,(int)lBytes);
	   }
	   bbuflen+=lBytes;
	   	
	   
	   while (1)
	   {   
	
	
	 	if ((long)totalread >= (long)num_samples)
	       {    
	       		//OutputDebugString("Must be done totalread > num_samples\n");
	       		GlobalUnlock(hOutput);
				if (doing8bit)
					return written/2; 	
				else
					return written;
	       }
	   	
	
		   //wsprintf(m,"buflen now %ld, cursor at %ld\n",bbuflen,bbufat);
		   //OutputDebugString(m);
	   
	       if (bbufat >= bbuflen)
	       {    
	       		//OutputDebugString("Must be done bbufat > bbuflen\n");
	       		GlobalUnlock(hOutput);
				if (doing8bit)
					return written/2; 	
				else
					return written; 	
	       }
	   		
		   if ((bbuflen-bbufat<6000) && (!onlastone))
		   {	_fmemmove(memory,memory+bbufat,(int)(bbuflen-bbufat));
		   		bbuflen=bbuflen-bbufat;
		   		//wsprintf(m,"left to go < 2048, exiting (bbuflen = %ld)\n",bbuflen);
		   		//OutputDebugString(m);
		   		bbufat=0;    
		   		GlobalUnlock(hOutput);
		   		if (doing8bit)
					return written/2; 	
				else
					return written;
		   }
	   
	   //wsprintf(m,"Can read up to %ld samples OK (st=%d, lay=%d)\n",(bbuflen-bbufat)/2,stereo,info.lay);
	   //OutputDebugString(m);
	   
	   samples_read=get_audio(memory+bbufat, buffer, num_samples, stereo, info.lay);
	   
	   //wsprintf(m,"Actually read %ld samples\n",samples_read);
	   //OutputDebugString(m);
	   
	   totalread+=samples_read;
	   
	   if (samples_read==0) 
	   {	GlobalUnlock(hOutput);
			if (doing8bit)
					return written/2; 	
				else
					return written;
	   }
	   
	   written+=samples_read*2;
	   
	   bbufat+=samples_read*2;
	   //wsprintf(m,"Samples read = %ld\n",samples_read);
	   
       
       		
       //wsprintf(m, "{%4lu}", frameNum++);
       //OutputDebugString(m);
       win_buf[0] = &buffer[0][0];
       win_buf[1] = &buffer[1][0];
       if (frac_SpF != 0) {
          if (slot_lag > (frac_SpF-1.0) ) {
             slot_lag -= frac_SpF;
             extra_slot = 0;
             info.padding = 0;
             /*  printf("No padding for this frame\n"); */
          }
          else {
             extra_slot = 1;
             info.padding = 1;
             slot_lag += (1-frac_SpF);
             /*  printf("Padding for this frame\n");    */
          }
       }
       adb = (int)((long)(whole_SpF+extra_slot) * (long)bitsPerSlot);

       switch (info.lay) {
 
/***************************** Layer I **********************************/
 
          case 1 :
             for (j=0;j<SCALE_BLOCK;j++)
             for (k=0;k<stereo;k++) {
                window_subband(&win_buf[k], &(*win_que)[k][0], k);
                filter_subband(&(*win_que)[k][0], &(*sb_sample)[k][0][j][0]);
             }

             I_scale_factor_calc(*sb_sample, scalar, stereo);
             if(fr_ps.actual_mode == MPG_MD_JOINT_STEREO) {
                I_combine_LR(*sb_sample, *j_sample);
                I_scale_factor_calc(j_sample, &j_scale, 1);
             }
 
             put_scale(scalar, &fr_ps, max_sc);
 
             if (model == 1) I_Psycho_One(buffer, max_sc, ltmin, &fr_ps);
             else {
                for (k=0;k<stereo;k++) {
                   psycho_anal(&buffer[k][0],&sam[k][0], k, info.lay, snr32,
                               (FLOAT)s_freq[info.sampling_frequency]*1000);
                   for (i=0;i<SBLIMIT;i++) ltmin[k][i] = (double) snr32[i];
                }
             }
 
             I_main_bit_allocation(ltmin, bit_alloc, &adb, &fr_ps);
 
             if (error_protection) I_CRC_calc(&fr_ps, bit_alloc, &crc);
 
             encode_info(&fr_ps, &bs);
 
             if (error_protection) encode_CRC(crc, &bs);
 
             I_encode_bit_alloc(bit_alloc, &fr_ps, &bs);
             I_encode_scale(scalar, bit_alloc, &fr_ps, &bs);
             I_subband_quantization(scalar, *sb_sample, j_scale, *j_sample,
                                    bit_alloc, *subband, &fr_ps);
             I_sample_encoding(*subband, bit_alloc, &fr_ps, &bs);
             for (i=0;i<adb;i++) put1bit(&bs, 0);
          break;
 
/***************************** Layer 2 **********************************/
 
          case 2 :
             for (i=0;i<3;i++) for (j=0;j<SCALE_BLOCK;j++)
                for (k=0;k<stereo;k++) {
                   window_subband(&win_buf[k], &(*win_que)[k][0], k);
                   filter_subband(&(*win_que)[k][0], &(*sb_sample)[k][i][j][0]);
                }
 
                II_scale_factor_calc(*sb_sample, scalar, stereo, fr_ps.sblimit);
                pick_scale(scalar, &fr_ps, max_sc);
                if(fr_ps.actual_mode == MPG_MD_JOINT_STEREO) {
                   II_combine_LR(*sb_sample, *j_sample, fr_ps.sblimit);
                   II_scale_factor_calc(j_sample, &j_scale, 1, fr_ps.sblimit);
                }       /* this way we calculate more mono than we need */
                        /* but it is cheap */
 
                if (model == 1) II_Psycho_One(buffer, max_sc, ltmin, &fr_ps);
                else {
                   for (k=0;k<stereo;k++) {
                      psycho_anal(&buffer[k][0],&sam[k][0], k, 
                                 info.lay, snr32,
                                 (FLOAT)s_freq[info.sampling_frequency]*1000);
                      for (i=0;i<SBLIMIT;i++) ltmin[k][i] = (double) snr32[i];
                   }
                }
 
                II_transmission_pattern(scalar, scfsi, &fr_ps);
                II_main_bit_allocation(ltmin, scfsi, bit_alloc, &adb, &fr_ps);
 
                if (error_protection)
                   II_CRC_calc(&fr_ps, bit_alloc, scfsi, &crc);
 
                encode_info(&fr_ps, &bs);
 
                if (error_protection) encode_CRC(crc, &bs);
 
                II_encode_bit_alloc(bit_alloc, &fr_ps, &bs);
                II_encode_scale(bit_alloc, scfsi, scalar, &fr_ps, &bs);
                II_subband_quantization(scalar, *sb_sample, j_scale,
                                      *j_sample, bit_alloc, *subband, &fr_ps);
                II_sample_encoding(*subband, bit_alloc, &fr_ps, &bs);
                for (i=0;i<adb;i++) put1bit(&bs, 0);
          break;
 
/***************************** Layer 3 **********************************/

          case 3 : break;

       }
 
       frameBits = sstell(&bs) - sentBits;
       if(frameBits%bitsPerSlot)   /* a program failure */
          { char m[100];
          	wsprintf(m," (prog fail) Sent %ld bits = %ld slots plus %ld\n",
                  frameBits, frameBits/bitsPerSlot,
                  frameBits%bitsPerSlot); 
            OutputDebugString(m);
           }
       
       sentBits += frameBits;
       
       
       
       }
    

		
		GlobalUnlock(hOutput);
	}
	if (doing8bit)
					return written/2; 	
				else
					return written;
}




// return handle that will be passed in to close, and write routines
HANDLE FAR PASCAL __export OpenFilterInput( LPSTR lpstrFilename,
											long far *lSamprate,
											WORD far *wBitsPerSample,
											WORD far *wChannels,
											HWND hWnd,
											long far *lChunkSize)
{   
	return NULL;	
}

void FAR PASCAL __export CloseFilterInput(HANDLE hInput)
{   
	return;
}



DWORD FAR PASCAL __export ReadFilterInput(HANDLE hInput, unsigned char far *bufout, long lBytes)
{   
    return 0;
};


void SetBitrateBox(HWND hWndDlg)
{	int t;
  	int r;
  	long l;
  	
  	// 1=mono, 2=stereo, 3=both
  	int viableat[15] = {3,1,1,1,3,1,3,3,3,3,3,2,2,2,2};
     
   	if (IsDlgButtonChecked(hWndDlg,IDC_RADIO1))
   		r=0;
   	else
   		r=1;
    SendDlgItemMessage(hWndDlg,IDC_COMBO1,CB_RESETCONTENT,0,0L);       		
  	for (t=1;t<15;t++)
  	{	char str[128];
  	    int x,y;
  	    double bps;
          	    
 		if (bitrate[r][t]<100)
  	    	lstrcpy(str," ");
  	    else
  	    	lstrcpy(str,""); 
  	    l=lTheSamprate;
  	    if (l<=32075) 
  	    	l=32000;
  	    else if (l<=44100) 
  	    	l=44100;
  	    else if (l<=48000) 
  	    	l=48000;
  	    else l=48000;
  	     
  	    bps=(double)bitrate[r][t]*1024.0/(double)l;
  	    x=(int)bps;
  	    bps=bps-(double)x;
  	    y=(int)(bps*100);
  	    wsprintf(str+lstrlen(str),"%d K-bits/sec, %01d.%02d bits/sample",bitrate[r][t],x,y);
 		
 		if (r==1)
 			if (!(viableat[t]&wTheChannels))
 				wsprintf(str+lstrlen(str),"**");
 		
 		SendDlgItemMessage(hWndDlg,IDC_COMBO1,CB_ADDSTRING,0,(DWORD)(LPSTR)str);
 		
    }
 }
         

BOOL FAR PASCAL __export DIALOGMsgProc(HWND hWndDlg, WORD Message, WORD wParam, LONG lParam)
{//OutputDebugString("DIALOGMsgProc: inside\n");
 static int compression=0;
 
 switch(Message)
   {case WM_INITDIALOG:
         //OutputDebugString("DIALOGMsgProc: WM_CREATE\n");
         compression=(int)((nDialogReturn>>8)&0x0F)-1;
         if (nDialogReturn&MPEG_LAYER1)
         	CheckDlgButton(hWndDlg,IDC_RADIO1,TRUE);
         else
         	CheckDlgButton(hWndDlg,IDC_RADIO2,TRUE);
         if (nDialogReturn&MPEG_MODEL1)
         	CheckDlgButton(hWndDlg,IDC_RADIO4,TRUE);
         else
         	CheckDlgButton(hWndDlg,IDC_RADIO5,TRUE);
         if (nDialogReturn&MPEG_EMPHA1)
         	CheckDlgButton(hWndDlg,IDC_RADIO7,TRUE);
         else if (nDialogReturn&MPEG_EMPHA2)
         	CheckDlgButton(hWndDlg,IDC_RADIO8,TRUE);
         else
         	CheckDlgButton(hWndDlg,IDC_RADIO6,TRUE);
         if (nDialogReturn&MPEG_ERRORPROTECTION)
         	CheckDlgButton(hWndDlg,IDC_CHECK1,TRUE);
         if (nDialogReturn&MPEG_COPYRIGHT)
         	CheckDlgButton(hWndDlg,IDC_CHECK2,TRUE);
         if (nDialogReturn&MPEG_ORIGINAL)
         	CheckDlgButton(hWndDlg,IDC_CHECK3,TRUE);
         if (nDialogReturn&MPEG_JOINTSTEREO)
         	CheckDlgButton(hWndDlg,IDC_CHECK4,TRUE);
         if (wTheChannels==1)
         	EnableWindow(GetDlgItem(hWndDlg,IDC_CHECK4),FALSE);
         //int     bitrate[3][15] = {
         // {0,32,64,96,128,160,192,224,256,288,320,352,384,416,448},
         // {0,32,48,56,64,80,96,112,128,160,192,224,256,320,384},
         // {0,32,40,48,56,64,80,96,112,128,160,192,224,256,320}
        //};
         SetBitrateBox(hWndDlg);
         SendDlgItemMessage(hWndDlg,IDC_COMBO1,CB_SETCURSEL,(WORD)compression,0L);
         
         break; /* End of WM_INITDIALOG                                 */

    case WM_CLOSE:
         /* Closing the Dialog behaves the same as Cancel               */
         //OutputDebugString("DIALOGMsgProc: WM_CLOSE\n");
         PostMessage(hWndDlg, WM_COMMAND, IDCANCEL, 0L);
         break; /* End of WM_CLOSE                                      */

    case WM_COMMAND:
         switch(wParam)
           {case IDC_RADIO1:
            case IDC_RADIO2:
            {	int selected;
            	selected=(int)SendDlgItemMessage(hWndDlg,IDC_COMBO1,CB_GETCURSEL,0,0);
            	SetBitrateBox(hWndDlg);
         		SendDlgItemMessage(hWndDlg,IDC_COMBO1,CB_SETCURSEL,(WORD)selected,0L);
            	break;
            }
            case IDOK:
            	 {nDialogReturn=0;
            	  if (IsDlgButtonChecked(hWndDlg,IDC_RADIO1))
            	  {	nDialogReturn|=MPEG_LAYER1;
            	  }
            	  if (IsDlgButtonChecked(hWndDlg,IDC_RADIO2))
            	  {	nDialogReturn|=MPEG_LAYER2;
            	  }
            	  if (IsDlgButtonChecked(hWndDlg,IDC_RADIO4))
            	  {	nDialogReturn|=MPEG_MODEL1;
            	  }
            	  if (IsDlgButtonChecked(hWndDlg,IDC_RADIO5))
            	  {	nDialogReturn|=MPEG_MODEL2;
            	  }
            	  if (IsDlgButtonChecked(hWndDlg,IDC_RADIO6))
            	  {	nDialogReturn|=MPEG_EMPHANO;
            	  }
            	  if (IsDlgButtonChecked(hWndDlg,IDC_RADIO7))
            	  {	nDialogReturn|=MPEG_EMPHA1;
            	  }
            	  if (IsDlgButtonChecked(hWndDlg,IDC_RADIO8))
            	  {	nDialogReturn|=MPEG_EMPHA2;
            	  }
            	  compression=(int)SendDlgItemMessage(hWndDlg,IDC_COMBO1,CB_GETCURSEL,0,0)+1;
            	  nDialogReturn|=(((long)compression)<<8);
            	  if (IsDlgButtonChecked(hWndDlg,IDC_CHECK1))
            	  	nDialogReturn|=MPEG_ERRORPROTECTION;
            	  if (IsDlgButtonChecked(hWndDlg,IDC_CHECK2))
            	  	nDialogReturn|=MPEG_COPYRIGHT;
            	  if (IsDlgButtonChecked(hWndDlg,IDC_CHECK3))
            	  	nDialogReturn|=MPEG_ORIGINAL;
            	  if (IsDlgButtonChecked(hWndDlg,IDC_CHECK4))
            	  	nDialogReturn|=MPEG_JOINTSTEREO;
            	  	
            	  EndDialog(hWndDlg, TRUE);
            	 }
                 break;                                                    
            case IDCANCEL:
                 /* Ignore data values entered into the controls        */
                 /* and dismiss the dialog window returning FALSE       */
                 EndDialog(hWndDlg, FALSE);
                 break;
           }
         break;    /* End of WM_COMMAND                                 */

    default:
        return FALSE;
   }
 return TRUE;
} /* End of DIALOGSMsgProc                                      */
