// Routine for a sine and cosine of an angle lookup table
// Angles stored as values between 0 and 32767
// Date 18/12/94

#define INTEGER_UNIT 3.051851e-5

signed int float_sin[] = { 0,572,1144,1715,2286,2856,3425,3993,
4560,5126,5690,6252,6813,7371,7927,8481,9032,9580,10126,
10668,11207,11743,12275,12803,13328,13848,14364,14876,
15383,15886,16384,16876,17364,17846,18323,18794,19260,
19720,20173,20621,21062,21497,21925,22347,22762,23170,
23571,23964,24351,24730,25101,25465,25821,26169,26509,
26841,27165,27481,27788,28087,28377,28659,28932,29196,
29451,29697,29934,30162,30381,30591,30791,30982,31163,
31335,31498,31650,31794,31927,32051,32165,32269,32364,
32448,32523,32588,32642,32687,32722,32747,32762,32767 };


// prototypes
//float f_cos(int degree);
//float f_sin(int degree);



// find the sine of an angle
float f_sin(int degree)
{
 degree %= 360;

 if (degree>=0 && degree <=90)
   return (float_sin[degree] * INTEGER_UNIT);
 if (degree>90 && degree <=180)
   return (float_sin[(180-degree)] * INTEGER_UNIT);
 if (degree>180 && degree <=270)
   return -(float_sin[(degree-180)] * INTEGER_UNIT);
 else
   return -(float_sin[(360-degree)] * INTEGER_UNIT);
}

// find the cosine of an angle
float f_cos(int degree)
{
 degree %= 360;

 if (degree>=0 && degree <=270)
   return f_sin(degree+90);
 else
   return f_sin(degree-270);
}

