{$M 16384,0,250000}

(*
      Library Benchmark v2.02
      (c) 1993,1994 Kevin Gliner
      All Rights Reserved
      Last Update:   4/ 4/94

      This program is freeware.  Permission is granted to distribute it
      freely so long as the contents (LBENCH2.EXE, LBENCH2.PAS, LBENCH2.DOC)
      remain together, intact, and unmodified.
*)

program LibraryBench;

uses crt,
     dos,

     {Metagraphics Units}
     metawin1,
     metawin2,

     {Genus Units}
     gx_tp,
     gr_tp,
     fx_tp,

     {Fastgraph Units}
     fgmain,
     fgmisc,
     fgpcx,
     fgbitmap,
     fgpr,
     fgsvga;

const
     BufMax                 = 3000;

     MaxTimes               = 150;
     MaxLibraries           = 3;

     Genus                  = 1;
     Fastgraph              = 2;
     Metagraphics           = 3;

     LibraryBenchmarkVersionString = 'Library Benchmark v2.02';
     CopyrightString               = '(c) 1993,1994 Kevin Gliner';
     RightsString                  = 'All Rights Reserved';
     LastUpdateString              = 'Last Update:  4/ 4/94';
     GenusVersionString            = 'Genus GX Kernel v2.00, GX Effects v2.02, GX Graphics v2.00';
     FastgraphVersionString        = 'Fastgraph v3.03';
     MetagraphicsVersionString     = 'Metagraphics MetaWINDOW-DOS v4.3D';

     Mode320x200x256        = 1;
     Mode640x480x16         = 2;
     Mode640x480x256        = 3;

type
    BufferType            = array[0..64012] of byte;
    BufferPtr             = ^BufferType;

var
   {Fastgraph Variables}
   FGBufferPtr              :BufferPtr;
   FGImagePtr               :pointer;
   FastgraphChipSet         :integer;
   New_Mode                 :integer;
   Old_Mode                 :integer;

   {Genus Variables}
   GenusBuffer              :GXHEADER;
   GenusTransparentBuffer   :GXHEADER;
   GenusImage               :FXIMAGE;
   Buffer                   :array[1..BufMax] of byte;
   PCXType                  :integer;
   GenusChipset             :integer;
   VesaInfo                 :GXVESAINFO;

   {Metagraphics Variables}
   MetagraphicsChipset      :integer;
   Rectangle                :Rect;
   MWBuffer                 :BufferPtr;
   MWMask                   :BufferPtr;
   MWMode                   :integer;

   rc                       :integer;
   c                        :char;
   x,y                      :word;

   Color                    :byte;

   Time                     :array[1..MaxLibraries,1..MaxTimes] of longint;

   RandomPoints             :array[1..10000,1..2] of byte;

procedure Error(LibraryNum,rc,Location:integer);
begin
     case LibraryNum of
          Genus:begin
               gxSetMode(gxText);
               writeln('Genus Error ',rc,' at ',Location);
          end;
          Fastgraph:begin
               fg_setmode(Old_Mode);
               fg_reset;
               writeln('Fastgraph Error ',rc,' at ',Location);
          end;
          Metagraphics:begin
               SetDisplay(TextPg0);
               StopGraphics;
               rc:=QueryError;
               writeln('Metagraphics Error ',rc,' at ',Location);
          end;
     end;
     halt;
end;{Error}

procedure ClearScreen(LibraryNum:integer);
begin
     case LibraryNum of
          Genus:begin
              rc:=gxClearDisplay(0,0);
          end;
          Fastgraph:begin
              fg_Erase;
          end;
          Metagraphics:begin
              SetRect(Rectangle,0,0,320,200);
              FillRect(Rectangle,0);
          end;
     end;
end;{ClearScreen}

procedure TestLibrary(LibraryNum,ModeNum:integer);
var x,y:word;

{-----------------------------------------------------------------------}

procedure StraightBlit(LibraryNum,XCoor,YCoor,Width,Height,Iterations,TimeSlot:integer);
var w,h:integer;
    x:word;
begin
     w:=Width-1;
     h:=Height-1;

     case LibraryNum of
          Genus:begin
                w:=XCoor + w;
                h:=YCoor + h;
                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iterations do begin
                    rc:=gxVirtualDisplay(GenusBuffer,0,0,XCoor,YCoor,w,h,0);
                end;
                Time[Genus,TimeSlot]:=gxGetTime;
          end;
          Fastgraph:begin
                w:=XCoor + w;
                h:=YCoor + h;
                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iterations do begin
                    fg_putblock(FGBufferPtr,XCoor,w,YCoor,h);
                end;
                Time[Fastgraph,TimeSlot]:=gxGetTime;
          end;
          Metagraphics:begin
                SetRect(Rectangle,XCoor,YCoor,XCoor+w,YCoor+h);
                ReadImage(Rectangle,MWBuffer);
                if ModeNum = Mode640x480x16 then begin
                   for x:=12 to 64012 do MWBuffer^[x]:=x div 256;
                end
                else begin
                   for x:=12 to 64012 do MWBuffer^[x]:=x mod 16;
                end;

                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iterations do begin
                    WriteImage(Rectangle,MWBuffer);
                end;
                Time[Metagraphics,TimeSlot]:=gxGetTime;
          end;
     end;

end;{StraightBlit}

procedure TransparentBlitTypical(LibraryNum,XCoor,YCoor,Width,Height,Iterations,TimeSlot:integer);
var w2,w,h:integer;
    x:word;
    OnScreen,OffScreen:grafPortPtr;
    XParRegion:RegionPtr;
    Rectangle:rect;
begin
     w:=Width-1;
     h:=Height-1;

     case LibraryNum of
          Genus:begin
                rc:=gxCreateVirtual(gxCMM,GenusTransparentBuffer,PCXType,Width,Height);

                rc:=gxClearVirtual(GenusTransparentBuffer,0);
                rc:=grSetActiveVirtual(GenusTransparentBuffer);
                rc:=grSetVirtual(gxTRUE);
                rc:=grSetFillStyle(grFSOLID,15,grOPAQUE);
                rc:=grDrawRect(Width div 4,0,w - (Width div 4),h,grFILL);
                rc:=grSetFillStyle(grFSOLID,14,grOPAQUE);
                rc:=grDrawRect(Width div 4,0,w - (Width div 4),h,grOUTLINE);
                rc:=grSetVirtual(gxFALSE);
                rc:=fxSetKeyColor(0);
                rc:=fxCreateImage(GenusImage,GenusTransparentBuffer,gxCMM);

                rc:=gxClearDisplay(0,0);
                rc:=grSetFillStyle(grFSOLID,5,grOPAQUE);
                rc:=grDrawRect(XCoor,YCoor,XCoor + w,YCoor + h,grFILL);
                rc:=grSetFillStyle(grFSOLID,7,grOPAQUE);
                rc:=grDrawRect(XCoor,YCoor,XCoor + w,YCoor + h,grOUTLINE);
                rc:=gxBeginTimer(gxHighRes);

                for x:=1 to Iterations do begin
                    rc:=fxPutImage(GenusImage,XCoor,0,0);
                end;
                Time[Genus,TimeSlot]:=gxGetTime;

                rc:=fxDestroyImage(GenusImage);
                rc:=gxDestroyVirtual(GenusTransparentBuffer);
          end;
          Fastgraph:begin

                FGImagePtr:=FGBufferPtr;
                if ModeNum = Mode640x480x16 then begin
                   w2:=(Width div 2);if (Width mod 2) = 1 then w2:=w2+1;
                end
                else w2:=Width;

                fg_Erase;

                fg_SetColor(15);
                fg_Rect(XCoor + (Width div 4),XCoor+w-(Width div 4),YCoor,YCoor+h);
                fg_SetColor(14);
                fg_Box(XCoor + (Width div 4),XCoor+w-(Width div 4),YCoor,YCoor+h);

                fg_Move(XCoor,YCoor + h);
                fg_GetImage(FGImagePtr^,w2,Height);

                fg_Erase;

                fg_SetColor(5);
                fg_Rect(XCoor,XCoor+w,YCoor,YCoor+h);
                fg_SetColor(6);
                fg_Box(XCoor,XCoor+w,YCoor,YCoor+h);

                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iterations do begin
                    fg_DrwImage(FGImagePtr^,w2,Height);
                end;
                Time[Fastgraph,TimeSlot]:=gxGetTime;

          end;
          Metagraphics:begin

                (*
                GetPort( OnScreen );
                OffScreen := CreateBitmap( cMEMORY, Width, Height );
                SetPort( OffScreen );
                EraseRect( Offscreen^.portRect );
                SetRect( Rectangle, Width div 4, 0, w - (Width div 4), h );
                PenColor( 15 );
                FillRect( Rectangle, 1);
                PenColor( 14 );
                FrameRect( Rectangle );
                XParRegion := CreateRegion( NULL, 0);

                SetPort( OnScreen );
		            ClipRegion ( XParRegion );

                gxBeginTimer( gxHighRes );
		            for x:=1 to Iterations do begin
                    CopyBlit( OffScreen, OnScreen, Rectangle, Rectangle );
		            end;
                Time[Metagraphics,TimeSlot] := gxGetTime;

                DestroyRegion( XParRegion );
                DestroyBitmap( OffScreen );
                *)

                Time[Metagraphics,TimeSlot] := 0;
          end;
     end;

end;{TransparentBlitTypical}

procedure TransparentBlitWorst(LibraryNum,XCoor,YCoor,Width,Height,Iterations,TimeSlot:integer);
var w2,w,h:integer;
    x:word;
begin
     w:=Width-1;
     h:=Height-1;

     case LibraryNum of
          Genus:begin
                rc:=gxCreateVirtual(gxCMM,GenusTransparentBuffer,PCXType,Width,Height);

                rc:=gxClearVirtual(GenusTransparentBuffer,0);
                rc:=grSetActiveVirtual(GenusTransparentBuffer);
                rc:=grSetVirtual(gxTRUE);
                rc:=grSetColor(15);
                x:=0;
                while x<=w do begin
                      rc:=grMoveTo(x,0);
                      rc:=grLineTo(x,h - 1);
                      x:=x+2;
                end;
                rc:=grSetVirtual(gxFALSE);
                rc:=fxSetKeyColor(0);
                rc:=fxCreateImage(GenusImage,GenusTransparentBuffer,gxCMM);

                rc:=gxClearDisplay(0,0);
                rc:=grSetFillStyle(grFSOLID,7,grOPAQUE);
                rc:=grDrawRect(XCoor,YCoor,XCoor + w,YCoor + h,grOUTLINE);
                rc:=gxBeginTimer(gxHighRes);

                for x:=1 to Iterations do begin
                    rc:=fxPutImage(GenusImage,XCoor,0,0);
                end;
                Time[Genus,TimeSlot]:=gxGetTime;

                rc:=fxDestroyImage(GenusImage);
                rc:=gxDestroyVirtual(GenusTransparentBuffer);
          end;
          Fastgraph:begin

                FGImagePtr:=FGBufferPtr;
                if ModeNum = Mode640x480x16 then begin
                   w2:=(Width div 2);if (Width mod 2) = 1 then w2:=w2+1;
                end
                else w2:=Width;

                fg_Erase;

                fg_SetColor(15);
                x:=0;
                while x<=w do begin
                      fg_Move(x,0);
                      fg_Draw(x,h - 1);
                      x:=x+2;
                end;

                fg_Move(XCoor,YCoor + h);
                fg_GetImage(FGImagePtr^,w2,Height);

                fg_Erase;

                fg_SetColor(5);
                fg_Rect(XCoor,XCoor+w,YCoor,YCoor+h);
                fg_SetColor(6);
                fg_Box(XCoor,XCoor+w,YCoor,YCoor+h);

                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iterations do begin
                    fg_DrwImage(FGImagePtr^,w2,Height);
                end;
                Time[Fastgraph,TimeSlot]:=gxGetTime;

          end;
          Metagraphics:begin
                (*
                *)
                Time[Metagraphics,TimeSlot]:=0;
          end;
     end;

end;{TransparentBlitWorst}

procedure EmptyRectangle(LibraryNum,XCoor,YCoor,Width,Height,Iterations,TimeSlot:integer);
var w,h:integer;
    x:word;
begin
     w:=Width-1;
     h:=Height-1;

     case LibraryNum of
          Genus:begin
                rc:=grSetColor(Color);

                w:=XCoor + w;
                h:=YCoor + h;
                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iterations do begin
                    rc:=grDrawRect(XCoor,YCoor,w,h,grOUTLINE);
                end;
                Time[Genus,TimeSlot]:=gxGetTime;
          end;
          Fastgraph:begin
                fg_SetColor(Color);

                w:=XCoor + w;
                h:=YCoor + h;
                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iterations do begin
                    fg_Box(XCoor,w,YCoor,h);
                end;
                Time[Fastgraph,TimeSlot]:=gxGetTime;
          end;
          Metagraphics:begin
                PenColor(Color);
                SetRect(Rectangle,XCoor,YCoor,XCoor+w,YCoor+h);

                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iterations do begin
                    FrameRect(Rectangle);
                end;
                Time[Metagraphics,TimeSlot]:=gxGetTime;
          end;
     end;

     Color:=Color+1;
     if Color > 15 then Color:=1;

end;{EmptyRectangle}

procedure FillRectangle(LibraryNum,XCoor,YCoor,Width,Height,Iterations,TimeSlot:integer);
var w,h:integer;
    x:word;
begin
     w:=Width-1;
     h:=Height-1;

     case LibraryNum of
          Genus:begin
                rc:=grSetFillStyle(grFSOLID,Color,grOPAQUE);

                w:=XCoor + w;
                h:=YCoor + h;
                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iterations do begin
                    rc:=grDrawRect(XCoor,YCoor,w,h,grFILL);
                end;
                Time[Genus,TimeSlot]:=gxGetTime;
          end;
          Fastgraph:begin
                fg_SetColor(Color);

                w:=XCoor + w;
                h:=YCoor + h;
                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iterations do begin
                    fg_Rect(XCoor,w,YCoor,h);
                end;
                Time[Fastgraph,TimeSlot]:=gxGetTime;
          end;
          Metagraphics:begin
                PenColor(Color);
                SetRect(Rectangle,XCoor,YCoor,XCoor+w+1,YCoor+h+1);

                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iterations do begin
                    FillRect(Rectangle,1);
                end;
                Time[Metagraphics,TimeSlot]:=gxGetTime;
          end;
     end;

     Color:=Color+1;
     if Color > 15 then Color:=1;

end;{FillRectangle}

procedure VerticalLine(LibraryNum,XCoor,YCoor,Length,Iterations,TimeSlot:integer);
var l,Iteration2:integer;
    x:word;
begin
     Iteration2:=Iterations div 2;
     l:=Length-1;

     case LibraryNum of
          Genus:begin
                rc:=grSetColor(Color);
                rc:=grMoveTo(XCoor,YCoor);

                l:=YCoor+l;
                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iteration2 do begin
                    rc:=grLineTo(XCoor,l);
                    rc:=grLineTo(XCoor,YCoor);
                end;
                Time[Genus,TimeSlot]:=gxGetTime;
          end;
          Fastgraph:begin
                fg_SetColor(Color);
                fg_Move(XCoor,YCoor);

                l:=YCoor+l;
                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iteration2 do begin
                    fg_Draw(XCoor,l);
                    fg_Draw(XCoor,YCoor);
                end;
                Time[Fastgraph,TimeSlot]:=gxGetTime;
          end;
          Metagraphics:begin
                PenColor(Color);
                MoveTo(XCoor,YCoor);

                l:=YCoor+l;
                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iteration2 do begin
                    LineTo(XCoor,l);
                    LineTo(XCoor,YCoor);
                end;
                Time[Metagraphics,TimeSlot]:=gxGetTime;
          end;
     end;

     Color:=Color+1;
     if Color > 15 then Color:=1;

end;{VerticalLine}

procedure HorizontalLine(LibraryNum,XCoor,YCoor,Length,Iterations,TimeSlot:integer);
var l,Iteration2:integer;
    x:word;
begin
     Iteration2:=Iterations div 2;
     l:=Length-1;

     case LibraryNum of
          Genus:begin
                rc:=grSetColor(Color);
                rc:=grMoveTo(XCoor,YCoor);

                l:=XCoor+l;
                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iteration2 do begin
                    rc:=grLineTo(l,YCoor);
                    rc:=grLineTo(XCoor,YCoor);
                end;
                Time[Genus,TimeSlot]:=gxGetTime;
          end;
          Fastgraph:begin
                fg_SetColor(Color);
                fg_Move(XCoor,YCoor);

                l:=XCoor+l;
                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iteration2 do begin
                    fg_Draw(l,YCoor);
                    fg_Draw(XCoor,YCoor);
                end;
                Time[Fastgraph,TimeSlot]:=gxGetTime;
          end;
          Metagraphics:begin
                PenColor(Color);
                MoveTo(XCoor,YCoor);

                l:=XCoor+l;
                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iteration2 do begin
                    LineTo(l,YCoor);
                    LineTo(XCoor,YCoor);
                end;
                Time[Metagraphics,TimeSlot]:=gxGetTime;
          end;
     end;

     Color:=Color+1;
     if Color > 15 then Color:=1;

end;{HorizontalLine}

procedure DiagonalLine(LibraryNum,Length,Iterations,TimeSlot:integer);
var l,l2,Iteration2:integer;
    x:word;
begin
     Iteration2:=Iterations div 2;
     l:=Length-1;
     l2:=Length div 2;

     case LibraryNum of
          Genus:begin
                rc:=grSetColor(Color);
                rc:=grMoveTo(0,0);

                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iteration2 do begin
                    rc:=grLineTo(l,l2);
                    rc:=grLineTo(0,0);
                end;
                Time[Genus,TimeSlot]:=gxGetTime;
          end;
          Fastgraph:begin
                fg_SetColor(Color);
                fg_Move(0,0);

                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iteration2 do begin
                    fg_Draw(l,l2);
                    fg_Draw(0,0);
                end;
                Time[Fastgraph,TimeSlot]:=gxGetTime;
          end;
          Metagraphics:begin
                PenColor(Color);
                MoveTo(0,0);

                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iteration2 do begin
                    LineTo(l,l2);
                    LineTo(0,0);
                end;
                Time[Metagraphics,TimeSlot]:=gxGetTime;
          end;
     end;

     Color:=Color+1;
     if Color > 15 then Color:=1;

end;{DiagonalLine}

procedure MultipleLine(LibraryNum,Length,Iterations,TimeSlot:integer);
var a,l,Iteration2:integer;
    x:word;
begin
     Iteration2:=Iterations div 2;
     l:=Length-1;

     case LibraryNum of
          Genus:begin
                rc:=grSetColor(Color);
                rc:=grMoveTo(0,0);

                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iteration2 do begin
                    for a:=0 to l do begin
                        rc:=grLineTo(l,a);
                        rc:=grLineTo(0,0);
                    end;
                    for a:=0 to l do begin
                        rc:=grLineTo(a,l);
                        rc:=grLineTo(0,0);
                    end;
                end;
                Time[Genus,TimeSlot]:=gxGetTime;
          end;
          Fastgraph:begin
                fg_SetColor(Color);
                fg_Move(0,0);

                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iteration2 do begin
                    for a:=0 to l do begin
                        fg_Draw(l,a);
                        fg_Draw(0,0);
                    end;
                    for a:=0 to l do begin
                        fg_Draw(a,l);
                        fg_Draw(0,0);
                    end;
                end;
                Time[Fastgraph,TimeSlot]:=gxGetTime;
          end;
          Metagraphics:begin
                PenColor(Color);
                MoveTo(0,0);

                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iteration2 do begin
                    for a:=0 to l do begin
                        LineTo(l,a);
                        LineTo(0,0);
                    end;
                    for a:=0 to l do begin
                        LineTo(a,l);
                        LineTo(0,0);
                    end;
                end;
                Time[Metagraphics,TimeSlot]:=gxGetTime;
          end;
     end;

     Color:=Color+1;
     if Color > 15 then Color:=1;

end;{MultipleLine}

procedure SinglePixel(LibraryNum,Iterations,TimeSlot:integer);
var l:integer;
    x:word;
begin
     case LibraryNum of
          Genus:begin
                rc:=grSetColor(Color);

                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iterations do begin
                    rc:=grPutPixel(RandomPoints[x,1],RandomPoints[x,2],Color);
                end;
                Time[Genus,TimeSlot]:=gxGetTime;
          end;
          Fastgraph:begin
                fg_SetColor(Color);

                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iterations do begin
                    fg_Point(RandomPoints[x,1],RandomPoints[x,2]);
                end;
                Time[Fastgraph,TimeSlot]:=gxGetTime;
          end;
          Metagraphics:begin
                PenColor(Color);

                rc:=gxBeginTimer(gxHighRes);
                for x:=1 to Iterations do begin
                    SetPixel(RandomPoints[x,1],RandomPoints[x,2]);
                end;
                Time[Metagraphics,TimeSlot]:=gxGetTime;
          end;
     end;

     Color:=Color+1;
     if Color > 15 then Color:=1;

end;{SinglePixel}

{-------------------------------------------------------------------------}

begin

     {initialize graphics kernel and mode}
     case LibraryNum of
          Genus:begin
                case ModeNum of
                     Mode320x200x256:begin
                          PcxType:=gxVGA_13;
                     end;
                     Mode640x480x16 :begin
                          PcxType:=gxVGA_12;
                     end;
                     Mode640x480x256:begin
                          GenusChipSet:=0;
                          if GenusChipSet = 0 then begin
                             if (gxVESAInstalled(VesaInfo) = gxSUCCESS) then begin
                                GenusChipSet := chipVESA;
                             end
                             else begin
                                  writeln(output,'Genus unable to set VESA SVGA mode');
                                  halt;
                             end;
                          end;
                          gxSetChipSet(GenusChipSet);
                          PcxType:=gxVESA_101;
                     end;
                end;
                gxSetBuffer(@Buffer,BufMax);
                gxSetDisplay(PcxType);
                rc:=gxSetMode(gxGraphics);
                if rc<>0 then begin
                   writeln(output,'rc = ',rc);
                   halt;
                end;

                rc:=gxCreateVirtual(gxCMM,GenusBuffer,PCXtype,320,200);
                if rc<>0 then Error(LibraryNum,rc,1);

                rc:=grSetActiveVirtual(GenusBuffer);
                rc:=grSetVirtual(gxTRUE);
                for Color:=0 to 9 do begin
                    rc:=grSetFillStyle(grFSOLID,Color+1,grOPAQUE);
                    rc:=grDrawRect(0,(Color*20),319,(Color*20)+19,grFILL);
                end;
                rc:=grSetVirtual(gxFALSE);

                rc:=gxModeCheck(gxFALSE);
                rc:=gxRetraceCheck(gxFALSE);
          end;
          Fastgraph:begin
                case ModeNum of
                     Mode320x200x256:begin
                          New_Mode:=19;
                     end;
                     Mode640x480x16 :begin
                          New_Mode:=18;
                     end;
                     Mode640x480x256:begin
                          New_Mode:=25;
                          FastgraphChipSet:=fg_SVGAInit(1);
                          if FastgraphChipSet<>1 then begin
                             writeln(output,'Fastgraph unable to set VESA SVGA mode');
                             halt;
                          end;
                     end;
                end;

                Old_Mode:=fg_GetMode;
                fg_SetMode(New_Mode);

                getmem(FGBufferPtr,sizeof(FGBufferPtr^));
                if ModeNum = Mode640x480x16 then begin
                   for x:=0 to 63999 do FGBufferPtr^[x]:=x div 256;
                end
                else begin
                   for x:=0 to 63999 do FGBufferPtr^[x]:=x mod 16;
                end;

                fg_WaitVR(0);
          end;
          MetaGraphics:begin
                case ModeNum of
                     Mode320x200x256:begin
                         MWMode:=VGA320x200X;
                     end;
                     Mode640x480x16 :begin
                         MWMode:=VGA640x480;
                     end;
                     Mode640x480x256:begin
                         MWMode:=VESA640x480X;
                     end;
                end;
                rc:=InitGraphics(MWMode);
                if rc<>0 then begin
                   {rc:=QueryError;}
                   writeln(output,'MetaWINDOWS unable to set VESA SVGA mode');
                   writeln(output,'rc = ',rc);
                   halt;
                end;
                SetDisplay(GrafPg0);

                getmem(MWBuffer,sizeof(MWBuffer^));
                getmem(MWMask,sizeof(MWMask^));

          end;
     end;

     {byte-aligned}
     StraightBlit(LibraryNum,0,0,  8,  8,1000,  7);
     StraightBlit(LibraryNum,0,0, 16, 16,1000,  6);
     StraightBlit(LibraryNum,0,0, 32, 32, 100,  5);
     StraightBlit(LibraryNum,0,0, 64, 64, 100,  4);
     StraightBlit(LibraryNum,0,0,128,128,  10,  3);
     StraightBlit(LibraryNum,0,0,256,128,  10,  2);
     StraightBlit(LibraryNum,0,0,320,200,  10,  1);

     ClearScreen(LibraryNum);

     {non-byte-aligned}
     StraightBlit(LibraryNum,1,1,  7,  7,1000, 13);
     StraightBlit(LibraryNum,1,1, 15, 15,1000, 12);
     StraightBlit(LibraryNum,1,1, 31, 31, 100, 11);
     StraightBlit(LibraryNum,1,1, 63, 63, 100, 10);
     StraightBlit(LibraryNum,1,1,127,127,  10,  9);
     StraightBlit(LibraryNum,1,1,255,127,  10,  8);

     ClearScreen(LibraryNum);

     {byte-aligned}
     TransparentBlitTypical(LibraryNum,0,0,  8,  8,1000, 20);
     TransparentBlitTypical(LibraryNum,0,0, 16, 16,1000, 19);
     TransparentBlitTypical(LibraryNum,0,0, 32, 32, 100, 18);
     TransparentBlitTypical(LibraryNum,0,0, 64, 64, 100, 17);
     TransparentBlitTypical(LibraryNum,0,0,128,128,  10, 16);
     TransparentBlitTypical(LibraryNum,0,0,256,128,  10, 15);
     TransparentBlitTypical(LibraryNum,0,0,320,200,  10, 14);

     ClearScreen(LibraryNum);

     {non-byte-aligned}
     TransparentBlitTypical(LibraryNum,1,1,  7,  7,1000, 26);
     TransparentBlitTypical(LibraryNum,1,1, 15, 15,1000, 25);
     TransparentBlitTypical(LibraryNum,1,1, 31, 31, 100, 24);
     TransparentBlitTypical(LibraryNum,1,1, 63, 63, 100, 23);
     TransparentBlitTypical(LibraryNum,1,1,127,127,  10, 22);
     TransparentBlitTypical(LibraryNum,1,1,255,127,  10, 21);

     ClearScreen(LibraryNum);

     {byte-aligned}
     TransparentBlitWorst(LibraryNum,0,0,  8,  8,1000,120);
     TransparentBlitWorst(LibraryNum,0,0, 16, 16,1000,119);
     TransparentBlitWorst(LibraryNum,0,0, 32, 32, 100,118);
     TransparentBlitWorst(LibraryNum,0,0, 64, 64, 100,117);
     TransparentBlitWorst(LibraryNum,0,0,128,128,  10,116);
     TransparentBlitWorst(LibraryNum,0,0,256,128,  10,115);
     TransparentBlitWorst(LibraryNum,0,0,320,200,  10,114);

     ClearScreen(LibraryNum);

     {non-byte-aligned}
     TransparentBlitWorst(LibraryNum,1,1,  7,  7,1000,126);
     TransparentBlitWorst(LibraryNum,1,1, 15, 15,1000,125);
     TransparentBlitWorst(LibraryNum,1,1, 31, 31, 100,124);
     TransparentBlitWorst(LibraryNum,1,1, 63, 63, 100,123);
     TransparentBlitWorst(LibraryNum,1,1,127,127,  10,122);
     TransparentBlitWorst(LibraryNum,1,1,255,127,  10,121);

     ClearScreen(LibraryNum);

     {byte-aligned}
     EmptyRectangle(LibraryNum,0,0,320,200, 100, 27);
     EmptyRectangle(LibraryNum,0,0,256,128, 100, 28);
     EmptyRectangle(LibraryNum,0,0,128,128, 100, 29);
     EmptyRectangle(LibraryNum,0,0, 64, 64, 100, 30);
     EmptyRectangle(LibraryNum,0,0, 32, 32,1000, 31);
     EmptyRectangle(LibraryNum,0,0, 16, 16,1000, 32);
     EmptyRectangle(LibraryNum,0,0,  8,  8,1000, 33);

     ClearScreen(LibraryNum);

     {non-byte-aligned}
     EmptyRectangle(LibraryNum,1,1,255,127, 100, 34);
     EmptyRectangle(LibraryNum,1,1,127,127, 100, 35);
     EmptyRectangle(LibraryNum,1,1, 63, 63, 100, 36);
     EmptyRectangle(LibraryNum,1,1, 31, 31,1000, 37);
     EmptyRectangle(LibraryNum,1,1, 15, 15,1000, 38);
     EmptyRectangle(LibraryNum,1,1,  7,  7,1000, 39);

     ClearScreen(LibraryNum);

     {byte-aligned}
     FillRectangle(LibraryNum,0,0,320,200, 100, 40);
     FillRectangle(LibraryNum,0,0,256,128, 100, 41);
     FillRectangle(LibraryNum,0,0,128,128, 100, 42);
     FillRectangle(LibraryNum,0,0, 64, 64, 100, 43);
     FillRectangle(LibraryNum,0,0, 32, 32,1000, 44);
     FillRectangle(LibraryNum,0,0, 16, 16,1000, 45);
     FillRectangle(LibraryNum,0,0,  8,  8,1000, 46);

     ClearScreen(LibraryNum);

     {non-byte-aligned}
     FillRectangle(LibraryNum,1,1,255,125, 100, 47);
     FillRectangle(LibraryNum,1,1,127,127, 100, 48);
     FillRectangle(LibraryNum,1,1, 63, 63, 100, 49);
     FillRectangle(LibraryNum,1,1, 31, 31,1000, 50);
     FillRectangle(LibraryNum,1,1, 15, 15,1000, 51);
     FillRectangle(LibraryNum,1,1,  7,  7,1000, 52);

     ClearScreen(LibraryNum);

     {byte-aligned}
     VerticalLine(LibraryNum,0,0,200, 1000, 53);
     VerticalLine(LibraryNum,0,0,128, 1000, 54);
     VerticalLine(LibraryNum,0,0, 64, 1000, 55);
     VerticalLine(LibraryNum,0,0, 32, 1000, 56);
     VerticalLine(LibraryNum,0,0, 16,10000, 57);
     VerticalLine(LibraryNum,0,0,  8,10000, 58);

     ClearScreen(LibraryNum);

     {non-byte-aligned}
     VerticalLine(LibraryNum,1,1,199, 1000, 59);
     VerticalLine(LibraryNum,1,1,127, 1000, 60);
     VerticalLine(LibraryNum,1,1, 63, 1000, 61);
     VerticalLine(LibraryNum,1,1, 31, 1000, 62);
     VerticalLine(LibraryNum,1,1, 15,10000, 63);
     VerticalLine(LibraryNum,1,1,  7,10000, 64);

     ClearScreen(LibraryNum);

     {byte-aligned}
     HorizontalLine(LibraryNum,0,0,200, 1000, 65);
     HorizontalLine(LibraryNum,0,0,128, 1000, 66);
     HorizontalLine(LibraryNum,0,0, 64, 1000, 67);
     HorizontalLine(LibraryNum,0,0, 32, 1000, 68);
     HorizontalLine(LibraryNum,0,0, 16,10000, 69);
     HorizontalLine(LibraryNum,0,0,  8,10000, 70);

     ClearScreen(LibraryNum);

     {non-byte-aligned}
     HorizontalLine(LibraryNum,2,2,199, 1000, 71);
     HorizontalLine(LibraryNum,2,2,127, 1000, 72);
     HorizontalLine(LibraryNum,2,2, 63, 1000, 73);
     HorizontalLine(LibraryNum,2,2, 31, 1000, 74);
     HorizontalLine(LibraryNum,2,2, 15,10000, 75);
     HorizontalLine(LibraryNum,2,2,  7,10000, 76);

     ClearScreen(LibraryNum);

     DiagonalLine(LibraryNum,200, 1000, 77);
     DiagonalLine(LibraryNum,128, 1000, 78);
     DiagonalLine(LibraryNum, 64, 1000, 79);
     DiagonalLine(LibraryNum, 32, 1000, 80);
     DiagonalLine(LibraryNum, 16,10000, 81);
     DiagonalLine(LibraryNum,  8,10000, 82);

     ClearScreen(LibraryNum);

     MultipleLine(LibraryNum,200, 10, 83);
     MultipleLine(LibraryNum,128, 10, 84);
     MultipleLine(LibraryNum, 64, 10, 85);
     MultipleLine(LibraryNum, 32,100, 86);
     MultipleLine(LibraryNum, 16,100, 87);
     MultipleLine(LibraryNum,  8,100, 88);

     ClearScreen(LibraryNum);

     SinglePixel(LibraryNum,10000, 89);

     {shutdown graphics kernel and reset to text mode}
     case LibraryNum of
          Genus:begin
                rc:=gxDestroyVirtual(GenusBuffer);
                rc:=gxSetMode(gxText);
          end;
          Fastgraph:begin
                freemem(FGBufferPtr,sizeof(FGBufferPtr^));
                fg_SetMode(Old_Mode);
                fg_reset;
          end;
          Metagraphics:begin
                freemem(MWBuffer,sizeof(MWBuffer^));
                freemem(MWMask,sizeof(MWMask^));
                SetDisplay(TextPg0);
                StopGraphics;
          end;
     end;

end;{TestLibrary}

procedure WriteResults(ModeNum:integer);
var ResultFile:text;
    ModeString:string[40];

  procedure WriteResultLine(LineText:string;Iterations,TimeSlot:integer);
  begin
       write(ResultFile,LineText,', ',Iterations:5,' times     ');
       write(ResultFile,Time[Genus,TimeSlot]:5,'ms         ');
       write(ResultFile,Time[Fastgraph,TimeSlot]:5,'ms          ');
       writeln(ResultFile,Time[Metagraphics,Timeslot]:5,'ms');
  end;{WriteResultLine}

begin

     case ModeNum of
          Mode320x200x256:begin
               writeln(output,'Writing 320x200x256 results to LBENCH_A.DAT');
               assign(ResultFile,'lbench_a.dat');
               ModeString:='Mode 320x200x256';
          end;
          Mode640x480x16 :begin
               writeln(output,'Writing 640x480x16 results to LBENCH_B.DAT');
               assign(ResultFile,'lbench_b.dat');
               ModeString:='Mode 640x480x16';
          end;
          Mode640x480x256:begin
               writeln(output,'Writing 640x480x256 results to LBENCH_C.DAT');
               assign(ResultFile,'lbench_c.dat');
               ModeString:='Mode 640x480x256';
          end;
     end;
     rewrite(ResultFile);

     writeln(ResultFile,LibraryBenchmarkVersionString);
     writeln(ResultFile,CopyrightString);
     writeln(ResultFile,RightsString);
     writeln(ResultFile,LastUpdateString);
     writeln(ResultFile);
     writeln(ResultFile,GenusVersionString);
     writeln(ResultFile,FastgraphVersionString);
     writeln(resultFile,MetagraphicsVersionString);
     writeln(ResultFile);
     writeln(ResultFile,ModeString);
     writeln(ResultFile);

     writeln(ResultFile);
     writeln(ResultFile);
     writeln(ResultFile,'Straight Blit                Genus       Fastgraph       Metagraphics');
     writeln(ResultFile);
     writeln(ResultFile,'Byte-Aligned');
     WriteResultLine('320 x 200',  10,  1);
     WriteResultLine('256 x 128',  10,  2);
     WriteResultLine('128 x 128',  10,  3);
     WriteResultLine(' 64 x  64', 100,  4);
     WriteResultLine(' 32 x  32', 100,  5);
     WriteResultLine(' 16 x  16',1000,  6);
     WriteResultLine('  8 x   8',1000,  7);
     writeln(ResultFile,'Non-Byte-Aligned');
     WriteResultLine('255 x 127',  10,  8);
     WriteResultLine('127 x 127',  10,  9);
     WriteResultLine(' 63 x  63', 100, 10);
     WriteResultLine(' 31 x  31', 100, 11);
     WriteResultLine(' 15 x  15',1000, 12);
     WriteResultLine('  7 x   7',1000, 13);

     writeln(ResultFile);
     writeln(ResultFile);
     writeln(ResultFile,'Transparent Blit             Genus       Fastgraph       Metagraphics*');
     writeln(ResultFile,'Typical Case');
     writeln(ResultFile);
     writeln(ResultFile,'Byte-Aligned');
     WriteResultLine('320 x 200',  10, 14);
     WriteResultLine('256 x 128',  10, 15);
     WriteResultLine('128 x 128',  10, 16);
     WriteResultLine(' 64 x  64', 100, 17);
     WriteResultLine(' 32 x  32', 100, 18);
     WriteResultLine(' 16 x  16',1000, 19);
     WriteResultLine('  8 x   8',1000, 20);
     writeln(ResultFile,'Non-Byte-Aligned');
     WriteResultLine('255 x 127',  10, 21);
     WriteResultLine('127 x 127',  10, 22);
     WriteResultLine(' 63 x  63', 100, 23);
     WriteResultLine(' 31 x  31', 100, 24);
     WriteResultLine(' 15 x  15',1000, 25);
     WriteResultLine('  7 x   7',1000, 26);
     writeln(ResultFile);
     writeln(ResultFile,'* pending');

     writeln(ResultFile);
     writeln(ResultFile);
     writeln(ResultFile,'Transparent Blit             Genus       Fastgraph       Metagraphics*');
     writeln(ResultFile,'Worst Case');
     writeln(ResultFile);
     writeln(ResultFile,'Byte-Aligned');
     WriteResultLine('320 x 200',  10,114);
     WriteResultLine('256 x 128',  10,115);
     WriteResultLine('128 x 128',  10,116);
     WriteResultLine(' 64 x  64', 100,117);
     WriteResultLine(' 32 x  32', 100,118);
     WriteResultLine(' 16 x  16',1000,119);
     WriteResultLine('  8 x   8',1000,120);
     writeln(ResultFile,'Non-Byte-Aligned');
     WriteResultLine('255 x 127',  10,121);
     WriteResultLine('127 x 127',  10,122);
     WriteResultLine(' 63 x  63', 100,123);
     WriteResultLine(' 31 x  31', 100,124);
     WriteResultLine(' 15 x  15',1000,125);
     WriteResultLine('  7 x   7',1000,126);
     writeln(ResultFile);
     writeln(ResultFile,'* pending');

     writeln(ResultFile);
     writeln(ResultFile);
     writeln(ResultFile,'Rectangles, Unfilled         Genus       Fastgraph       Metagraphics');
     writeln(ResultFile);
     writeln(ResultFile,'Byte-Aligned');
     WriteResultLine('320 x 200', 100, 27);
     WriteResultLine('256 x 128', 100, 28);
     WriteResultLine('128 x 128', 100, 29);
     WriteResultLine(' 64 x  64', 100, 30);
     WriteResultLine(' 32 x  32',1000, 31);
     WriteResultLine(' 16 x  16',1000, 32);
     WriteResultLine('  8 x   8',1000, 33);
     writeln(ResultFile,'Non-Byte-Aligned');
     WriteResultLine('255 x 127', 100, 34);
     WriteResultLine('127 x 127', 100, 35);
     WriteResultLine(' 63 x  63', 100, 36);
     WriteResultLine(' 31 x  31',1000, 37);
     WriteResultLine(' 15 x  15',1000, 38);
     WriteResultLine('  7 x   7',1000, 39);

     writeln(ResultFile);
     writeln(ResultFile);
     writeln(ResultFile,'Rectangles, Filled           Genus       Fastgraph       Metagraphics');
     writeln(ResultFile);
     writeln(ResultFile,'Byte-Aligned');
     WriteResultLine('320 x 200', 100, 40);
     WriteResultLine('256 x 128', 100, 41);
     WriteResultLine('128 x 128', 100, 42);
     WriteResultLine(' 64 x  64', 100, 43);
     WriteResultLine(' 32 x  32',1000, 44);
     WriteResultLine(' 16 x  16',1000, 45);
     WriteResultLine('  8 x   8',1000, 46);
     writeln(ResultFile,'Non-Byte-Aligned');
     WriteResultLine('255 x 127', 100, 47);
     WriteResultLine('127 x 127', 100, 48);
     WriteResultLine(' 63 x  63', 100, 49);
     WriteResultLine(' 31 x  31',1000, 50);
     WriteResultLine(' 15 x  15',1000, 51);
     WriteResultLine('  7 x   7',1000, 52);

     writeln(ResultFile);
     writeln(ResultFile);
     writeln(ResultFile,'Vertical Lines               Genus       Fastgraph       Metagraphics');
     writeln(ResultFile);
     writeln(ResultFile,'Byte-Aligned');
     WriteResultLine('200 high ', 1000, 53);
     WriteResultLine('128 high ', 1000, 54);
     WriteResultLine(' 64 high ', 1000, 55);
     WriteResultLine(' 32 high ', 1000, 56);
     WriteResultLine(' 16 high ',10000, 57);
     WriteResultLine('  8 high ',10000, 58);
     writeln(ResultFile,'Non-Byte-Aligned');
     WriteResultLine('199 high ', 1000, 59);
     WriteResultLine('127 high ', 1000, 60);
     WriteResultLine(' 63 high ', 1000, 61);
     WriteResultLine(' 31 high ', 1000, 62);
     WriteResultLine(' 15 high ',10000, 63);
     WriteResultLine('  7 high ',10000, 64);

     writeln(ResultFile);
     writeln(ResultFile);
     writeln(ResultFile,'Horizontal Lines             Genus       Fastgraph       Metagraphics');
     writeln(ResultFile);
     writeln(ResultFile,'Byte-Aligned');
     WriteResultLine('200 wide ', 1000, 65);
     WriteResultLine('128 wide ', 1000, 66);
     WriteResultLine(' 64 wide ', 1000, 67);
     WriteResultLine(' 32 wide ', 1000, 68);
     WriteResultLine(' 16 wide ',10000, 69);
     WriteResultLine('  8 wide ',10000, 70);
     writeln(ResultFile,'Non-Byte-Aligned');
     WriteResultLine('199 wide ', 1000, 71);
     WriteResultLine('127 wide ', 1000, 72);
     WriteResultLine(' 63 wide ', 1000, 73);
     WriteResultLine(' 31 wide ', 1000, 74);
     WriteResultLine(' 15 wide ',10000, 75);
     WriteResultLine('  7 wide ',10000, 76);

     writeln(ResultFile);
     writeln(ResultFile);
     writeln(ResultFile,'Diagonal Lines               Genus       Fastgraph       Metagraphics');
     writeln(ResultFile);
     WriteResultLine('200 x 100', 1000, 77);
     WriteResultLine('128 x  64', 1000, 78);
     WriteResultLine(' 64 x  32', 1000, 79);
     WriteResultLine(' 32 x  16', 1000, 80);
     WriteResultLine(' 16 x   8',10000, 81);
     WriteResultLine('  8 x   4',10000, 82);

     writeln(ResultFile);
     writeln(ResultFile);
     writeln(ResultFile,'Multiple Line Test           Genus       Fastgraph       Metagraphics');
     writeln(ResultFile);
     WriteResultLine('200 x 100',   10, 83);
     WriteResultLine('128 x  64',   10, 84);
     WriteResultLine(' 64 x  32',   10, 85);
     WriteResultLine(' 32 x  16',  100, 86);
     WriteResultLine(' 16 x   8',  100, 87);
     WriteResultLine('  8 x   4',  100, 88);

     writeln(ResultFile);
     writeln(ResultFile);
     writeln(ResultFile,'Single Pixel                 Genus       Fastgraph       Metagraphics');
     writeln(ResultFile);
     WriteResultLine('Random   ',10000,89);

     close(ResultFile);

     writeln(output);
     writeln(output,'Done!');
     writeln(output);

end;{WriteResults}

begin
     clrscr;
     writeln(output,LibraryBenchmarkVersionString);
     writeln(output,CopyrightString);
     writeln(output,RightsString);
     writeln(output,LastUpdateString);
     writeln;
     writeln(output,GenusVersionString);
     writeln(output,FastgraphVersionString);
     writeln(output,MetagraphicsVersionString);
     writeln;
     writeln('Press any key to begin...');

     c:=readkey;

     Color:=1;

     for x:=1 to 10000 do begin
         RandomPoints[x,1]:=random(300);
         RandomPoints[x,2]:=random(190);
     end;

     for x:=1 to MaxLibraries do for y:=1 to MaxTimes do Time[x,y]:=0;

     TestLibrary(Genus,Mode320x200x256);
     TestLibrary(Fastgraph,Mode320x200x256);
     TestLibrary(Metagraphics,Mode320x200x256);
     WriteResults(Mode320x200x256);

     TestLibrary(Genus,Mode640x480x16 );
     TestLibrary(Fastgraph,Mode640x480x16 );
     TestLibrary(Metagraphics,Mode640x480x16 );
     WriteResults(Mode640x480x16);

     TestLibrary(Genus,Mode640x480x256);
     TestLibrary(Fastgraph,Mode640x480x256);
     TestLibrary(Metagraphics,Mode640x480x256);
     WriteResults(Mode640x480x256);

end.