#include <stdio.h>
#include <graph.h>
#include <conio.h>
#include <malloc.h>
#include <string.h>
#include <dos.h>

#define byte unsigned char
#define word unsigned int

#define OFF 0
#define ON 1

#define FAILURE 0
#define SUCCESS 1

#define goto(x,y) _settextposition(y,x)

char path[]={""};

#include "font.h"
#include "graphics.h"
#include "palette.h"
#include "text.h"
#include "mouse.h"

#define MAX_TILES 256
#define X_MAX 8
#define Y_MAX 8

/****************************************************************************
function prototypes
****************************************************************************/

void set_screen(void);
byte allocate_memory(void);
void free_memory(void);

void init_mouse(void);

void refresh_picture(byte, byte);
void refresh_char_map(byte);

byte save(char *);
byte load(char *);

void insert(void);
void delete(void);

void update_color_info(byte);

/****************************************************************************
global variables
****************************************************************************/

byte huge *screen=(byte huge *)0xA0000000;

char palette_file[]={"mode13h"};
char font_file[]={"fnt8x8"};

byte xor[X_MAX]={1,2,4,8,16,32,64,128};

/****************************************************************************/

void main(void)
{
 int x=0, y=0;
 byte current_font=0, current_color=7;
 int a, b;
 int key=0;
 int tmp;

/****************************************************************************/

 if (allocate_memory()==FAILURE) goto END;

 if (read_font(font_file)==FAILURE)
  goto END;

 set_screen();

 if (read_palette(palette_file)==SUCCESS)
  set_palette();
 else getch();


 init_mouse();

/****************************************************************************/
/****************************************************************************/

 do
 {
  put_string(169,0,"   ",0,ERASE);
  put_number_i(169,0,(int)current_font,7,ERASE);
  put_number_i(145,8,(int)x,7,ERASE);
  put_number_i(185,8,(int)y,7,ERASE);
  put_string(80,192,"   ",0,ERASE);
  put_number_i(80,192,(int)current_color,7,ERASE);

  update_color_info(current_color);

  refresh_picture(current_font,current_color);
  _setcolor(7);
  _rectangle(_GBORDER,x*16+1,y*16+1,x*16+14,y*16+14);
  _rectangle(_GBORDER,(current_color-(current_color/32)*32)*4,
		      current_color/32*8+128,
		      (current_color-(current_color/32)*32)*4+3,
		      current_color/32*8+128+7);

  refresh_mouse();

/****************************************************************************/
  while (!kbhit())
  {
   palette_switch(252);

   update_color_info(current_color);

   hide_mouse();
   read_mouse();

   put_font((current_font-(current_font/16)*16)*8+192,current_font/16*8,
	    current_font,7,INVERSE);

/****************************************************************************/


    if (mouse_1)
    {

     refresh_picture(current_font,current_color);
     _setcolor(current_color);
     _rectangle(_GBORDER,(current_color-(current_color/32)*32)*4,
			 current_color/32*8+128,
			 (current_color-(current_color/32)*32)*4+3,
			 current_color/32*8+128+7);
     if (mouse_x<128)
     {
      if (mouse_y>127 && mouse_y<192)
      {
       current_color=(mouse_x/4)+((mouse_y-128)/8)*32;
       refresh_picture(current_font,current_color);
       refresh_char_map(current_color);
      }
      else if (mouse_y<128)
      {
       font[current_font][mouse_y/16]=
	font[current_font][mouse_y/16]^xor[mouse_x/16];
       refresh_picture(current_font,current_color);
      }
     }
     else if (mouse_x>=192)
     {
      if (mouse_y<128)
      {
       current_font=(mouse_x-192)/8+(mouse_y/8*16);
      }
     }
     else
     {
      if (mouse_y>=64 && mouse_y<72)
      {
       save(font_file);
      }
      else if (mouse_y>=72 && mouse_y<80)
      {
       load(font_file);refresh_char_map(current_color);
       refresh_picture(current_font,current_color);
      }
      else if (mouse_y>=80 && mouse_y<88)
      {
       write_palette(palette_file);
      }
      else if (mouse_y>=88 && mouse_y<96)
      {
       read_palette(palette_file);
       set_palette();
      }
      else if (mouse_x>=138 && mouse_x<144 && mouse_y>132 && mouse_y<=195)
      {
       palette[current_color*3+0]=195-mouse_y;
       set_palette();
      }
      else if (mouse_x>=154 && mouse_x<160 && mouse_y>132 && mouse_y<=195)
      {
       palette[current_color*3+1]=195-mouse_y;
       set_palette();
      }
      else if (mouse_x>=170 && mouse_x<176 && mouse_y>132 && mouse_y<=195)
      {
       palette[current_color*3+2]=195-mouse_y;
       set_palette();
      }
     }
     _setcolor(7);
     _rectangle(_GBORDER,x*16+1,y*16+1,x*16+14,y*16+14);
     _rectangle(_GBORDER,(current_color-(current_color/32)*32)*4,
			 current_color/32*8+128,
			 (current_color-(current_color/32)*32)*4+3,
			 current_color/32*8+128+7);

     put_string(169,0,"   ",0,ERASE);
     put_number_i(169,0,(int)current_font,7,ERASE);
     put_number_i(145,8,(int)x,7,ERASE);
     put_number_i(185,8,(int)y,7,ERASE);
     put_string(80,192,"   ",0,ERASE);
     put_number_i(80,192,(int)current_color,7,ERASE);
    }

/****************************************************************************/
   update_mouse();
   put_font((current_font-(current_font/16)*16)*8+192,current_font/16*8,
	    current_font,0,NORMAL);

  }

/****************************************************************************/
  hide_mouse();

  refresh_picture(current_font,current_color);
  _setcolor(current_color);
  _rectangle(_GBORDER,(current_color-(current_color/32)*32)*4,
		      current_color/32*8+128,
		      (current_color-(current_color/32)*32)*4+3,
		      current_color/32*8+128+7);

  key=getch();
  if (key==0)
  {
   key=getch();
   switch (key)
   {
    case 0x48: y--;break;
    case 0x50: y++;break;
    case 0x4b: x--;break;
    case 0x4d: x++;break;
   }
   _setcolor(0);
   for (a=0;a<3;a++)
   {
    tmp=(byte)(current_color);

   }
  }
  else
  {
   switch (key)
   {
    case ' ': font[current_font][y]=font[current_font][y]^xor[x];break;
    case '=':
    case '+': refresh_char_map(++current_color);break;
    case '-': refresh_char_map(--current_color);break;
    case '.':
    case '>': current_font++;
	      break;
    case ',':
    case '<': current_font--;
	      break;
    case 's': save(font_file);break;
    case 'l': load(font_file);refresh_char_map(current_color);
	      refresh_picture(current_font,current_color);break;
    case 'p': write_palette(palette_file);break;
    case 'g': read_palette(palette_file);set_palette();break;
    case 'i': for (b=255;b>current_font;b--)
	      {
	       for (a=0;a<8;a++)
	       {
		font[b][a]=font[b-1][a];
	       }
	      }
	      for (a=0;a<8;a++)
	       font[current_font][a]=0;
	      refresh_char_map(current_color);
	      refresh_picture(current_font,current_color);break;
    case 'd': for (b=current_font;b<255;b++)
	      {
	      for (a=0;a<8;a++)
	       font[b][a]=font[b+1][a];
	      }
	      for (a=0;a<8;a++)
	       font[255][a]=0;
	      refresh_char_map(current_color);
	      refresh_picture(current_font,current_color);break;
   }
  }

  if (y<0) y=Y_MAX-1;
  else if (y>=Y_MAX) y=0;
  if (x<0) x=X_MAX-1;
  else if (x>=X_MAX) x=0;

 } while (key!=27);

/****************************************************************************/

 _setvideomode(_DEFAULTMODE);

/****************************************************************************/
END:;
free_memory();

}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void set_screen(void)
{
 int a, b;

 _setvideomode(_MRES256COLOR);

 _setcolor(4);
 _rectangle(_GFILLINTERIOR,0,0,127,127);

 for (b=0;b<8;b++)
 {
  for (a=0;a<32;a++)
  {
   _setcolor(b*32+a);
   _rectangle(_GFILLINTERIOR,a*4,b*8+128,a*4+3,b*8+128+7);
  }
 }

 _setcolor(0);

 for (b=0;b<Y_MAX;b++)
 {
  for (a=0;a<X_MAX;a++)
  {
   _rectangle(_GFILLINTERIOR,a*16+1,b*16+1,a*16+14,b*16+14);
  }
 }

/****************************************************************************/
/* setup palette-information bar */
/****************************************************************************/

 _setcolor(4);
 _rectangle(_GFILLINTERIOR,128,128,128+56,199);

 for (a=0;a<3;a++)
 {
  _setcolor(0);
  _rectangle(_GFILLINTERIOR,139+a*16,132,145+a*16,195);
  _setcolor(7);
  _rectangle(_GBORDER,137+a*16,131,145+a*16,196);
 }

/****************************************************************************/

 for (b=0;b<16;b++)
 {
  for (a=0;a<16;a++)
  {
   put_font(a*8+192,b*8,(byte)(b*16+a),7,NORMAL);
  }
 }

/****************************************************************************/

 put_string(129,0,"font:",7,NORMAL);
 put_string(129,64,"[S]ave",7,NORMAL);
 put_string(129,72,"[L]oad",7,NORMAL);
 put_string(129,80,"Put Pal",7,NORMAL);
 put_string(129,88,"Get Pal",7,NORMAL);
 put_string(129,8,"x:  y:",7,NORMAL);
 put_string(8,192,"color is:",7,NORMAL);
 put_string(192,128,"total file space",7,NORMAL);
 put_string(240,136,"2048 bytes",7,NORMAL);
 put_string(200,144,"filename",7,NORMAL);
 put_string(256,152,font_file,7,NORMAL);
 put_string(192,160,"palette file",7,NORMAL);
 put_string(256,168,palette_file,7,NORMAL);

}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

byte allocate_memory(void)
{
 int a, b;

 font=(byte huge **)halloc((long)MAX_TILES,4);
 if (font==NULL)
 {
  printf("error allocating font pointers\n");
  return(FAILURE);
 }

 for (a=0;a<MAX_TILES;a++)
 {
  font[a]=(byte huge *)halloc((long)(8),1);
  if (font[a]==NULL) return(FAILURE);
 }

 mouse_cursor=(byte huge *)halloc((long)MOUSE_CURSOR_SIZE,1);
 mouse_background=(byte huge *)halloc((long)MOUSE_CURSOR_SIZE,1);

 return(SUCCESS);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void free_memory(void)
{
 int a, b;

 for (a=0;a<MAX_TILES;a++)
  if (font[a]!=NULL) hfree(font[a]);
 if (font!=NULL) hfree(font);

 if (mouse_cursor!=NULL) hfree(mouse_cursor);
 if (mouse_background!=NULL) hfree(mouse_background);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void init_mouse(void)
{
 byte tmp[]={1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	     1,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
	     1,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,
	     1,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,
	     1,7,1,7,7,1,0,0,0,0,0,0,0,0,0,0,
	     1,7,1,1,7,7,1,0,0,0,0,0,0,0,0,0,
	     1,7,1,0,1,7,7,1,0,0,0,0,0,0,0,0,
	     1,7,1,0,0,1,7,7,1,0,0,0,0,0,0,0,
	     1,7,1,0,0,0,1,7,7,1,0,0,0,0,0,0,
	     1,7,1,0,0,1,1,1,7,7,1,0,0,0,0,0,
	     1,7,1,0,1,7,7,7,7,7,7,1,0,0,0,0,
	     1,7,1,1,7,1,1,1,1,1,1,0,0,0,0,0,
	     1,7,1,7,1,0,0,0,0,0,0,0,0,0,0,0,
	     1,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,
	     1,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
	     1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 memcpy(mouse_cursor,tmp,256);
 read_mouse();
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void refresh_picture(byte current_font, byte current_color)
{
 int a, b, x, y;
 byte tmp;

 x=(current_font-(current_font/16)*16)*8+192;
 y=current_font/16*8;

 _setcolor(0);
 _rectangle(_GFILLINTERIOR,x,y,x+7,y+7);
 put_font(x,y,current_font,current_color,NORMAL);

 for (b=0;b<8;b++)
 {
  for (a=0;a<8;a++)
  {
   if ((tmp=font[current_font][b]&xor[a]))
    _setcolor(current_color);
   else
    _setcolor(0);

   _rectangle(_GFILLINTERIOR,a*16+1,b*16+1,a*16+14,b*16+14);
  }
 }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

byte load(char *filename)
{
 char buf[80];
 size_t itemsread;
 FILE *file;
 int a, b;

 sprintf(buf,"%s%s.fnt",path,filename);

 if ((file=fopen(buf,"rb"))==NULL)
 {
  printf("Unable to open %s for read.\n",buf);
  return (FAILURE);
 }
 for (a=0;a<256;a++)
  itemsread=fread(font[a],8,1,file);
 fclose(file);

 return(SUCCESS);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

byte save(char *filename)
{
 char buf[80];
 size_t items_written;
 FILE *file;
 int a;

 sprintf(buf,"%s%s.fnt",path,filename);

 if ((file=fopen(buf,"wb"))==NULL)
 {
  printf("Unable to open %s for write.\n",buf);
  return (FAILURE);
 }
 for (a=0;a<256;a++)
  items_written=fwrite(font[a],8,1,file);
 fclose(file);

 return(SUCCESS);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void refresh_char_map(byte current_color)
{
 int a, b;

 for (b=0;b<16;b++)
 {
  for (a=0;a<16;a++)
  {
   put_font(a*8+192,b*8,(byte)(b*16+a),current_color,ERASE);
  }
 }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void insert(void)
{

}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void update_color_info(byte color)
{
 int a, b;

 for (b=0;b<3;b++)
 {
  _setcolor(b*8+15);
  _rectangle(_GFILLINTERIOR,138+b*16,195,144+b*16,195-palette[color*3+b]);
  _setcolor(0);
  _rectangle(_GFILLINTERIOR,138+b*16,195-palette[color*3+b]-1,144+b*16,132);
 }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
