/* this program is designed (rather unprofessionaly, I might add *grin*) to
   edit/create a 256 8x8 pixel character set and also to allow crude 
   manipulation of a 256 color (768 byte) palette.  Thanks go to Jesus,
   Lord of Lords and King of Kings who, though some of you may not believe it,
   is due back VERY soon now to planet Earth.  .grin. */

/* oh, remember, this is in MS QuickC 2.5. */

#include <stdio.h>
#include <graph.h>
#include <conio.h>
#include <malloc.h>
#include <string.h>
#include <dos.h>

#define byte unsigned char
#define word unsigned int

/* I'm a sucker for those wordy #defines */

#define OFF 0
#define ON 1

#define FAILURE 0
#define SUCCESS 1

/* grin */

#define goto(x,y) _settextposition(y,x)

char path[]={""};

/* my own personal header files which also include the code for certain
   functions.  you should also find font and palette.h with this file. */


/* text does nothing yet - I lost my assembly get_key (which let me scan for
   keystrokes pretty niftily, IMO, without that wicked BEEP ... graphics has
   put_image() and defines the screen buffer which I don't use in this */

#include "font.h"
#include "graphics.h"
#include "palette.h"
#include "text.h"
#include "mouse.h"

#define MAX_TILES 256

/* characters=TILES */

#define X_MAX 8
#define Y_MAX 8

/****************************************************************************
function prototypes
****************************************************************************/

void set_screen(void);
byte allocate_memory(void);
void free_memory(void);

void init_mouse(void);

void refresh_picture(byte, byte);
void refresh_char_map(byte);

byte save(char *);
byte load(char *);

void insert(void);
void delete(void);

void update_color_info(byte);

/****************************************************************************
global variables
****************************************************************************/

byte huge *screen=(byte huge *)0xA0000000;

/* all my put_image() and put_font() functions throw things to the screen
   buffer I usually work with.  I was in a hurry so I didn't use it for
   make font.  make tile will, though... anyway, I trick my functions into
   thinking normal Video Memory is the off-screen buffer by assigning it
   as above */

char palette_file[]={"mode13h"};
char font_file[]={"fnt8x8"};

byte xor[X_MAX]={1,2,4,8,16,32,64,128};

/****************************************************************************/

void main(void)
{
 int x=0, y=0;
 byte current_font=0, current_color=7;
 int a, b;
 int key=0;
 int tmp;

/****************************************************************************/

/* setup memory (see below) */

 if (allocate_memory()==FAILURE) goto END;

/* read in the font ... oops, this means if you don't have a file called
   fnt8-8.fnt to start with it'll exit the program.  shrug.  :) */

 if (read_font(font_file)==FAILURE)
  goto END;

/* see below for this */

 set_screen();

/* read and set the palette. if no mode13h.pal exists, use default pal. */

 if (read_palette(palette_file)==SUCCESS)
  set_palette();
 else getch();


/* turn on the mouse_cursor (stuff defined in mouse.h) */
 init_mouse();

/****************************************************************************/
/****************************************************************************/

 do
 {
  put_string(169,0,"   ",0,ERASE);
  put_number_i(169,0,(int)current_font,7,ERASE);
  put_number_i(145,8,(int)x,7,ERASE);
  put_number_i(185,8,(int)y,7,ERASE);
  put_string(80,192,"   ",0,ERASE);
  put_number_i(80,192,(int)current_color,7,ERASE);

/* all the above just uses put_font in different ways (see font.h) to put
   some necessary info on the screen */

/* this updates the rgb information about your current color */

  update_color_info(current_color);

  refresh_picture(current_font,current_color);

/* and that updates the 8x8 grid */

/* this below just puts a box around the square you're in on the 8x8 grid
   and puts the white box around the current color */

  _setcolor(7);
  _rectangle(_GBORDER,x*16+1,y*16+1,x*16+14,y*16+14);
  _rectangle(_GBORDER,(current_color-(current_color/32)*32)*4,
		      current_color/32*8+128,
		      (current_color-(current_color/32)*32)*4+3,
		      current_color/32*8+128+7);

/* gets the background and puts it in mouse_background (defined in mouse.h
   which I haven't included...e-mail if you want more on it...it's not
   perfect, but it works */

  refresh_mouse();

/****************************************************************************/

/* wait for a keypress */

  while (!kbhit())
  {

/* rotate the palette (see palette.h) */

   palette_switch(252);

   update_color_info(current_color);


/* replace the mouse_cursor with mouse_background (Refreshed above) */

   hide_mouse();

/* put mouse info in mouse_x, _y, _1, _2, and _3 (found in mouse.h not 
   detailed here */

   read_mouse();

/* umm...what's this do...oh yeah.  draws the current_font over on the 16x16
   inversed, so you know which one you're on visually */

   put_font((current_font-(current_font/16)*16)*8+192,current_font/16*8,
	    current_font,7,INVERSE);

/****************************************************************************/

/* checks button 1 of mouse */

    if (mouse_1)
    {

/* update 8x8 grid and current_color (get rid of that white box around color)
*/

     refresh_picture(current_font,current_color);
     _setcolor(current_color);
     _rectangle(_GBORDER,(current_color-(current_color/32)*32)*4,
			 current_color/32*8+128,
			 (current_color-(current_color/32)*32)*4+3,
			 current_color/32*8+128+7);
     if (mouse_x<128)
     {

/* check if we're clicking in the color area (that 32x8 array of colored
   rectangles that represents the palette */

      if (mouse_y>127 && mouse_y<192)
      {

/* if so, set the color to the rectangle clicked in or on */

       current_color=(mouse_x/4)+((mouse_y-128)/8)*32;

/* and refresh the 8x8 grid AND the 16x16 (because otherwise, if you changed
   from white to red or something, everything would stay the same color) */

       refresh_picture(current_font,current_color);
       refresh_char_map(current_color);
      }

/* check if we're clicking on the 8x8 grid.  I don't recommend this, because
   (1) I didn't put a timer on the mouse so it's REALLY hard to get a certain
   state to stay and (2) because it's got 2 states, on or off, it's hard to
   draw with the mouse.  use the keyboard.  */

      else if (mouse_y<128)
      {

/* anyway, if we are, change the state of the pixel of the current font
   accordingly */

       font[current_font][mouse_y/16]=
	font[current_font][mouse_y/16]^xor[mouse_x/16];
       refresh_picture(current_font,current_color);
      }
     }
     else if (mouse_x>=192)
     {

/* if we click over on that 16x16 font-map, change the current font 
   accordingly */

      if (mouse_y<128)
      {
       current_font=(mouse_x-192)/8+(mouse_y/8*16);
      }
     }
     else
     {

/* if we click on the [S]ave thingy, do it... */

      if (mouse_y>=64 && mouse_y<72)
      {
       save(font_file);
      }

/* likewise, the [L]oad doo-hicker... */

      else if (mouse_y>=72 && mouse_y<80)
      {
       load(font_file);refresh_char_map(current_color);
       refresh_picture(current_font,current_color);
      }

/* Blah blah blah... */

      else if (mouse_y>=80 && mouse_y<88)
      {
       write_palette(palette_file);
      }

/* yawn :) */

      else if (mouse_y>=88 && mouse_y<96)
      {
       read_palette(palette_file);
       set_palette();
      }

/* umm...oh yeah.  if we click on the Red info bar...change the palette. */

      else if (mouse_x>=138 && mouse_x<144 && mouse_y>132 && mouse_y<=195)
      {
       palette[current_color*3+0]=195-mouse_y;
       set_palette();
      }

/* the green info bar... */

      else if (mouse_x>=154 && mouse_x<160 && mouse_y>132 && mouse_y<=195)
      {
       palette[current_color*3+1]=195-mouse_y;
       set_palette();
      }

/* the blue one. */

      else if (mouse_x>=170 && mouse_x<176 && mouse_y>132 && mouse_y<=195)
      {
       palette[current_color*3+2]=195-mouse_y;
       set_palette();
      }
     }

/* update screen things.  */

/* ok, ok.  put the white box back around your 8x8 grid location AND your
   current color. */

     _setcolor(7);
     _rectangle(_GBORDER,x*16+1,y*16+1,x*16+14,y*16+14);
     _rectangle(_GBORDER,(current_color-(current_color/32)*32)*4,
			 current_color/32*8+128,
			 (current_color-(current_color/32)*32)*4+3,
			 current_color/32*8+128+7);


/* and update the text in case you changed colors, locations, or font.  */

     put_string(169,0,"   ",0,ERASE);
     put_number_i(169,0,(int)current_font,7,ERASE);
     put_number_i(145,8,(int)x,7,ERASE);
     put_number_i(185,8,(int)y,7,ERASE);
     put_string(80,192,"   ",0,ERASE);
     put_number_i(80,192,(int)current_color,7,ERASE);
    }

/****************************************************************************/

/* umm...update the mouse.  :) */

   update_mouse();

/* erase the inversed font.  */

   put_font((current_font-(current_font/16)*16)*8+192,current_font/16*8,
	    current_font,0,NORMAL);

  }

/****************************************************************************/

/* replace mouse_cursor with mouse_background. haven't I said this once? :) */

  hide_mouse();

/* we did this stuff above, but that loop up there ^ is only for mouse.  if
   we push a key it drops out here... */

  refresh_picture(current_font,current_color);
  _setcolor(current_color);
  _rectangle(_GBORDER,(current_color-(current_color/32)*32)*4,
		      current_color/32*8+128,
		      (current_color-(current_color/32)*32)*4+3,
		      current_color/32*8+128+7);

/* fetch the key from the buffer. */

  key=getch();

/* if it's an extended key-code, get it and process... */

  if (key==0)
  {
   key=getch();
   switch (key)
   {

/* arrow keys */

    case 0x48: y--;break;
    case 0x50: y++;break;
    case 0x4b: x--;break;
    case 0x4d: x++;break;
   }
  }

/* other keys */

  else
  {
   switch (key)
   {

/* space sets or resets a pixel */

    case ' ': font[current_font][y]=font[current_font][y]^xor[x];break;

/* = or + and - changes the current color */

    case '=':
    case '+': refresh_char_map(++current_color);break;
    case '-': refresh_char_map(--current_color);break;

/* < and > change the current font */

    case '.':
    case '>': current_font++;
	      break;
    case ',':
    case '<': current_font--;
	      break;

/* you figure these out... :) */

    case 's': save(font_file);break;
    case 'l': load(font_file);refresh_char_map(current_color);
	      refresh_picture(current_font,current_color);break;
    case 'p': write_palette(palette_file);break;
    case 'g': read_palette(palette_file);set_palette();break;

/* insert - forget the functions...shrug I forgot to take them out */

    case 'i': for (b=255;b>current_font;b--)
	      {
	       for (a=0;a<8;a++)
	       {
		font[b][a]=font[b-1][a];
	       }
	      }
	      for (a=0;a<8;a++)
	       font[current_font][a]=0;
	      refresh_char_map(current_color);
	      refresh_picture(current_font,current_color);break;

/* delete */

    case 'd': for (b=current_font;b<255;b++)
	      {
	      for (a=0;a<8;a++)
	       font[b][a]=font[b+1][a];
	      }
	      for (a=0;a<8;a++)
	       font[255][a]=0;
	      refresh_char_map(current_color);
	      refresh_picture(current_font,current_color);break;
   }
  }

/* check bounds of cursor in 8x8 grid */

  if (y<0) y=Y_MAX-1;
  else if (y>=Y_MAX) y=0;
  if (x<0) x=X_MAX-1;
  else if (x>=X_MAX) x=0;


/* escape key (ESC) exits program */

 } while (key!=27);

/****************************************************************************/

 _setvideomode(_DEFAULTMODE);

/****************************************************************************/
END:;
free_memory();

}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void set_screen(void)
{
 int a, b;

 _setvideomode(_MRES256COLOR);

/* prepares to draw the 8x8 grid */

 _setcolor(4);
 _rectangle(_GFILLINTERIOR,0,0,127,127);


/* draws the palette boxes in respective colors */

 for (b=0;b<8;b++)
 {
  for (a=0;a<32;a++)
  {
   _setcolor(b*32+a);
   _rectangle(_GFILLINTERIOR,a*4,b*8+128,a*4+3,b*8+128+7);
  }
 }

/* punches squares in the 8x8 grid (it's grey and holes are black */

 _setcolor(0);

 for (b=0;b<Y_MAX;b++)
 {
  for (a=0;a<X_MAX;a++)
  {
   _rectangle(_GFILLINTERIOR,a*16+1,b*16+1,a*16+14,b*16+14);
  }
 }

/* don't ask why i stuck the palette boxes between the 8x8 grid drawing...
   i was in a hurry... :) */

/****************************************************************************/
/* setup palette-information bar */
/****************************************************************************/


/* this is the drawing part for the 3 palette bars (rgb). it just draws the
   area the info goes in.  */

 _setcolor(4);
 _rectangle(_GFILLINTERIOR,128,128,128+56,199);

 for (a=0;a<3;a++)
 {
  _setcolor(0);
  _rectangle(_GFILLINTERIOR,139+a*16,132,145+a*16,195);
  _setcolor(7);
  _rectangle(_GBORDER,137+a*16,131,145+a*16,196);
 }

/****************************************************************************/


/* this displays the font at the right of the screen in a 16x16 area. full-
   size. */

 for (b=0;b<16;b++)
 {
  for (a=0;a<16;a++)
  {
   put_font(a*8+192,b*8,(byte)(b*16+a),7,NORMAL);
  }
 }

/****************************************************************************/

/* text setup.  */

 put_string(129,0,"font:",7,NORMAL);
 put_string(129,64,"[S]ave",7,NORMAL);
 put_string(129,72,"[L]oad",7,NORMAL);
 put_string(129,80,"Put Pal",7,NORMAL);
 put_string(129,88,"Get Pal",7,NORMAL);
 put_string(129,8,"x:  y:",7,NORMAL);
 put_string(8,192,"color is:",7,NORMAL);
 put_string(192,128,"total file space",7,NORMAL);
 put_string(240,136,"2048 bytes",7,NORMAL);
 put_string(200,144,"filename",7,NORMAL);
 put_string(256,152,font_file,7,NORMAL);
 put_string(192,160,"palette file",7,NORMAL);
 put_string(256,168,palette_file,7,NORMAL);

}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

byte allocate_memory(void)
{
 int a, b;

/* i use huge memory models for everything, thus the hallocs.  */

/* font is declared in font.h */

 font=(byte huge **)halloc((long)MAX_TILES,4);
 if (font==NULL)
 {
  printf("error allocating font pointers\n");
  return(FAILURE);
 }

 for (a=0;a<MAX_TILES;a++)
 {
  font[a]=(byte huge *)halloc((long)(8),1);
  if (font[a]==NULL) return(FAILURE);
 }

/* this is for the mouse.  */

 mouse_cursor=(byte huge *)halloc((long)MOUSE_CURSOR_SIZE,1);
 mouse_background=(byte huge *)halloc((long)MOUSE_CURSOR_SIZE,1);

 return(SUCCESS);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void free_memory(void)
{
 int a, b;

 for (a=0;a<MAX_TILES;a++)
  if (font[a]!=NULL) hfree(font[a]);
 if (font!=NULL) hfree(font);

 if (mouse_cursor!=NULL) hfree(mouse_cursor);
 if (mouse_background!=NULL) hfree(mouse_background);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void init_mouse(void)
{
 byte tmp[]={1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	     1,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
	     1,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,
	     1,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,
	     1,7,1,7,7,1,0,0,0,0,0,0,0,0,0,0,
	     1,7,1,1,7,7,1,0,0,0,0,0,0,0,0,0,
	     1,7,1,0,1,7,7,1,0,0,0,0,0,0,0,0,
	     1,7,1,0,0,1,7,7,1,0,0,0,0,0,0,0,
	     1,7,1,0,0,0,1,7,7,1,0,0,0,0,0,0,
	     1,7,1,0,0,1,1,1,7,7,1,0,0,0,0,0,
	     1,7,1,0,1,7,7,7,7,7,7,1,0,0,0,0,
	     1,7,1,1,7,1,1,1,1,1,1,0,0,0,0,0,
	     1,7,1,7,1,0,0,0,0,0,0,0,0,0,0,0,
	     1,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,
	     1,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
	     1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 memcpy(mouse_cursor,tmp,256);
 read_mouse();
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void refresh_picture(byte current_font, byte current_color)
{
 int a, b, x, y;
 byte tmp;

/* this updates the 8x8 grid area */

 x=(current_font-(current_font/16)*16)*8+192;
 y=current_font/16*8;

 _setcolor(0);
 _rectangle(_GFILLINTERIOR,x,y,x+7,y+7);
 put_font(x,y,current_font,current_color,NORMAL);

 for (b=0;b<8;b++)
 {
  for (a=0;a<8;a++)
  {
   if ((tmp=font[current_font][b]&xor[a]))
    _setcolor(current_color);
   else
    _setcolor(0);

   _rectangle(_GFILLINTERIOR,a*16+1,b*16+1,a*16+14,b*16+14);
  }
 }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

byte load(char *filename)
{

/* loads the font */

 char buf[80];
 size_t itemsread;
 FILE *file;
 int a, b;

 sprintf(buf,"%s%s.fnt",path,filename);

 if ((file=fopen(buf,"rb"))==NULL)
 {
  printf("Unable to open %s for read.\n",buf);
  return (FAILURE);
 }
 for (a=0;a<256;a++)
  itemsread=fread(font[a],8,1,file);
 fclose(file);

 return(SUCCESS);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

byte save(char *filename)
{

/* ahem. */

 char buf[80];
 size_t items_written;
 FILE *file;
 int a;

 sprintf(buf,"%s%s.fnt",path,filename);

 if ((file=fopen(buf,"wb"))==NULL)
 {
  printf("Unable to open %s for write.\n",buf);
  return (FAILURE);
 }
 for (a=0;a<256;a++)
  items_written=fwrite(font[a],8,1,file);
 fclose(file);

 return(SUCCESS);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void refresh_char_map(byte current_color)
{
 int a, b;

/* updates the 16x16 font-'map' at the right of the screen. */

 for (b=0;b<16;b++)
 {
  for (a=0;a<16;a++)
  {
   put_font(a*8+192,b*8,(byte)(b*16+a),current_color,ERASE);
  }
 }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void insert(void)
{

}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void update_color_info(byte color)
{
 int a, b;

/* shows how much (0-63) of rgb of the current color. */

 for (b=0;b<3;b++)
 {
  _setcolor(b*8+15);
  _rectangle(_GFILLINTERIOR,138+b*16,195,144+b*16,195-palette[color*3+b]);
  _setcolor(0);
  _rectangle(_GFILLINTERIOR,138+b*16,195-palette[color*3+b]-1,144+b*16,132);
 }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

/* Dat's all folks. Like I said, I make no pretensions of guru-ness or 
   awesome coding skills. heh heh.  But what I wrote above and in the other
   .h files works for me so far...praise God!  I hope it can help somebody
   out there as well, if for nothing else than to show people how NOT to
   go about coding something! hee hee. */

#define MAXCOLORS 256

#ifndef d_word
 #define d_word unsigned long
#endif
#ifndef word
 #define word unsigned int
#endif
#ifndef byte
 #define byte unsigned char
#endif

/* sets interval at which the palette rotates */

#ifndef PALETTE_TIMER
 #define PALETTE_TIMER 250 /* in milliseconds */
#endif

#include <sys\timeb.h>

/* used by the rotation timer */

struct timeb time_pointer;
d_word old_palette_timer, palette_timer=0, max_palette_timer=PALETTE_TIMER;

/* the actual palette */

byte palette[768];
byte palette_flag=OFF;

/* reads a 768 byte 256 color palette */

byte read_palette(char *filename)
{
 char buf[80];
 size_t itemsread;
 FILE *file;

 sprintf(buf,"%s%s.pal",path,filename);

 if ((file=fopen(buf,"rb"))==NULL)
 {
  printf("Unable to open %s for read.\n",buf);
  return (FAILURE);
 }
 itemsread=fread(palette,3,MAXCOLORS,file);
 fclose(file);

 return(SUCCESS);
}

/* saves one */

byte write_palette(char *filename)
{
 char buf[80];
 size_t itemswritten;
 FILE *file;

 sprintf(buf,"%s%s.pal",path,filename);

 if ((file=fopen(buf,"wb"))==NULL)
 {
  printf("Unable to open palette file for write.");
  return (FAILURE);
 }
 itemswritten=fwrite(palette,3,MAXCOLORS,file);
 fclose(file);
 return(SUCCESS);
}

/* sets the palette */

void set_palette(void)
{
 union REGS regs;
 struct SREGS segs;

 char *pal=palette;

 regs.h.ah=0x10;
 regs.h.al=0x12;

 regs.x.bx=0;               // First color
 regs.x.cx=256;             // Number of colors
 segs.es=FP_SEG(pal);
 regs.x.dx=FP_OFF(pal);

 _asm
 {
		cli                     /* clear interrupts */
		mov       dx,03DAh      /* wait for vert. retrace */
  start:
		in        al,dx
		and       al,08h
		jnz       start
  mid:
		in        al,dx
		and       al,08h
		jz        mid

		sti                     /* restore interrupts */
 }

 palette_flag=ON;                       /* so mouse won't interrupt */

/* i say, 'so mouse won't interrupt' because in mouse.h's mouse_function
   it has a check for the global palette_flag and, if on, aborts itself...a
   cheesy way to do it, but...it works.  I know i'm supposed to do all this in
   assembly and thus avoid the prob' by putting everything before the 
   sti and instead of using int86 i'm supposed to write it directly to the
   video card...but these are old functions and my boss erased the hard 
   drive (all of them in the lab, in fact .grin.) before I could back it 
   up.  oh well. :) */

 int86x(0x10,&regs,&regs,&segs);
 palette_flag=OFF;                      /* re-enable mouse (see mouse.h) */
}

/* rotates the palette */

void palette_switch(byte start)
{
 union REGS regs;
 struct SREGS segs;
 word a, firstcolor, colors=4;
 byte tmpcolor[3];
 char *pal=palette;

 /* wait PALETTE_DELAY milliseconds before rotating palette */

 old_palette_timer=(d_word)(time_pointer.time*1000+time_pointer.millitm);
 ftime(&time_pointer);
 palette_timer+=(d_word)((time_pointer.time*1000+time_pointer.millitm)
	       -old_palette_timer);

 if (palette_timer>=max_palette_timer)
  max_palette_timer=(d_word)(palette_timer+PALETTE_TIMER);
 else return;

 /* rotate the palette */

 for (firstcolor=start;firstcolor<start+4;firstcolor+=4)
 {
  memcpy(tmpcolor,&palette[firstcolor*3],3);

  for (a=firstcolor;a<firstcolor+colors-1;a++)
   memmove(&palette[a*3],&palette[(a+1)*3],3);

  memcpy(&palette[(firstcolor+colors-1)*3],tmpcolor,3);
 }

 /* set up the registers now for the palette setting interrupt */

  regs.h.ah=0x10;
  regs.h.al=0x12;

  regs.x.bx=start;               // First color
  regs.x.cx=4;             // Number of colors
  segs.es=FP_SEG(pal);
  regs.x.dx=FP_OFF(pal)+start*3;

 _asm
 {
		cli
		mov       dx,03DAh              /* wait for vert. retrace */
  begin:
		in        al,dx
		and       al,08h
		jnz       begin
  mid:
		in        al,dx
		and       al,08h
		jz        mid

		sti
 }

 palette_flag=ON;                       /* disable the mouse */
 int86x(0x10,&regs,&regs,&segs);
 palette_flag=OFF;                      /* re-enable mouse (see mouse.h) */
}

void adjust_palette(byte shift)
{
 word a, b;

 for (a=0;a<768;a++)
  palette[a]=palette[a]>>shift;
}

/* make sure stdlib.h is in */

#ifndef _FAR_
 #include <stdlib.h>
#endif

#ifndef NORMAL
 #define INVERSE 0
 #define NORMAL 1
 #define MASK 2
 #define ERASE 3
 #define ERASE_INVERSE 4
#endif

#ifndef byte
 #define byte unsigned char
 #define word unsigned int
 #define d_word unsigned long
#endif

/* in case graphics.h is not going... */

#ifndef SCREEN
 #define SCREEN (byte huge *)0xA0000000
 byte huge *screen;
#endif

#define MAX_FONT_CHARS 8
#define FONT_CHAR_SIZE 8

byte huge **font;

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void put_font(int x, int y, byte ascii, byte color, byte option)
{

/* set up tileseg and tileoff with the segment and offset of the font */
/* scrnseg and scrnoff contain the segment and offset of the screen buffer
   which, if I assigned it to Video Mem, would be 0xA000 and 0x0000 
   respectively */

 word tileseg=FP_SEG(font[ascii]),
	 tileoff=FP_OFF(font[ascii]),
	 scrnseg=FP_SEG(screen),
	 scrnoff=FP_OFF(screen)+(y<<8)+(y<<6)+x;

/* normal just draws the character's on pixesl.  black is transparent. */

 if (option==NORMAL)
 {
  _asm
  {
/* save the data segment */

   push    ds

/* load ds:si register pair with segment and offset of font */

   mov     ax,[tileseg]
   mov     ds,ax
   mov     si,[tileoff]

/* likewise, load es:di register pair with segment:offset of where to
   put it */

   mov     ax,[scrnseg]
   mov     es,ax
   mov     di,[scrnoff]

/* Alow contains the color to draw the font with, and cx is our loop var. */

   mov     al,[color]
   mov     cx,8

   start:
   push    cx

/* get a byte of the font.  this is 8 pixels.  */

   mov     bl,[si]
   mov     cx,8

/* now we loop through the byte using a shift and draw each pixel. */

   mid:

/* copy the byte so we can keep the original. */

   mov     bh,bl

/* keep the 1st bit which is the pixel we wish to draw */

   and     bh,0x01

/* if the bit is 1, it is on, and so we draw it.  */

   dec     bh
   jz      draw

/* otherwise, skip and continue... */

   jmp     mid_end

   draw:

/* move the 'color' (which was in Alow) to the screen (buffer or wherever) */

   mov     es:[di],al

   mid_end:

/* shift the byte to the right.  it's like a conveyor belt...after we process
   each bit, we throw off the right-most one (or left-most; it depends how you
   look at it: I see it from right to left here...00000001 is 1, 00000010
   is 2, etc.) and take the next-leftmost bit. 10101010 would become 01010101
*/

   shr     bl,1

/* move over one pixel on the screen (where we're drawing) */

   inc     di

/* finish processing the remaining bits in the byte we fetched */

   loop    mid

/* ok, now we get the next byte */

   inc     si

/* and, to draw the next 8 pixels 'under' the 1st 8, we go DOWN 1 vertical
   screen row (+320 bytes) and subtract 8 horizontal pixels (-8 bytes). */

   add     di,312

   pop     cx

/* finished */

   loop start

   end:

/* restore data segment */

   pop     ds
  }
 }
 else if (option==INVERSE)
 {

/* this is basically the same as above... */

  _asm
  {
   push    ds

   mov     ax,[tileseg]
   mov     ds,ax
   mov     si,[tileoff]

   mov     ax,[scrnseg]
   mov     es,ax
   mov     di,[scrnoff]

   mov     al,[color]
   mov     cx,8

   start2:
   push    cx

   mov     bl,[si]
   mov     cx,8

   mid2:
   mov     bh,bl
   and     bh,0x01

/* but instead of drawing on 1, we draw on 0. 1's are transparent.  */

   dec     bh
   jnz     draw2
   jmp     mid_end2

   draw2:
   mov     es:[di],al

   mid_end2:
   shr     bl,1
   inc     di
   loop    mid2

   inc     si
   add     di,312

   pop     cx
   loop start2

   end2:
   pop     ds
  }
 }
 else if (option==ERASE)
 {

/* this is slightly different. we draw 1's, but ERASE 0's. */

  _asm
  {
   push    ds

   mov     ax,[tileseg]
   mov     ds,ax
   mov     si,[tileoff]

   mov     ax,[scrnseg]
   mov     es,ax
   mov     di,[scrnoff]

   mov     al,[color]
   mov     cx,8

   start3:
   push    cx

   mov     bl,[si]
   mov     cx,8

   mid3:
   mov     bh,bl
   and     bh,0x01
   dec     bh
   jz      draw3

/* go ahead and draw 1's, but... */

/* erase any 'off' pixels by a 0 to screen memory. */

   mov     es:[di],0
   jmp     mid_end3

   draw3:
   mov     es:[di],al

   mid_end3:
   shr     bl,1
   inc     di
   loop    mid3

   inc     si
   add     di,312

   pop     cx
   loop start3

   end3:
   pop     ds
  }
 }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

/* this just uses put_font() to display a string of charactes. */

void put_string(int x, int y, char *string, byte color, byte option)
{
 word a=0;

 while (string[a]!='\0')
 {
  put_font(x,y,string[a],color,option);
  x+=8;
  a++;
 }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

/* same here.  just display a string of numbers. */

void put_number_i(int x, int y, int number, byte color, byte option)
{
 word a=0;
 byte buf[17];

 itoa(number,buf,10);
 put_string(x,y,buf,color,option);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

/* reads a 256 character 8x8 font stored as 8 bytes per character */

byte read_font(char *filename)
{
 char buf[80];
 size_t itemsread;
 FILE *file;
 int a;

 sprintf(buf,"%s%s.fnt",path,filename);

 if ((file=fopen(buf,"rb"))==NULL)
 {
  printf("Unable to open %s for read.\n",buf);
  return (FAILURE);
 }
 for (a=0;a<256;a++)
 {
  itemsread=fread(font[a],1,8,file);
 }
 fclose(file);

 return(SUCCESS);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

/* writes one. */

byte write_font(char *filename)
{
 char buf[80];
 size_t items_written;
 FILE *file;
 int a;

 sprintf(buf,"%s%s.fnt",path,filename);

 if ((file=fopen(buf,"rb"))==NULL)
 {
  printf("Unable to open %s for write.\n",buf);
  return (FAILURE);
 }

 for (a=0;a<256;a++)
 {
  items_written=fread(font[a],1,8,file);
 }
 fclose(file);

 return(SUCCESS);
}

/* that's it for this file. hope it helps! */

/* oh what the heck...stupid of me NOT to include the rest of the .h's...*/

#define SET 1
#define NORMAL 1
#define MASK 2
#define ERASE 3

#ifndef byte
 #define byte unsigned char
#endif

#ifndef word
 #define word unsigned int
#endif

#define CLIP 0
#define OUT_CLIP 1
#define NO_CLIP 2

#define INVERSE 0

#define NORMAL_WINDOW 0
#define FILE_SELECT_WINDOW 1

#define FONTS 128
#define FONT_SIZE 8

#define SCREEN (byte huge *)0xA0000000

byte huge *screen;

byte huge *window;
word window_x, window_y, window_width, window_height;

word cos_table[256], sin_table[256], cos_table2[256], sin_table2[256];

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void put_image(int x, int y, byte huge *image,
	      word width, word height, word option)
{
 word value=(word)(y*320+x),
      tileseg=FP_SEG(image),
      tileoff=FP_OFF(image),
      scrnseg=FP_SEG(screen),
      scrnoff=FP_OFF(screen);

 if (option==NORMAL)
 {
  _asm
  {
   push    ds

   mov     ax,[tileseg]
   mov     ds,ax
   mov     si,[tileoff]

   mov     ax,[scrnseg]
   mov     es,ax
   mov     di,[scrnoff]
   add     di,[value]

   mov     cx,[height]

   mov     bx,[x]
   mov     dx,[y]

   start:
   cmp     dx,199
   jg      end

   push    cx

   cmp     dx,0
   jl      start_end

   mov     cx,[width]

   mid:
   cmp     bx,319
   jg      mid_end
   cmp     bx,0
   jl      mid_end

   mov     al,[si]
   mov     es:[di],al

   mid_end:
   inc     bx
   inc     di
   inc     si
   loop    mid

   sub     di,[width]

   start_end:
   add     di,320
   inc     dx
   mov     bx,[x]
   pop     cx

   loop    start

   end:
   pop     ds
  }
 }
 else if (option==MASK)
 {
  _asm
  {
   push   ds

   mov    ax,[tileseg]
   mov    ds,ax
   mov    si,[tileoff]

   mov    ax,[scrnseg]
   mov    es,ax
   mov    di,[scrnoff]
   add    di,[value]

   mov    bx,[x]
   mov    dx,[y]

   mov    cx,[height]

   star2:
   cmp    dx,199
   jg     mid6

   push   cx

   cmp    dx,0
   jl     mid4

   mov    cx,[width]

   mid2:
   cmp    bx,319
   jg     mid3
   cmp    bx,0
   jl     mid3

   mov    al,ds:[si]
   cmp    al,0
   je     mid3
   mov    es:[di],al

   mid3:
   inc    di
   inc    si
   inc    bx

   loop   mid2

   sub    di,[width]

   mid4:
   add    di,320
   inc    dx
   mov    bx,[x]

   pop    cx

   loop   star2

   mid6:
   pop ds
  }
 }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void get_image(int x, int y, byte huge *image, word width, word height)
{
 word value=(word)(y*320+x),
      tileseg=FP_SEG(image),
      tileoff=FP_OFF(image),
      scrnseg=FP_SEG(screen),
      scrnoff=FP_OFF(screen);

 _asm
  {
   push    ds

   mov     ax,[tileseg]
   mov     ds,ax
   mov     si,[tileoff]

   mov     ax,[scrnseg]
   mov     es,ax
   mov     di,[scrnoff]
   add     di,[value]

   mov     cx,[height]

   mov     bx,[x]
   mov     dx,[y]

   start:
   cmp     dx,199
   jg      end

   push    cx

   cmp     dx,0
   jl      start_end

   mov     cx,[width]

   mid:
   cmp     bx,319
   jg      mid_end
   cmp     bx,0
   jl      mid_end

   mov     al,es:[di]
   mov     [si],al

   mid_end:
   inc     bx
   inc     di
   inc     si
   loop    mid

   sub     di,[width]

   start_end:
   add     di,320
   inc     dx
   mov     bx,[x]
   pop     cx

   loop    start

   end:
   pop     ds
  }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void put_rotated(int scrn_x, int scrn_y, byte huge *image, byte option,
		 byte angle,
		 word x_left, word y_top, word x_right, word y_bottom)
{
 word right_x=(word)(cos_table[angle]);
 word right_y=(word)(sin_table[angle]);
 word down_x=(word)(cos_table2[angle]);
 word down_y=(word)(sin_table2[angle]);

 word x=(8<<8)-(right_x<<3)-(down_x<<3);
 word y=(8<<8)+(right_y<<3)+(down_y<<3);
 word ox=x, oy=y;

 word scrn_seg=FP_SEG(screen);
 word scrn_off=(scrn_y<<8)+(scrn_y<<6)+scrn_x;

 word image_seg=FP_SEG(image);
 word image_off=FP_OFF(image);

 word x_clip=scrn_x;
 word old_x_clip=x_clip;
 word y_clip=scrn_y;

 if (option==CLIP)
 {
  _asm
  {
   push  ds

   mov   ax,[image_seg]
   mov   ds,ax

   mov   ax,[scrn_seg]
   mov   es,ax
   mov   di,[scrn_off]

   mov   ax,[x]
   mov   dx,[y]

   mov   cx,16

   start:
   mov   bx,[y_clip]
   cmp   bx,[y_bottom]
   jl    start_mid
   jmp   end

   start_mid:
   push  cx

   cmp   bx,[y_top]
   jle   startend

   mov   cx,16

   mid:
   cmp   ah,0
   jl    midend
   cmp   ah,15
   jg    midend
   cmp   dh,0
   jl    midend
   cmp   dh,15
   jg    midend

   mov   bx,[x_clip]
   cmp   bx,[x_left]
   jle   midend
   cmp   bx,[x_right]
   jge   midend

   mov   si,[image_off]
   mov   bl,dh
   shl   bl,1
   shl   bl,1
   shl   bl,1
   shl   bl,1
   add   bl,ah
   and   bh,0x00
   add   si,bx

   mov   bl,[si]
   dec   bl
   dec   bl
   jz    nodraw
   inc   bl
   inc   bl

   mov   es:[di],bl

   midend:
   nodraw:

   add   ax,[right_x]
   sub   dx,[right_y]
   inc   di
   inc   [x_clip]

   loop mid

   sub   di,16

   startend:
   add   di,320
   inc   [y_clip]
   mov   ax,[old_x_clip]
   mov   [x_clip],ax

   mov   ax,[ox]
   mov   dx,[oy]
   add   ax,[down_x]
   sub   dx,[down_y]
   mov   [ox],ax
   mov   [oy],dx

   pop   cx

   dec   cx
   jz    end
   jmp   start

   end:
   pop   ds
  }
 }
 else if (option==OUT_CLIP)
 {
  _asm
  {
   push  ds

   mov   ax,[image_seg]
   mov   ds,ax

   mov   ax,[scrn_seg]
   mov   es,ax
   mov   di,[scrn_off]

   mov   ax,[x]
   mov   dx,[y]

   mov   cx,16

   start2:
   push  cx

   mov   cx,16

   mid2:
   cmp   ah,0
   jl    midend2
   cmp   ah,15
   jg    midend2
   cmp   dh,0
   jl    midend2
   cmp   dh,15
   jg    midend2

   mov   bx,[y_clip]
   cmp   bx,[y_top]
   jl    mid3
   cmp   bx,[y_bottom]
   jg    mid3

   mov   bx,[x_clip]
   cmp   bx,[x_left]
   jl    mid3
   cmp   bx,[x_right]
   jle    midend2

   mid3:
   mov   si,[image_off]
   mov   bl,dh
   shl   bl,1
   shl   bl,1
   shl   bl,1
   shl   bl,1
   add   bl,ah
   and   bh,0x00
   add   si,bx

   mov   bl,[si]
   dec   bl
   dec   bl
   jz    midend2
   inc   bl
   inc   bl
   mov   es:[di],bl

   midend2:
   sub   ax,[right_x]
   add   dx,[right_y]
   inc   di
   inc   [x_clip]

   loop mid2

   sub   di,16

   startend2:
   add   di,320
   inc   [y_clip]
   mov   ax,[old_x_clip]
   mov   [x_clip],ax

   mov   ax,[ox]
   mov   dx,[oy]
   sub   ax,[down_x]
   add   dx,[down_y]
   mov   [ox],ax
   mov   [oy],dx

   pop   cx

   dec   cx
   jz    end2
   jmp   start2

   end2:
   pop   ds
  }
 }
 else if (option==NO_CLIP)
 {
  _asm
  {
   push ds

   mov  ax,[image_seg]
   mov  ds,ax

   mov  ax,[scrn_seg]
   mov  es,ax
   mov  di,[scrn_off]

   mov  ax,[x]
   mov  dx,[y]

   mov  cx,16

   start_no_clip:
   push  cx

   mov   cx,16

   mid_no_clip1:
   cmp   ah,0
   jl    midend_no_clip
   cmp   ah,15
   jg    midend_no_clip
   cmp   dh,0
   jl    midend_no_clip
   cmp   dh,15
   jg    midend_no_clip

   mov   si,[image_off]
   mov   bl,dh
   shl   bl,1
   shl   bl,1
   shl   bl,1
   shl   bl,1
   add   bl,ah
   and   bh,0x00
   add   si,bx

   mov   bl,[si]
   dec   bl
   dec   bl
   jz    midend_no_clip
   inc   bl
   inc   bl
   mov   es:[di],bl

   midend_no_clip:
   sub   ax,[right_x]
   add   dx,[right_y]
   inc   di

   loop mid_no_clip1

   add   di,304

   mov   ax,[ox]
   mov   dx,[oy]
   sub   ax,[down_x]
   add   dx,[down_y]
   mov   [ox],ax
   mov   [oy],dx

   pop   cx

   dec   cx
   jz    end_no_clip
   jmp   start_no_clip

   end_no_clip:
   pop  ds
  }
 }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void put_compressed(int x, int y, byte huge *image)
{
 word scrn_seg=FP_SEG(screen),
      scrn_off=FP_OFF(screen)+(y<<8)+(y<<6)+x,
      image_seg=FP_SEG(image),
      image_off=FP_OFF(image);

 _asm
 {
  push  ds

  mov   ax,[image_seg]
  mov   ds,ax
  mov   si,[image_off]

  mov   ax,[scrn_seg]
  mov   es,ax
  mov   di,[scrn_off]

  start:
  mov   cx,[si]
  cmp   cl,0
  je    end

  mov   bl,ch
  and   ch,0x00

  draw:
  mov   es:[di],bl
  inc   di
  dec   bh
  jz    update
  loop  draw
  inc   si
  inc   si
  jmp   start

  update:
  add   di,304
  mov   bh,16
  loop  draw
  inc   si
  inc   si
  jmp   start

  end:
  pop   ds
 }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void box(byte option, int x1, int y1, ...)
{

}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

#define goto(x,y) _settextposition(y,x)

void print(char *string, word x, word y)
{
 _settextposition(y,x);
 printf("%s",string);
}

#ifndef DOSH
 #include <dos.h>
#endif

#ifndef GRAPHH
 #include <graph.h>
#endif

#ifndef STDIOH
 #include <stdio.h>
#endif

#ifndef NORMAL
 #define NORMAL 1
 #define MASK 2
#endif

#ifndef NO
 #define NO 0
 #define YES 1
#endif

#define MOUSE_ON 1
#define MOUSE_OFF 2

#define MOUSE_CURSOR_X_SIZE 16
#define MOUSE_CURSOR_Y_SIZE 16
#define MOUSE_CURSOR_SIZE MOUSE_CURSOR_X_SIZE*MOUSE_CURSOR_Y_SIZE

#define MOUSE_CLICK_DELAY 10 /* in milliseconds */

word mouse_x, mouse_y;
byte mouse_1, mouse_2, mouse_3;
word mouse_status;
byte mouse_flag=OFF;
byte mouse_click=NO;

word old_mouse_offset,
     old_mouse_segment,
     old_mouse_mask;

byte huge *mouse_cursor,
	  *mouse_background;

d_word old_mouse_timer, mouse_timer=0, max_mouse_timer=MOUSE_CLICK_DELAY;


/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void set_mouse(short value)
{
 union REGS inregs, outregs;

 inregs.h.ah=0;
 inregs.h.al=(char)value;
 int86(0x33,&inregs,&outregs);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void restrict_mouse(short x1,short y1,short x2,short y2)
{
 union REGS inregs, outregs;

 inregs.x.ax=7;                   // Set X limits
 inregs.x.cx=x1*2;
 inregs.x.dx=x2*2;
 int86(0x33,&inregs,&outregs);

 inregs.x.ax=8;                   // Set Y limits
 inregs.x.cx=y1;
 inregs.x.dx=y2;
 int86(0x33,&inregs,&outregs);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void position_mouse(short x, short y)
{
 union REGS inregs, outregs;

 inregs.x.ax=4;                   // Move to X, Y
 inregs.x.cx=x*2;
 inregs.x.dx=y;
 int86(0x33,&inregs,&outregs);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void interrupt mouse_handler(void)
{
 union REGS inregs;

 _asm
 {
  push    ds

  mov     al,[palette_flag]
  dec     al
  jz      end

  mov     ax,3
  int     0x33
  shr     cx,1
  mov     [mouse_x],cx
  shl     cx,1
  mov     [mouse_y],dx

  mov     ax,bx
  mov     [mouse_status],bx
  and     ax,0x0001
  mov     [mouse_1],al

  and     ax,0x0002
  mov     [mouse_3],al

  and     ax,0x0004
  mov     [mouse_2],al

  mov     ax,4
  int     0x33

  end:
  pop     ds
 }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

/* i had prob's with this...I don't use it...yet */

void install_mouse_handler(void)
{
 union REGS inregs, outregs;
 struct SREGS segs;

 word func_off, func_seg;

 _asm
 {
  mov     [func_off],OFFSET mouse_handler
  mov     [func_seg],SEG mouse_handler
 }

 inregs.x.ax=0x14;
 inregs.x.cx=127;
 inregs.x.dx=func_off;
 segs.es=func_seg;
 int86x(0x33,&inregs,&outregs,&segs);
 old_mouse_segment=segs.es;
 old_mouse_offset=outregs.x.dx;
 old_mouse_mask=outregs.x.cx;
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

/* ditto here.  i don't use this...i'll try getting it working later...*/

void remove_mouse_handler(void)
{
 union REGS inregs, outregs;
 struct SREGS segs;

 inregs.x.ax=0x14;
 inregs.x.dx=old_mouse_offset;
 segs.es=old_mouse_segment;
 inregs.x.cx=old_mouse_mask;
 int86x(0x33,&inregs,&outregs,&segs);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

/* this just uses an interrupt to get data for the globals mouse_x, etc. */

void read_mouse(void)
{
 union REGS inregs, outregs;

 inregs.h.ah=0;
 inregs.h.al=3;
 inregs.x.bx=0;
 inregs.x.cx=0;
 inregs.x.dx=0;
 int86(0x33,&inregs,&outregs);

 mouse_x=outregs.x.cx/2;
 mouse_y=outregs.x.dx;
 mouse_1=(char)outregs.x.bx&0x01;
 outregs.x.bx>>=1;
 mouse_2=(char)outregs.x.bx&0x01;
 outregs.x.bx>>=1;
 mouse_3=(char)outregs.x.bx&0x01;
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void refresh_mouse(void)
{
 get_image(mouse_x,mouse_y,mouse_background,MOUSE_CURSOR_X_SIZE,
					    MOUSE_CURSOR_Y_SIZE);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void hide_mouse(void)
{
 put_image(mouse_x,mouse_y,mouse_background,MOUSE_CURSOR_X_SIZE,
					     MOUSE_CURSOR_Y_SIZE,
					     NORMAL);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void show_mouse(void)
{
 put_image(mouse_x,mouse_y,mouse_cursor,MOUSE_CURSOR_X_SIZE,
					MOUSE_CURSOR_Y_SIZE,
					MASK);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void update_mouse(void)
{
 refresh_mouse();
 show_mouse();
}
