/* sampfont.c - How to use your newly created font */
/* sorry if I "over-comment" */

/* WinMain is fairly standard - if you want to see the */
/* font stuff in action, jump down to WndProc */

#include <string.h>
#include <windows.h>


/* prototypes */
long FAR PASCAL WndProc( HWND, WORD, WORD, LONG );

#pragma argsused
int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance,
	LPSTR lpszCmdLine, int nCmdShow )
{
	WNDCLASS wndclass;
	HWND hwnd;
	MSG msg;

	if( !hPrevInstance )
	{
		wndclass.style = CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc = (WNDPROC)WndProc;
		wndclass.cbClsExtra = 0;
		wndclass.cbWndExtra = 0;
		wndclass.hInstance = hInstance;
		wndclass.hIcon = LoadIcon( NULL, IDI_APPLICATION );
		wndclass.hCursor = LoadCursor( NULL, IDC_ARROW );
		wndclass.hbrBackground = GetStockObject( WHITE_BRUSH );
		wndclass.lpszMenuName = NULL;
		wndclass.lpszClassName = "SampFontClass";
		RegisterClass( &wndclass );
	}

	hwnd = CreateWindow( "SampFontClass", "Sample Font Demo",
		WS_OVERLAPPED | WS_CLIPCHILDREN | WS_CAPTION | WS_SYSMENU,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
		NULL, NULL, hInstance, NULL );

	ShowWindow( hwnd, nCmdShow );
	UpdateWindow( hwnd );

	while( GetMessage(&msg, NULL, 0, 0) )
	{
		TranslateMessage( &msg );
      DispatchMessage( &msg );
	}

   return msg.wParam;
}


/*  Main window procedure  */
long FAR PASCAL WndProc( HWND hwnd, WORD msg, WORD wParam, LONG lParam )
{
	static char pszSampText[] = "a;li cbck j318 37";
	/* That is the sample text to print out.  In the SAMPFONT.FON, there  */
	/* is no real correlation between letters the the font char images    */
   /* Use the Resource Workshop to load SAMPFONT.FNT and see what I mean */

	static HFONT hfFont, hfOldFont;
	HDC hdcPaint;

	LOGFONT lfData;
	PAINTSTRUCT ps;
   RECT rcWindow;

	switch( msg )
	{
		case WM_CREATE:
      	/* To load the font you've created, call "AddFontResource" */
			if( AddFontResource( "sampfont.fon" ) )
			{
				/* Send a message to other applications to notify them */
            /* that a new font has been installed. */
				SendMessage( HWND_BROADCAST, WM_FONTCHANGE, 0, 0 );

				/* to create a font, we'll need to give windows */
            /* info on which font we want (through LOGFONT structure */
				memset( &lfData, 0, sizeof( LOGFONT ) );	// Most defaults are 0
				lfData.lfCharSet = DEFAULT_CHARSET;

				/* Set the "lfFaceName" field of the LOGFONT structure */
				/* to the name of the font.  This name is set in the   */
				/* "Face name" field of the Font Header dialog box in  */
				/* the Resource Workshop font editor. */
				strcpy( (char *)lfData.lfFaceName, "Katakana" );

				/* Now let's get a handle to the font so */
				/* we can actually print stuff with it.  */
				hfFont = CreateFontIndirect( &lfData );
			}
			else hfFont = NULL;
			return 0;

		case WM_PAINT:
			hdcPaint = BeginPaint( hwnd, &ps );

         /* select the font */
			hfOldFont = SelectObject( hdcPaint, hfFont );

			/* Draw the text (TextOut can be used also) */
			GetClientRect( hwnd, &rcWindow );
			DrawText( hdcPaint, pszSampText, -1, &rcWindow,
				DT_CENTER | DT_WORDBREAK );

         /* restore the old font */
         DeleteObject( SelectObject( hdcPaint, hfOldFont ) );
         EndPaint( hwnd, &ps );
			break;

		case WM_DESTROY:
			// Unregister the fonts
			RemoveFontResource( "SAMPFONT.FON" );
			SendMessage( HWND_BROADCAST, WM_FONTCHANGE, 0, 0 );
			PostQuitMessage(0);
      	break;
	}

	return DefWindowProc( hwnd, msg, wParam, lParam );
}