program ScaleSprite;
uses graph,crt,library,bgidriv;
const spritesize = 30;
TYPE SpriteInfo = RECORD
       name : STRING[40];
       loc : ARRAY[0..SpriteSize-1,0..SpriteSize-1] OF SHORTINT;
     END;

var sprite : spriteinfo;
    n,gd,gm,er : integer;
    spritefile : file of spriteinfo;

procedure LoadSprite(fn,spr : string; x,y : word);
VAR count,h,k,x1,y1,x2,y2 : WORD;
BEGIN
  spr := uppercase(spr);
  if pos('.',fn) = 0 then fn := fn + '.SCF';
  ASSIGN(SpriteFile,fn);
  {$I-} RESET(SpriteFile); {$I+}
  IF IORESULT <> 0 THEN
    fatalerror('Sprite file not found - '+UpperCase(fn));
  count := 0;
  RESET(SpriteFile);
  WHILE NOT EOF(SpriteFile) DO
  BEGIN
    READ(SpriteFile,Sprite);
    INC(count);
  END;
  IF count > 1 THEN
  BEGIN
    RESET(SpriteFile);
    WHILE (spr<>Sprite.name) AND (NOT EOF(SpriteFile)) DO
      READ(SpriteFile,Sprite);
    IF spr <> Sprite.name THEN
      fatalerror('Sprite not found - '+UpperCase(fn)+' | '+UpperCase(spr));
    {$I-} CLOSE(SpriteFile); {$I+}
  END ELSE
  BEGIN
    RESET(SpriteFile);
    READ(SpriteFile,Sprite);
    CLOSE(SpriteFile);
  END;
  FOR h := 0 TO 29 DO
    FOR k := 0 TO 29 DO
    BEGIN
      IF sprite.loc[h,k] = -1 THEN sprite.loc[h,k] := 0;
      PUTPIXEL(x+h,y+k,sprite.loc[h,k]);
    END;
END;  { LoadSprite }

procedure scale_sprite(spr : spriteinfo; fillstyle : word; x,y : word;
            scale : shortint);
var h,k,l,m : shortint;
begin
  for h := 0 to 29 do
    for k := 0 to 29 do
    begin
      setfillstyle(fillstyle,sprite.loc[h,k]);
      bar(x+h*scale,y+k*scale,x+h*scale+scale,y+k*scale+scale);
    end;
end;

procedure erase_scale(spr : spriteinfo; x,y : word; scale : shortint);
var h,k,l,m : shortint;
begin
  for h := 0 to 29 do
    for k := 0 to 29 do
    if sprite.loc[h,k] <> 0 then
    begin
      setfillstyle(solidfill,0);
      bar(x+h*scale,y+k*scale,x+h*scale+scale,y+k*scale+scale);
    end;
end;

var x : shortint;
begin
  if registerbgidriver(@egavgadriverproc) < 0 then
    fatal('Graphics driver not found');
  detectgraph(gd,gm);
  if gd <> vga then fatal('VGA required');
  gd := vga; gm := vgahi;
  initgraph(gd,gm,'');
  if graphresult <> 0 then fatal('Graphics driver failure!');
  loadsprite('test','',10,10);
  for n := 1 to 10 do
    scale_sprite(sprite,solidfill,100,0,n+1);
  readkey;
  closegraph;
  textmode(co80);
end.
