/*************************************************************************

  SVGADIAG.C

  Written by Eric Jorgensen (1994)

  This is Turbo C source code for my SVGA DIAGNOSTIC UTILITY.  Feel
  free to modify it, use it, play with it, or even give it away.
  Just don't sell it for money or give yourself credit for what
  you didn't write.

  To avoid confusion, please do not publish modifcations of this
  code as a version of "SVGADIAG" or "SVGA DIAGNOSTIC UTILITY".

  NOTES:  SVGACC is a SVGA graphics library written by Stephen Balkum
          and Daniel Sill.  You can upload a shareware version just
          about anyplace, but try looking in Simtel for svgacc21.zip
          in one of the programming directories.

          Compile with a large memory model.

*************************************************************************/

#include <stdio.h>
#include <conio.h>
#include "svgacc.h"
#include <alloc.h>
#include <dos.h>

char *version = {"1.0"};
                                 // Video card ID's for whichvga()
char *card[21] = { "Acumos AVGA2/3",
                    "ATI",
                    "Ahead V5000 Ver A",
                    "Ahead V5000 Ver B",
                    "Chips and Technologies 82C45x",
                    "Cirrus Logic CL-GD",
                    "Everex Micro Enhancer",
                    "Genoa",
                    "NCR",
                    "Oak Technologies OTI",
                    "Paradise/Western Digital",
                    "Realtek RT3106",
                    "Trident 8800CS, 8900B/C/CL/CX, 90x0",
                    "Tseng Labs ET3000",
                    "Tseng Labs ET4000",
                    "VESA compatible",
                    "Video 7 HT",
                    "Avance Logic AL2101",
                    "MXIC MX",
                    "Primus P2000"
                    "Undefined"
                  };
                                 // mouseID's for Mouseinfo()
char *mice[6] = { "Unknown",
                  "Bus",
                  "Serial",
                  "Inport",
                  "PS/2",
                  "HP" };


/**************************************************************************
  main()

    DESCTRIPTION: No other functions here.  This one simply calls a few
                  routtines to measure the performance and compatability
                  of the graphics card.

**************************************************************************/
main()
{
  int blkget_return,mouse_drvmaj,mouse_drvmin,mousetype,mouseirq;
  int pageactive_return,pagedisplay_return;
  int res640_return, res800_return,res1024_return,res1280_return;
  int cputype,video_memory,whichmouse_return;
  int videocard;
  int i,j,k,t;
  RGB palette[256];
  FILE *output;
  RasterBlock *blk;
  char string[255];
  struct date today;
  struct time now;
  union REGS myregs;
  struct SREGS mysregs;
  char vesainfobuffer[512];
  char r;
  byte vermaj,vermin,*pt;
  char far *OEMname,*modes;
  long int pps,c;
                                 // Warn the user about Winndoze
  clrscr();
  printf("\n\n\n\n\n\t\t*WARNING* This program is NOT Windows friendly.\n");
  printf("\n\t\tYou should quit Windows before running SVGADIAG.\n\n");
  printf("\t\tPress 'C' to continue anyway, or any other key to quit.");

  if(toupper(getch()) != 'C') exit(1);

  clrscr();                            // clear screen
  printf("########################################\n");
  printf("#                                      #\n");
  printf("#       SVGA DIAGNOSTIC UTILITY        #\n");
  printf("#            Version %s               #\n",version);
  printf("#                                      #\n");
  printf("#   Written by Eric Jorgensen (1994)   #\n");
  printf("#                                      #\n");
  printf("########################################\n\n\n");


  blk = (RasterBlock *)malloc(11000); // allocate memory for graphics block
  if(!blk) {
    printf("Whoops!  Could not allocate 20Kb for graphics block.\n");
    exit(1);
  }

  output = fopen("SVGAOUT.txt","w");  // open output file
  if(!output) {
    printf("Whoops!  Could not open an output file.\n");
    exit(1);
  }
                                      // Starting Instructions
  printf("INSTRUCTIONS:\n");
  printf("  The data from this program will be dumped to a file called SVGAOUT.TXT.\n");
  printf("  Please edit this file (even if this program crashes), answer the\n");
  printf("  questions at the beginning about your computer system, and send it\n");
  printf("  via email to:\n\n");
  printf("\t\tsmeagol@rt66.com\n\n");
  printf("Note: This Survey ends as of Jan 1, 1995.  Please do not\n");
  printf("email resposes after that date.\n\n\n");
  printf("Press any key to begin testing...\n");
  getch();

                                    /*********************
                                    *                    *
                                    * Write questionaire *
                                    * to output file     *
                                    *                    *
                                    *********************/

  fprintf(output,"[BEGIN DATA]\n");
  fprintf(output,"SVGA Diagnostic Utility - Output file\n");
  fprintf(output,"VERSION %s\n",version);
  getdate(&today);
  gettime(&now);
  sprintf(string,"Created on %d/%d/%d at %d:%d\n",
                today.da_mon,today.da_day,today.da_year,
                now.ti_hour,now.ti_min);
  fprintf(output,string);
  fprintf(output,"Please email this file to smeagol@rt66.com before Jan 1, 1995\n");

  fprintf(output,"--------------------------------------------------------------\n\n");
  fprintf(output,"Please include the following information about your system:\n\n");

  fprintf(output,"[COMPUTER]\n\n");

  fprintf(output,"                     CPU:\n");
  fprintf(output,"    Clock Speed (in Mhz):\n");
  fprintf(output,"           Cache (in Kb):\n");
  fprintf(output,"      Ram Memory (In Mb):\n");
  fprintf(output,"            Manufacturer:\n");
  fprintf(output,"              Bios Maker:\n");
  fprintf(output,"               Bios Date:\n\n");

  fprintf(output,"[VIDEO CARD]\n\n");

  fprintf(output,"            Manufacturer:\n");
  fprintf(output,"                   Model:\n");
  fprintf(output,"         Video BIOS date:\n");
  fprintf(output,"    Video Memory (In MB):\n");
  fprintf(output,"                Bus type:\n\n\n");

  fprintf(output,"(Note: You can get a lot of this information from a program\n");
  fprintf(output,"called MSD.EXE that comes with later versions of MSDOS and WINDOWS.)\n\n\n");

  fprintf(output,"Finally, please add brief, descriptive comments of any \n");
  fprintf(output,"problems you observed:\n\n\n\n\n\n\n");

  fprintf(output,"**********************************************************************\n");
  fprintf(output,"*                                                                    *\n");
  fprintf(output,"*    The section below contains results compiled by the utility.     *\n");
  fprintf(output,"*             Please do not alter this data.                         *\n");
  fprintf(output,"*                                                                    *\n");
  fprintf(output,"**********************************************************************\n\n");


                                    /*********************
                                    *                    *
                                    * Get General VESA   *
                                    * information        *
                                    *                    *
                                    *********************/


  clrscr();
  printf("GENERAL VESA INFORMATION\n\n");
  fprintf(output,"[GENERAL VESA INFORMATION]\n\n");


  myregs.x.ax = 0x4f00;                   // set interrupt inputs
  mysregs.es = _ES;
  myregs.x.di = FP_OFF(vesainfobuffer);

  int86x(0x10,&myregs,&myregs,&mysregs);  // call the VESA information interrupt

  if(myregs.h.ah > 0 || myregs.h.al != 0x4f ) {  // if VESA call failed

    if(myregs.h.al != 0x4f) {             // Supported?
      fprintf(output,"  BIOS VESA information call not supported.\n\n");
      printf("*ERROR*\n\nBIOS VESA information call not supported.\n\n");
    }
    else {                                // Simple failure?
      fprintf(output,"  BIOS VESA information call failed.\n\n");
      printf("*ERROR*\n\nBIOS VESA information call failed.\n\n");
    }
    printf("If you continue, this program will behave unpredictably.\n");
    printf("Most likely, it will crash and you will have to reboot\n");
    printf("your system.\n\n\n");
    printf("Do you wish to continue with the diagnostics? (Y/N)\n");

    while(kbhit()) getch();                // clear keyboardbuffer
    r = toupper(getch());                 // get keystroke
    if(r != 'Y') exit(2);
  }

                                          /* SIGNATURE */
  for(i = 0; i < 4; i++) {
    string[i] = vesainfobuffer[i];        // copy signature bytes to a string
  }
  string[4] = 0;
  printf("  Signature: %s\n",string);
  fprintf(output,"  Signature: %s\n",string);
                                            /* VESA Version # */
  vermin = vesainfobuffer[0x04];
  vermaj = vesainfobuffer[0x05];
  printf("  VESA Version: %d.%d\n",vermaj,vermin);
  fprintf(output,"  VESA Version: %d.%d\n",vermaj,vermin);

                                            /* Manufacturer */
  pt = (byte *)&OEMname;
  *(pt+0) = vesainfobuffer[0x06];           // set string pointer
  *(pt+1) = vesainfobuffer[0x07];
  *(pt+2) = vesainfobuffer[0x08];
  *(pt+3) = vesainfobuffer[0x09];
  for(i = 0 ; i < 200 && *(OEMname+i) != 0; i++); // Make string is real
  if(i < 200) {
    printf("  Manufacturer: %s\n",OEMname);
    fprintf(output,"  Manufacturer: %s\n",OEMname);
  }
  else {
    printf("  Manufacturer: [ERROR]");
    fprintf(output,"  Manufacturer: [ERROR]");
  }

                                            /* Memory (reports memory in
                                               64 Kb chunnks */
  video_memory = (vesainfobuffer[0x12]+ vesainfobuffer[0x13]) * 64 ;
  printf("  Memory: %d Kb\n",video_memory);
  fprintf(output,"  Memory: %d Kb\n",video_memory);


  printf("\n\nPress any key to continue.\n");

                                    /*********************
                                    *                    *
                                    * SVGACC ID Fuctions *
                                    *                    *
                                    *********************/

  fprintf(output,"\n[SVGACC ID FUNCTIONS]\n\n");

  cputype = whichcpu();             // cpu type
  fprintf(output,"  CPU: %d\n",cputype);
  if(cputype < 386) {
    printf("The CPU detected (%d) is too whimpy to run\n",cputype);
    printf("the rest of this program.  Exiting....\n\n");
    exit(1);
  }


  videocard = whichvga();           // Initialize graphics
  if(videocard < 1 || videocard > 20) videocard = 21;
  fprintf(output,"  Card: %s\n",card[videocard-1]);

  video_memory = whichmem();        // video memory
  fprintf(output,"  Memory: %d\n",video_memory);


  whichmouse_return = whichmouse(); // # of mouse buttons  0 = no mouse
  fprintf(output,"  Whichmouse: %d\n",whichmouse_return);

                                    // other mouse info
  mouseinfo(&mouse_drvmaj,&mouse_drvmin,&mousetype,&mouseirq);
  fprintf(output,"    Driver Version: %.2lf\n",
                 (double)mouse_drvmaj+mouse_drvmin/100.0);
  fprintf(output,"    Type: %s\n",mice[mousetype]);
  fprintf(output,"    IRQ: %d\n",mouseirq);

  if(videocard == 21) {             // whoops! no recognizeable video card
    clrscr();
    printf("*ERROR* The graphics library could not ID your card.\n");
    printf("If you continue, this program will behave unpredictably.\n");
    printf("Most likely, it will crash and you will have to reboot\n");
    printf("your system.\n\n\n");
    printf("Do you wish to continue with the diagnostics? (Y/N)\n");

    while(kbhit()) getch();              // clear keyboardbuffer
    r = toupper(getch());
    if(r != 'Y') exit(2);
  }
                                    // CHECK VIDEO MODES

  res1280_return = -1;              // -1 means not tested
  res1024_return = -1;
  if(video_memory > 2000) {         // if enough memory...
    res1280_return = res1280();
    fprintf(output,"  Res1280: %d\n",res1280_return);
  }
  if(video_memory > 1000) {
    res1024_return = res1024();
    fprintf(output,"  Res1024: %d\n",res1024_return);
  }
  res800_return = res800();
  fprintf(output,"  Res800: %d\n",res800_return);

  res640_return = res640();
  fprintf(output,"  Res640: %d\n",res640_return);

  pagedisplay_return = pagedisplay(0,0,0);    // pageflippping flag
  fprintf(output,"  Pagedisplay: %d\n",pagedisplay_return);

  pageactive_return = pageactive(0); // page writing flag
  fprintf(output,"  Pageactive: %d\n",pageactive_return);

  blkget_return = blkget(10,10,11,11,blk);  // looking at this just for kicks
  fprintf(output,"  Blkget: %d\n",blkget_return);

                                    /***********************
                                    *                      *
                                    * SVGACC Compatability *
                                    *                      *
                                    ***********************/

  fprintf(output,"\n[REALITY CHECK]\n\n");
  while(kbhit()) getch();
                                    // Paging check
  if(pagedisplay_return) {
    fillpage(0);                    // page flipping
    pageactive(0);
    drwstring(SET,15,0,"THIS TEXT SHOULD BE BLINKING",200,100);
    drwstring(SET,14,0,"Is the text above blinking? (Y/N)",200,150);
    pageactive(1);
    drwstring(SET,14,0,"Is the text above blinking? (Y/N)",200,150);
    pageactive(0);

    r = ' ';
    while(r != 'Y' && r != 'N') {
      if(kbhit()) r = toupper(getch());
      pagedisplay(0,0,1);
      delay(40);
      pagedisplay(0,0,0);
      delay(40);
    }
    fprintf(output,"  page flipping: %c\n",r);
                                    // page data writing
    pageactive(1);                  // Draw a circle on page 1
    drwfillcircle(SET,12,20,20,19);

    pageactive(0);                  // clear page 0;
    fillpage(0);

    pageactive(1);                  // get the circle on page 1
    blkget(0,0,40,40,blk);
    fillpage(0);

    pageactive(0);                  // draw a bunch of what we got back there
    for (i = 0; i < 10 ; i++) {
      blkput(SET,i*60,30,blk);
    }
                                    // Did the user see it?
    drwstring(SET,14,0,"Do you see a row of circles above? (Y/N)",200,150);

    while(kbhit()) getch();
    r = ' ';
    while(r != 'Y' && r != 'N') {
      if(kbhit()) r = toupper(getch());
    }
    fprintf(output,"  page writing: %c\n",r);

  }
  if(whichmouse_return) {           // Make sure the mouse is behaving itself
    fillpage(5);
    for(i = 0 ; i < 47; i++) {
      drwfillbox(SET,4,0,i*10,640,i*10+5);
    }

    mousecursordefault();           // start up the mouse
    mouseenter();
    mouseshow();


    drwstring(SET,15,0,"Try moving your mouse around the screen",200,150);
    drwstring(SET,15,0,"Does it mess up the screen? (Y/N)",200,170);

    while(kbhit()) getch();
    r = ' ';
    while(r != 'Y' && r != 'N') {
      if(kbhit()) r = toupper(getch());
    }
    fprintf(output,"  Mouse mess: %c\n",r);
    mousehide();
  }

                                    /***********************
                                    *                      *
                                    * SVGACC Performance   *
                                    *                      *
                                    ***********************/

  fprintf(output,"\n[PERFORMANCE CHECK]\n\n");
  while(kbhit()) getch();

  fillpage(0);                        // clear screeen
  drwstring(SET,15,0,"SVGA PERFORMANCE CHECK",10,50);
  delay(1000);                        // wait a second to enhance drama
                                      // draw a pretty circle
  drwfillbox(SET,0,250,0,450,300);
  for(i = 16; i > 0; i--) drwfillcircle(SET,32-i,300-(16-i),100-(16-i),i*3.1);

  drwstring(SET,14,0,"TESTING BLOCK GET FUNCTION",10,80);
  c = 0;                              // reset counter
  t = clock();                        // look at clock
  while(t == clock());                // start off on a tick
  t += 51;                             // set alarm for 50 ticks (2.75 secs)
  while(t != clock()) {               // loop until alarm
    blkget(250,c%370,350,c%370+100,blk);       // drawing item to be tested
    c++;                              //  increment counter
  }
  pps = c * 10000/2.75;               // calculate pixels/sec
  fprintf(output,"  blkget: %.1lf Kpxls/sec\n",pps/1000.0);

  blkget(250,50,350,150,blk);         // get the picture
  drwstring(SET,14,0,"TESTING BLOCK PUT FUNCTION",10,96);
  c = 0;
  t = clock();
  while(t == clock());                // start off on a tick
  t += 51;
  while(t != clock()) {
    blkput(SET,400,(c%370),blk);
    c++;
  }
  pps = c * 10000/2.75;
  fprintf(output,"  blkput: %.1lf Kpxls/sec\n",pps/1000.0);

  drwstring(SET,14,0,"TESTING DRAW BOX FUNCTION",10,112);
  c = 0;
  t = clock();
  while(t == clock());                // start off on a tick
  t +=51;
  while(t != clock()) {
    k = c &0xff;
    for(i = 0; i < 10; i++) {
      drwbox(SET,k,250 +k,100+k,350+k,200+k);
    }
    c++;
  }
  pps = c * 3980/2.75;
  fprintf(output,"  drwbox: %.1lf Kpxls/sec\n",pps/1000.0);

  drwstring(SET,14,0,"TESTING DRAW FILLBOX FUNCTION",10,128);
  c = 0;
  t = clock();
  while(t == clock());                // start off on a tick
  t += 51;
  while(t != clock()) {
    k = c &0xff;
    drwfillbox(SET,k,250 +k,100+k,350+k,200+k);
    c++;
  }
  pps = c * 10000/2.75;
  fprintf(output,"  drwfillbox: %.1lf Kpxls/sec\n",pps/1000.0);

  drwstring(SET,14,0,"TESTING DRAW LINE FUNCTION",10,144);
  c = 0;
  t = clock();
  while(t == clock());                // start off on a tick
  t += 51;
  while(t != clock()) {
    for(i = 0; i < 50; i++) {
      drwline(SET,c%256,410,110,510,111);
    }
    c++;
  }
  pps = c * 5000/2.75;
  fprintf(output,"  drwline: %.1lf Kpxls/sec\n",pps/1000.0);

  drwstring(SET,14,0,"TESTING DRAW POINT FUNCTION",10,160);
  c = 0;
  t = clock();
  while(t == clock());                // start off on a tick
  t += 51;
  while(t != clock()) {
    for(i = 200; i < 450; i++){
      drwpoint(SET,c & 0xff,i,i);
    }
    c++;
  }
  pps = c *250 /2.75;
  fprintf(output,"  drwpoint: %.1lf Kpxls/sec\n",pps/1000.0);

  drwstring(SET,14,0,"TESTING GET POINT FUNCTION",10,176);
  c = 0;
  t = clock();
  while(t == clock());                // start off on a tick
  t += 51;
  while(t != clock()) {
    for(i = 200; i < 450; i++){
      getpoint(i,i);
    }
    c++;
  }
  pps = c *250 /2.75;
  fprintf(output,"  getpoint: %.1lf Kpxls/sec\n",pps/1000.0);



                                      // All done!  Clean up and go home.
  fprintf(output,"[END DATA]\n");



  restext();

  clrscr();
  printf("Thanks for using this SVGA diagnostic Utility.\n");
  printf("Please remember to edit the results file (SVGAOUT.TXT)\n");
  printf("and fill in information about your system before emailing\n");
  printf("it to smeagol@rt66.com\n");
  fclose(output);
}

