{$X+}
{$R-}
USES crt;

CONST VGA = $a000;  (* This sets the constant VGA to the segment of the
                       VGA screen.                                      *)
      XSize = 16;
      YSize = 16;

TYPE
        Letter = Array[1..xsize,1..ysize] of Byte;
        Letters = Array[' '..']'] of Letter;

VAR Font : ^Letters;

{}
Procedure SetMCGA;  { This procedure gets you into 320x200x256 mode. }
BEGIN
  asm
     mov        ax,0013h
     int        10h
  end;
END;


{}
Procedure SetText;  { This procedure returns you to text mode.  }
BEGIN
  asm
     mov        ax,0003h
     int        10h
  end;
END;

{}
Procedure Pal(ColorNo : Byte; R,G,B : Byte);
  { This sets the Red, Green and Blue values of a certain color }
Begin
   Port[$3c8] := ColorNo;
   Port[$3c9] := R;
   Port[$3c9] := G;
   Port[$3c9] := B;
End;


{}
Procedure PutPixel (X,Y : Integer; Col : Byte; Where : Word);
   { This puts a pixel at X,Y using color col, on VGA or the Virtual Screen}
BEGIN
  Mem [Where:X+(Y*320)]:=col;
END;

{}
procedure LoadPal (FileName : string);
   { This loads the Pallette file and puts it on screen }
type DACType = array [0..255] of record
                                R, G, B : byte;
                              end;
var DAC : DACType;
    Fil : file of DACType;
    I : integer;
BEGIN
  assign (Fil, FileName);
  reset (Fil);
  read (Fil, DAC);
  close (Fil);
  for I := 0 to 255 do Pal(I,Dac[I].R,Dac[I].G,Dac[I].B);
end;


{}
Procedure Init;
  { This loads the font and the pallette }
VAR f:file;
    loop1:integer;

BEGIN
  getmem (font,sizeof (font^));
  Assign (f,'softrock.fnt');
  reset (f,1);
  blockread (f,font^,sizeof (font^));
  close (f);
  SetMCGA;
  loadpal ('pallette.col');
END;

{}
Procedure DrawText (X,Y:Integer;Msg:String);
  { This draws MSG at the coords X,Y }
VAR loop1,loop2,loop3:integer;
BEGIN
  For loop1:=1 to length (msg) do
    For loop2:=1 to xsize do
      For loop3:=1 to ysize do
        PutPixel ((loop1*(xsize+1))+loop2+x,loop3+y,font^[msg[loop1],loop2,loop3],vga);
END;

BEGIN
  Init;
  DrawText (10,10,'ASPHYXIA RULZ!!!');
  DrawText (50,50,'BOB LIVES!');
  DrawText (10,90,'REGISTER TEXTER!');
  Readkey;
  Settext;
  freemem (font,sizeof (font^));
END.
