//************************************************************************
//************************************************************************
// The following data structures are designed for easier use by users of
// the program that want to create their own conversion utility.  Code is
// included in the Vecedit package which will convert Vecedit objects to
// this format (in C/ C++).  This code should really help (it is much
// easier to process a binary file than it is to parse a text file).  The
// format is based on a format given me by Dick Verweil (sp?).

// The basic data necessary to represent an object are:
//	POINTS = Set of vertices of object, stored as longs (X,Y,Z).
//	NORMALS= Set of precalculated vector normals for the object.
//	GROUP POINTS= Set of points to be used for depth sorting.
//	FACES = Set of faces (polygons)--see structure below.
//	FACE POINT LISTS = Lists of vertices which belong to specific
//			   faces.

// In addition, for texture/ gourad shading, the following are needed:
//	VERTEX NORMALS  = Vertex normals for gourad shading
//	GOURAD VERTICES = Set of information correlating vertices of faces
//		to vertex normals.
//	TEXTURE VERTICES = Set of information correlating vertices of a
//		face to coordinates in the bitmap.

// A quick note about offsets:  offsets are divided by the size of the
// respective data structure.  Thus the offset given is the actual number
// of the piece of data.  For example, the offset of the fourth vertex
// (12 byte data structure) would be "3", NOT "36" or "9".

// Texture map vertex information (for interpolation)

typedef struct
	{
	int x;			// x location in bitmap of vertex
	int y;			// y location in bitmap of vertex
	} outtex;

// Gourad shading vertex information (for interpolation)

typedef struct
	{
	unsigned vertnormal;		// offset of vertex normal
	} outgou;

// Face (polygon) information

typedef struct
	{
	char	 color;			// The color (0..255)
	char	 shadeflag;		// 1=texture map,   2=gourad shade
					// 0=no special shading

	unsigned numpoints;		// number of vertices
	unsigned *pointarray;		// pointer to vertex list (set of
					// offsets in the vertex list)
	unsigned normalvec;		// offset of normal vector of poly
	unsigned grouppt;		// offset of group point of poly

	outgou	 *gouvee;		// list of gourad vertices
	outtex	 *texvee;		// list of texture map coordinates
	char	 *bmp;   		// pointer to bitmap
	} face;







//************************************************************************
//************************************************************************
// The structures below are internal to my program.  Caution:  these are
// difficult to understand (especially considering you don't know how my
// code works!).
//************************************************************************
//************************************************************************

typedef struct
	{
	long	x;
	long	y;
	} bigvert;

typedef struct
	{
	unsigned v[2];			// normalized vertex indexes
	unsigned poly[2];		// polys connected to edge
	unsigned texpoint[2];		// pointers to texture edges
	} rawedgeverts;

typedef struct
	{
	unsigned char colorvalue;
	unsigned char backfill;
	long D;
	unsigned normvecoff;		// offset in normal vector array
	unsigned point;			// offset in translated array
	unsigned texflag;		// flag saying if polygon is texture
	void far *texpoly;		// pointer to texpoly
	} polystruc;


// Following is a set of structures which will be used for drawing texture
// mapped polygons.

typedef struct
	{
	long	 x;			// current coordinates of edge
	long	 y;			// in bitmap
	long	 dx;			// increments for each coordinate
	long	 dy;			// while advancing down edge
	long	 g;			// gourad shading value
	long     dg;			// gourad shading increment
	void far *texpo;		// pointer to texpoly
	int	 edgeflag;		// flag saying type of texture edge
					// first bit (1) indicates texture
					// second bit (2) indicates gourad
	unsigned statloc;		// location of texstats
	} texedge;

	// The following data structure is used to hold information for the
	// various boundaries of a texture edge (corners and max values)
	// This data structure will be used by the preproc function

typedef struct
	{
	int      xcorn1;		// x and y coordinates of vertex
	int	 ycorn1;		// corresponding to v1
	int	 xcorn2;		// x and y coordinates of vertex
	int	 ycorn2;		// corresponding to v2
	int	 xmax;			// maximum possible x and y values
	int	 ymax;			// in texture map (for rounding)
	unsigned goustruc[2];		// gourad vertex offsets
	} texstats;


typedef struct
	{
	unsigned texture;		// pointer to texture map
	unsigned leftpix;		// pixel location of left edge
	unsigned leftedge;		// offset of left texture edge
	unsigned rightpix;		// pixel location of right edge
	unsigned rightedge;		// offset of right texture edge
	long	 xincr;			// x and y increments to get from
	long	 yincr;			// point "A" to point "B"
	unsigned backfill;		// same as flag for regular poly
	unsigned edgesgot;		// number of edges added to texpoly
	long	 gincr;			// gourad shading increment
	} texpoly;

	// the following data structure will hold a vertex normal offset,
	// raw vertex offset, and a corresponding gourad color value

typedef struct
	{
	int      gvalue;		// calculated gourad shade
	unsigned vertoff;		// 3D rotated vertex offset
	unsigned vertnormoff;		// vertex normal offset
	} gouvert;


typedef struct
	{
	unsigned ps;			// number of polygons in object
	unsigned es;			// number of edges in object
	unsigned vs;			// number of vertices in object
	} numstuff;

typedef struct
	{
	unsigned vn;			// number of vertex normals
	unsigned tp;			// number of texture polygons
	unsigned te;			// number of texture edges
	} numgoustuff;

