//*************************************************************************
//*************************************************************************
/*

Information for the potential creator of a vector conversion utility for
Vecedit objects!!!!  This file is the main module of the program.  It is
recommended that you do not modify any of the original variables of the
program.  I myself don't even remember what everything does (I have long
since switched from C++/ASM to pure ASM for my demo coding, so I've
forgotten some stuff about the original engine).

The code included will load objects into my original C++ object storage
format and then convert them into a simpler format (see convdefs.h).  The
following variables are important:

long	     *rawpt		// array of raw vertices of object
long	     *grppt		// group points of object
long	     *norms     	// normal vectors for polygons
long	     *vertnorms		// vertex normals (used for gourad shading)
face	     *thefaces		// faces/ polygons of object
outgou	     *thegous		// gourad vertex information
outtex	     *thetexs		// texture vertex information


NOTE:  The unsigned array below do not really need to be accessed
       directly--their information is pointed to by "thefaces"

unsigned     *faceverts		// a list which contains the ordered sets of
				// vertex offsets used by the polygons, i.e.
				//  {0, 2, 4, 6} stored in the array would
				// represent a poly consisting of vertex 0,
				// 2, 4, and 6 in that order.

unsigned     abc[0].vs		// number of vertices in object
unsigned     abc[0].ps		// number of polygons/ faces in object
unsigned     numnorm		// number of polygon normals
unsigned     numgrp		// number of group points
unsigned     xyz[0].vn		// number of vertex normals/ gourad vertices


I recommend looking at the text output in the conversion routine to get an
idea of how to extract important information from the data structures above.
The above format really is very simple.  See additional information in the
other two files.

//*************************************************************************
//*************************************************************************/



#include <dos.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <dir.h>
#include "convdefs.h"

extern unsigned _stklen = 35000;
void load3D(numstuff *abc, unsigned *numgrps, unsigned *numnorms, unsigned nullpoly, long *rawpt, long *grppt, unsigned *grplist, polystruc *locpoly, long *rawnorms, rawedgeverts *edgees, texedge *texed, texstats *texts, texpoly *goutexpolys, unsigned char *bitmaparr[], unsigned *bitmapsizearray, gouvert *somegous, long *vertnorm, unsigned *numbmap, numgoustuff *xyz, unsigned *texpolused, unsigned *texpoltotal, texpoly *texpoarr[]);
void conv3D(numstuff *abc, long *rawpt, unsigned *grplist, polystruc *locpoly, long *rawnorms, rawedgeverts *edgees, texedge *texed, texstats *texts, gouvert *somegous, numgoustuff *xyz, face *thefaces, outgou *thegous, outtex *thetexs, unsigned *faceverts);
void dumpved04(numstuff abc, long *rawpt, face *thefaces);


void allocerr(unsigned parm)
{
   cprintf("Not enough memory to allocate buffer %d/10\n\r",parm);
   getch();
   exit(1);  /* terminate program if out of memory */
}


// here are some main object holding arrays

unsigned char  *bitmaparrays[200];	// groups of bitmaps
texpoly *texpolyarrays[200];    // groups of texture polys
unsigned bitmapsizes[400];	// sizes of bitmaps
unsigned texgroupsizes[200];	// number of texture polys per group
unsigned texgroupused[200];	// number of texture polys used per group
unsigned grplist[800];		// group list (800 total polys)

gouvert somegous[800];

char	     mainpal[768];	// main object palette

void main()
{
unsigned count;

//Following are the variables with the numbers of each type of object data

numstuff     abc[1]={0,0,0};	// number of polys, edges, vertices
numgoustuff  xyz[1]={0,0,0};	// num of texpolys, texedges, gouverts
unsigned     numgrp=0;		// number of group points
unsigned     numnorm=0;		// number of polygon normals
unsigned     numbitmap=0;	// number of bitmaps

//Following are the main object holding arrays used in the program

rawedgeverts edgees[1600];	// edge array

long	     *rawpt;		// raw points (2400 total longs)
long	     *grppt;		// group points (1200 total longs)

texedge	     *texed;		// texture edges (200 total in editor)
texstats     *texts;		// texture stats (200 total in editor)
texpoly	     *texpos;		// gourad texture polys (50 total in editor)
long	     *vertnorms;	// vertex normals (50 total in editor)
polystruc    *polys;		// polygons (800 total allocated)

face	     *thefaces;		// faces/ polygons of object
outgou	     *thegous;		// gourad vertex information
outtex	     *thetexs;		// texture vertex information

unsigned     *faceverts;	// vertices belonging to a face

unsigned     nullpolyval;	// location (offset) of null polygon

long	     norms[2400];	// raw normal array (800 polygons)



FILE *output;
unsigned lastloc;



// Memory allocation for large data structures

if ((rawpt = (long *) malloc(14400)) == NULL)   allocerr(1);
grppt=&rawpt[2400];
if ((polys = (polystruc *) malloc(800*16)) == NULL)   allocerr(2);
if ((thefaces = (face *) malloc(800*24)) == NULL)   allocerr(3);
if ((thegous = (outgou *) malloc(2000*4)) == NULL)   allocerr(4);
if ((thetexs = (outtex *) malloc(2000*4)) == NULL)   allocerr(5);

if ((faceverts = (unsigned *) malloc(4000*2)) == NULL)   allocerr(6);

if ((texed = (texedge *) malloc(2000*32)) == NULL)   allocerr(7);
if ((texts = (texstats *) malloc(2000*16)) == NULL)   allocerr(8);
if ((texpos = (texpoly *) malloc(500*16)) == NULL)   allocerr(9);
if ((vertnorms = (long *) malloc(800*12)) == NULL)   allocerr(10);


// Following are the variables used in the main menu of the program

char maincomm;
unsigned char *tempcharptr;

// Miscellaneous initializations

for(count=0;count<=99;count++)
   {
   texgroupused[count]=0;
   }


// set up miscellaneous stuff

nullpolyval=FP_OFF(polys) + 16*799;
polys[799].backfill=-1;


while(1)
   {
updatethispuppy:

   clrscr();
   cprintf("\n\r");
   cprintf(" CONV v1.00-   Vector object conversion utility\n\r");
   cprintf("                by Jason Hoerner\n\n\r");
   cprintf("             1.  Read in 3D object from file\n\r");
   cprintf("             2.  Write 3D object to file\n\r");


justgetakey:
   maincomm=getch();

   switch(maincomm)
      {
      case '1':{
	       load3D(abc, &numgrp, &numnorm, nullpolyval, rawpt, grppt, grplist, polys, norms, edgees, texed, texts, texpos, bitmaparrays, bitmapsizes, somegous, vertnorms, &numbitmap, xyz, texgroupused, texgroupsizes, texpolyarrays);
	       conv3D(abc, rawpt, grplist, polys, norms, edgees, texed, texts, somegous, xyz, thefaces, thegous, thetexs, faceverts);
	       asm jmp updatethispuppy;
	       }

      case '2':{
      	       dumpved04(abc[0], rawpt, thefaces);
	       asm jmp updatethispuppy;
	       }

      case  27:
      case 'q':
      case 'Q':
      case 'x':
      case 'X':{
	       cprintf("\n\n\rAre you sure you want to quit?  (Y/N)");
	       maincomm=getch();
	       if((maincomm>='a')&&(maincomm<='z')) maincomm=maincomm-'a'+'A';
	       if(maincomm=='Y') asm jmp weouttahere;
	       if(maincomm==0) getch();
	       asm jmp updatethispuppy;
	       }
      default :asm jmp justgetakey;
      }

   }

weouttahere:

   for(count=0;count<numbitmap;count++)
      {
      tempcharptr=bitmaparrays[count];
      free(tempcharptr);
      }

   free(vertnorms);
   free(texpos);
   free(texts);
   free(texed);
   free(rawpt);
   free(polys);
   free(thefaces);
   free(thegous);
   free(thetexs);
   exit(0);

}
