#include "errors.h"
#include <io.h>
#include <stdio.h>
#include <stdlib.h>

extern int TMPInput;
extern int hInputFile;
extern char TMPFile[];


char    *ETypes[] = { "",
			"Warning: ",
			"Error: ",
			"Internal Error: " };


char    *EStrings[] = { "",
	"Bad file type given \"%s\"",
	"Invalid command line",
	"Invalid header specified for file type, must be /H[+ | -]",
	"Invalid header length given",
	"File type does not support tail",
	"Invalid tail length given",
	"Unknown switch: \"%s\"",
	"Extra characters on command line",
	"Input file is not a valid type",
	"Input file has 0 length",
	"Invalid head or tail length specified",
	"Input file exceeds 64K segment limit",
	"Split file input limit exceeded",
	"Couldn't open \"%s\"",
	"Error writting to file",
	"Insufficient memory",
	"Invalid segment specifier",
	"Class definition requires closing ' character",
	"Invalid AfterRecordType given while constructing record list",
	"Unexpected end of file",
	"Wrong size for BMHD chunk",
	"Wrong size for CMAP chunk",
	"No raster data in GIF file",
	"Insufficient memory for GIF decoder",
	"Bad Code Size",
	"Read Error",
	"Write Error",
	"Open Error",
	"Create Error",
	"Unknown compression version used in LBM file, unable to decode",
	"Vital chunk(s) are missing from LBM file"

	};


void    Error(int ErrorType, int ErrorMsg, void *pMsgArg, int ErrorCode)
{

	printf( ETypes[ErrorType] );

	if( pMsgArg != NULL )
		printf(EStrings[ErrorMsg], pMsgArg);
	else
		printf(EStrings[ErrorMsg]);

	if(TMPInput) {
		close(hInputFile);
		remove(TMPFile);
	}
	 exit( ErrorCode );
}

