#pragma pack(1)                 /* To avoid problems with 2OBJ.C        */

#include <stdio.h>
#include <stdlib.h>

typedef struct
	{
	char    RecordType;     /* The type of the node (record)*/
	short   FieldLength;    /* Length of the data record.   */
	void    *pDataRecord;
	void    *pNextNode;
	} ListNode;

typedef struct
	{
	ListNode *pHead;
	short   NodeCount;
	} ListHandle;


void *(*AllocMemory)(int size); /* Memory allocation function.          */


void InitialiseSLINK(void *(*AllocFunction)())
{
	/* This procedure will initialise the SLINK procedures, which   */
	/* at the moment requires only the initialising of the memory   */
	/* allocation function pointer.                                 */

	AllocMemory = AllocFunction;
}


void    InitialiseList(ListHandle *pList)
{
	/* Initialising a list handle requires only the resetting of    */
	/* the head pointer and the node count.                         */

	pList->pHead = NULL;
	pList->NodeCount = 0;
}


ListNode *InsertListNode(ListHandle *pHandle, char NewRecordType,       \
						short NewFieldLength,   \
						void *pNodeData,        \
						ListNode *pPreviousNode)
{
	/* This procedure will insert a node into the list identified   */
	/* by pHandle.  The new node will be inserted after the node    */
	/* pPreviousNode, which can also be NULL to specify insertion   */
	/* at the head.  A pointer to the new node is returned.         */

	ListNode *pNewNode;

	pNewNode = (*AllocMemory)(sizeof (ListNode) );

	pNewNode->RecordType = NewRecordType;
	pNewNode->FieldLength = NewFieldLength;
	pNewNode->pDataRecord = pNodeData;

	if( pPreviousNode != NULL ) {
		pNewNode->pNextNode = pPreviousNode->pNextNode;
		pPreviousNode->pNextNode = pNewNode;
	}
	else {
		pNewNode->pNextNode = pHandle->pHead;
		pHandle->pHead = pNewNode;
	}
	pHandle->NodeCount++;

	return pNewNode;
}


ListNode *SeekRecordType(ListNode *pCurrentNode, char SeekToType)
{
	/* This procedure will search the list from the starting node   */
	/* specified until it finds a node that matches the SeekToType. */
	/* A pointer to the matching node or NULL is returned.          */

	while( pCurrentNode != NULL ) {
		if( pCurrentNode->RecordType == SeekToType )
			break;
		pCurrentNode = pCurrentNode->pNextNode;
	}
	return pCurrentNode;
}


ListNode *IndexedSeekNode(ListHandle *pHandle, int NodeCount)
{
	/* This procedure will move forward through the list identified */
	/* by pHandle by a certain number of nodes (NodeCount).  The    */
	/* final node reached or the last node in the list if the count */
	/* was larger than the number of nodes is returned.             */

	ListNode *pCurrentNode;
	ListNode *pReturnNode;

	pCurrentNode = pReturnNode = pHandle->pHead;
	while( NodeCount && pCurrentNode != NULL) {
		pReturnNode = pCurrentNode;
		pCurrentNode = pCurrentNode->pNextNode;
	}
	return pReturnNode;
}


void    DeleteListNode(ListHandle *pHandle, ListNode *pPreviousNode)
{
	/* This procedure will delete the node immediately following    */
	/* pPreviousNode from the pHandle list.  To delete the head node*/
	/* then pPreviousNode should be NULL.  The memory associated    */
	/* with the ListNode structure will be freed, but not so any    */
	/* data pointers.                                               */

	ListNode *pDoomedNode;

	if(pPreviousNode == NULL) {
		pDoomedNode = pHandle->pHead;
		pHandle->pHead = pDoomedNode->pNextNode;
	}
	else {
		if( (pDoomedNode = pPreviousNode->pNextNode) == NULL)
			return;

		pPreviousNode->pNextNode = pDoomedNode->pNextNode;
	}
	pHandle->NodeCount--;

	free(pDoomedNode);
}
