page 60,132

; BMP to BPI (Bit Plane Image) converter
;
;
; Dave Springer, Feb. 1994
; Copyright (C) 1994 Springer Engineering
;
; misc equates
;
cr	equ	0dh
lf	equ	0ah
eom	equ	'$'

cseg     segment   para public 'CODE'
;
	 org	   100h	

         assume    cs:cseg,ds:cseg,es:cseg,ss:cseg

plane1 equ 2		;2
plane2 equ 3		;3
plane3 equ 4		;1
plane4 equ 1		;4

transparent_plane equ 5

post   proc      near      	

	call get_filenames
	call initialize			;initialize file stuff

start_plane equ 2

	mov plane_number,plane1
	call state_start
	call store_header
	call do_plane

	mov plane_number,plane2
	call state_start
	call store_header
	call do_plane

	mov plane_number,plane3
	call state_start
	call store_header
	call do_plane

	mov plane_number,plane4
	call state_start
	call store_header
	call do_plane

	cmp transparent_plane_flag,1
	jne no_transparent_plane
	mov plane_number,transparent_plane
	call state_start
	call store_header
	call do_plane
no_transparent_plane:
	jmp end_program			;finish it off

;***************** subroutines (start here) *****************
; hahhahaha. Verbose, aren't I ?
;**********************************

store_header:
	cmp plane_number,plane1
	jne store_header_done

	mov bx,rows
	mov al,bl
	call store_sample
	mov al,bh
	call store_sample
	mov bx,columns
	mov al,bl
	call store_sample
	mov al,bh
	call store_sample
	mov al,transparent_plane_flag
	call store_sample

	mov cx,11
sth_loop:
	xor al,al
	call store_sample
	loop sth_loop

store_header_done:
	mov ax,columns
	ror ax,1
	ror ax,1
	ror ax,1
	test ah,0e0h
	jz ss_1
	and ah,1fh
	inc ax
ss_1:
	shl ax,1
	shl ax,1
	mov bytes_per_row,ax

	mov ah,42h
	mov al,2
	mov bx,in_handle
	xor cx,cx
	dec cx
	xor dx,dx
	sub dx,bytes_per_row
	int 21h
	mov ah,3fh
	mov bx,in_handle
	mov cx,bytes_per_row
	mov dx,offset in_buf
	int 21h
	ret

do_plane:
	mov cx,bytes_per_row
	shr cx,1
	shr cx,1
	mov si,offset in_buf
do_row:
	push cx
	cmp plane_number,transparent_plane
	jne do_normal_row
	call make_transparent_byte
	pop cx
	loop do_row
	jmp dp_row_done
do_normal_row:
	call make_byte
	pop cx
	loop do_row
dp_row_done:
	dec rows
	jz do_plane_done
	call back_up_2_rows
	jmp do_plane
do_plane_done:
	ret

make_byte:
	mov ch,plane_number
	xor bl,bl
	lodsb

	mov cl,ch
	rol al,cl
	rcl bl,1
	mov cl,4
	rol al,cl
	rcl bl,1

	lodsb

	mov cl,ch
	rol al,cl
	rcl bl,1
	mov cl,4
	rol al,cl
	rcl bl,1

	lodsb

	mov cl,ch
	rol al,cl
	rcl bl,1
	mov cl,4
	rol al,cl
	rcl bl,1

	lodsb

	mov cl,ch
	rol al,cl
	rcl bl,1
	mov cl,4
	rol al,cl
	rcl bl,1

	mov al,bl
	call store_sample
	ret


make_transparent_byte:

	xor bl,bl
	mov cx,4
mtb_src_byte_loop:
	push cx
	mov cl,4
	lodsb
	mov ah,al
	rol al,cl
	and al,0fh
	cmp al,transparent_plane_color
	clc
	jz mtb_even_pix_done
	stc
mtb_even_pix_done:
	rcl bl,1
	and ah,0fh
	cmp ah,transparent_plane_color
	clc
	jz mtb_odd_pix_done
	stc
mtb_odd_pix_done:
	rcl bl,1
	pop cx
	loop mtb_src_byte_loop

	mov al,bl
	call store_sample
	ret

plane_number db start_plane
rows dw 0
columns dw 0
data_start dw 0
bytes_per_row dw 0
transparent_plane_flag db 0
transparent_plane_color db 0

back_up_2_rows:
	push ax
	push bx
	push cx
	push dx
	mov ah,42h
	mov al,1
	mov bx,in_handle
	xor cx,cx
	dec cx
	xor dx,dx
	sub dx,bytes_per_row
	sub dx,bytes_per_row
	int 21h

	mov ah,3fh
	mov bx,in_handle
	mov cx,bytes_per_row
	mov dx,offset in_buf
	int 21h
	pop dx
	pop cx
	pop bx
	pop ax
	ret

state_start:		
	call reset_input_file	
	mov cx,0ah
ss_loop1:
	call get_sample
	loop ss_loop1

	call get_sample
	mov bl,al
	call get_sample
	mov bh,al
	mov data_start,bx

	mov cx,6
ss_loop2:
	call get_sample
	loop ss_loop2

	call get_sample
	mov bl,al
	call get_sample
	mov bh,al
	mov columns,bx
	call get_sample
	call get_sample
	call get_sample
	mov bl,al
	call get_sample
	mov bh,al
	mov rows,bx

	call reset_input_file

	mov cx,data_start
ss_loop3:
	call get_sample
	loop ss_loop3

	ret

reset_input_file:
	xor ax,ax
	mov end_file_flag,al		;end of file false
	mov final_in_buf_top,ax		;final inbuf false
	mov in_buf_ptr,offset in_buf_top;force buffer read
	mov ax,4200h			;move file pointer to
beginning of file
	mov bx,in_handle		;for the input file
	xor cx,cx			;zero into big count
	mov dx,00h			;skip over offset
	int 21h				;do it
	ret

reset_output_file:
	mov ah,40h			;first flush any buffers
	mov cx,out_buf_ptr
	sub cx,offset out_buf
	jz rof_flushed
	mov dx,offset out_buf
	mov bx,out_handle
	int 21h				;flush final out buffer
rof_flushed:
	mov out_buf_ptr,offset out_buf_top ;force buffer read
	mov ax,4200h			;move file pointer to
beginning of file
	mov bx,out_handle		;for the input file
	xor cx,cx			;zero into big count
	mov dx,00h			;skip over offset
	int 21h				;do it
	ret

get_filenames:
	mov si,80h
	mov cl,[si]
	xor ch,ch		;get command tail length
	cmp cx,2		;see if any there
	jl exit1		;else exit
	mov bx,offset in_file
	inc si
	cmp byte ptr [si],' '
	je file_parse_loop
exit1:
	call signon
	mov dx,offset file_error_mess
	mov ah,9
	int 21h
	int 20h

file_parse_loop:		;parse out one filename
	inc si
	mov al,[si]
	cmp al,cr
	je finish_filename
	cmp al,' '
	jne filename_cont
				;get the bit plane flag here if
present
	inc si
	mov al,[si]
	sub al,30h
	jge bpf_1
	jmp init_exit
bpf_1:
	cmp al,9
	jle bpf_good
	sub al,7
	cmp al,0ah
	jge bpf_2
	jmp init_exit	
bpf_2:
	cmp al,0fh
	jle bpf_good
	jmp init_exit
bpf_good:
	mov transparent_plane_flag,1
	mov transparent_plane_color,al
	jmp finish_filename
filename_cont:
	mov [bx],al
	inc bx
	loop file_parse_loop
finish_filename:
	mov byte ptr [bx],'.'
	inc bx
	mov byte ptr [bx],'b'
	inc bx
	mov byte ptr [bx],'m'
	inc bx
	mov byte ptr [bx],'p'
	inc bx
	mov byte ptr [bx],0
	mov si,offset in_file
	mov bx,offset out_file
ffn_loop:
	mov al,[si]
	cmp al,'.'
	jne ffnl_1
;	mov byte ptr [bx],'s'
;	inc bx
ffnl_1:
	mov [bx],al
	inc si
	inc bx
	cmp al,'.'
	jne ffn_loop
	mov byte ptr [bx],'b'
	inc bx
	mov byte ptr [bx],'p'
	inc bx
	mov byte ptr [bx],'i'
	inc bx
	mov byte ptr [bx],0
	ret


store_sample:			;store sample in al and flush out
buffer
	push ax			;if necessary
	push bx
	push cx
	push dx
	push di
	mov di,out_buf_ptr
	mov [di],al
	inc di
	mov out_buf_ptr,di
	cmp di,offset out_buf_top
	jne store_sample_done
	mov ah,40h
	mov cx,1000h
	mov dx,offset out_buf
	mov bx,out_handle
	int 21h			;flush output buffer
	mov out_buf_ptr,offset out_buf
store_sample_done:
	pop di
	pop dx
	pop cx
	pop bx
	pop ax
	ret

get_sample:		;return next sample in al - uses AX
	push bx		;carry set if last sample
	push cx
	push dx
	push si
	mov si,in_buf_ptr
	cmp end_file_flag,0
	je gs_not_end_of_file
	mov al,[si]
	inc si
	cmp si,final_in_buf_top
	mov in_buf_ptr,si
	jne gs_not_last_exit
	stc
	jmp get_sample_exit
gs_not_end_of_file:
	cmp si,offset in_buf_top
	jne gs_no_new_buffer
	mov ah,3fh
	mov cx,1000h
	mov bx,in_handle
	mov dx,offset in_buf
	int 21h			;get first part of input file
	mov si,offset in_buf
	cmp ax,cx
	je gs_no_new_buffer
	mov end_file_flag,1	;mark end of file if so
	add ax,offset in_buf
	mov final_in_buf_top,ax
gs_no_new_buffer:
	mov al,[si]
	inc si
	mov in_buf_ptr,si
gs_not_last_exit:
	clc
get_sample_exit:
	pop si
	pop dx
	pop cx
	pop bx
	ret

in_file db 60 dup (0)
out_file db 60 dup (0)
in_handle dw 0
out_handle dw 0
end_file_flag db 0
final_in_buf_top dw 0
in_buf_ptr dw offset in_buf
out_buf_ptr dw offset out_buf

end_program:
	mov ah,40h
	mov cx,out_buf_ptr
	sub cx,offset out_buf
	jz end_program1
	mov dx,offset out_buf
	mov bx,out_handle
	int 21h			;flush final out buffer
end_program1:
	mov ah,3eh
	mov bx,out_handle	
	int 21h			;close out file
	mov ah,3eh
	mov bx,in_handle
	int 21h			;close in file
	mov dx,offset done_message
	mov ah,9
	int 21h			;print done message
	int 20h			;back to dos
	
done_message db cr,lf,'BMP to BPI File successfully converted',eom

initialize:
	mov ah,3dh
	xor al,al
	mov dx,offset in_file
	int 21h			;open input file for read only access
	jc init_exit
	mov in_handle,ax
	mov ah,3ch
	xor cx,cx
	mov dx,offset out_file
	int 21h			;create or open and truncate output
file
	jc init_exit
	mov out_handle,ax
	mov ah,3fh
	mov cx,1000h
	mov bx,in_handle
	mov dx,offset in_buf
	int 21h			;get first part of input file
	cmp ax,cx
	je init_1
	mov end_file_flag,1	;mark end of file if so
	add ax,offset in_buf
	mov final_in_buf_top,ax
init_1:
	mov si,in_buf_ptr
	mov di,out_buf_ptr      ;set up buffer indexes
	mov in_buf_ptr,si
	mov out_buf_ptr,di	;update buffer indexes
	ret
init_exit:
	call signon
	mov dx,offset file_error_mess
	mov ah,9
	int 21h
	int 20h

file_error_mess db cr,lf,lf,'File Error - program aborted.',cr,lf,eom

signon:
	mov dx,offset usage_mess
	mov ah,9
	int 21h
	ret

usage_mess label byte
db cr,lf
db '.BMP to .BPI File Convertor V1.0 - Copyright 1993 Springer
Engineering'
db cr,lf,lf
db '                    Usage - BMP2BPI filename [C]'
db cr,lf,lf
db '                    Where C is the optional color (0-9 or A-F)
build a'
db cr,lf
db '                    transparency plane from.',cr,lf,lf
db '                    (Input File Extension of .BMP is
assumed)',cr,lf
db '                    (Output File is [filename].BPI)',cr,lf,eom

get_key:
	mov ah,1	;get any key
	int 16h
	jz gks_nokey
	mov ah,0	;clear out the key and exit
	int 16h
	stc
	ret
gks_nokey:
	clc
	ret

text_color db 0ffh
row db 0
column db 0

gotoxy:
	mov ah,2
	xor bh,bh
	mov dh,row
	mov dl,column
	int 10h
	ret

print_string:
	mov al,[si]
	or al,al
	je pstring_done
	mov ah,14
	mov bl,text_color
	int 10h
	inc si
	jmp print_string
pstring_done:
	ret

print_ax:			;PRINT THE WORD IN AX
	push ax			;AT SCN_PTR
	push bx
	push cx
	push dx

	push si
	push di
	push ds
	push es
	push bp
	pushf

	push ax
	mov al,ah
	xor ah,ah
	call hex2ascii
	push dx
	mov al,dl
	call print_AL
	pop dx
	mov al,dh
	call print_al
	pop ax
	xor ah,ah
	call hex2ascii
	push dx
	mov al,dl
	call print_al
	pop dx
	mov al,dh
	call print_al
	mov al,20h
	call print_al

print_ax_done:
	popf
	pop bp
	pop es
	pop ds
	pop di
	pop si
	pop dx
	pop cx
	pop bx
	pop ax
	ret

print_al:
	mov ah,14
	mov bl,text_color
	int 10h
	ret

hex2ascii:	;convert al reg to ascii in dx (low nibble in dh)
	mov si,offset hex_conv
	mov cx,ax
	and ax,0f0h
	shr ax,1
	shr ax,1
	shr ax,1
	shr ax,1
	mov bx,ax
	mov dl,cs:[si+bx]
	and cx,0fh
	mov bx,cx
	mov dh,cs:[si+bx]
	ret

hex_conv 	db 	'0123456789abcdef'

;*************************************** END HEX DISPLAY ROUTINES
;
; Display decimal number in BX.
; ASCII ZERO STRING RETURNED IN DECIMAL_STRING
;
decimal_string db 10 dup (0)

DMSDEC:
	push es
	push ds
	pop es
	mov di,offset decimal_string
	PUSH	AX
	PUSH	CX
	PUSH	DX
	PUSH	BX		; save regs
	MOV	AL,' '		; load space fill char
	STOSB			; pad decimal with space
	XOR	AH,AH		; clear non-display counter
	XOR	CL,CL		; clear leading zero flag
	MOV	DX,10000
	CALL	_DO1		; display 10,000's digit
	MOV	DX,1000
	CALL	_DO1		; display 1,000's digit
	MOV	DX,100
	CALL	_DO1		; display 100's digit
	MOV	DX,10
	CALL	_DO1		; display 10's digit
	INC	CL
	MOV	DX,1
	CALL	_DO1		; display 1's digit
	OR	AH,AH		; non-display present?
	JZ	_DOX		; if not, exit
	MOV	AL,' '		; else, load space fill
_SPL:	STOSB			; write a space
	DEC	AH		; more to write?
	JNZ	_SPL		; if so, continue
_DOX:
	mov al,0
	stosb
	pop es
	POP	BX
	POP	DX
	POP	CX
	POP	AX		; restore regs
	RET			; done
_DO1:	MOV	CH,-1		; load quotient reg
_DOL:	INC	CH		; inc reg
	SUB	BX,DX		; try the subtract
	JNB	_DOL		; if good, continue
	ADD	BX,DX		; else, restore remainder
	MOV	AL,CH		; get quotient
	OR	AL,AL		; results=0?
	JNZ	_DO2		; if not, continue
	OR	CL,CL		; leading zero?
	JNZ	_DO2		; if not, continue
	INC	AH		; inc non-display count
	RET			; done
_DO2:	INC	CL		; inc leading zero flag
	ADD	AL,"0"		; add ASCII bias
	STOSB			; write to screen
	RET			; done


in_buf  equ $
in_buf_top equ $+1000h
out_buf equ $+1000h
out_buf_top equ $+2000h

post  endp
			
cseg    ends

         end       post

