{$I-}
{ coded by Paradise - use /help for more info }
uses Crt,Dos,BinHex;

const
  MaxLen = 60;

var
  { variables }
  input_name, output_name  : string;
  input_file               : file;
  output_file              : text;
  fsize, counter           : longint;
  b                        : byte;
  w                        : word;
  line,name                : string;
  vstr                     : string;
  { options }
  wordmode, binmode,
  hexmode, decmode,
  asciimode                : boolean;

procedure Pause;
begin
  writeln('Pause (Press any key to continue)...');
  readkey;
  while keypressed do readkey;
  writeln;
end;

procedure ShowHelp;
begin
  writeln;
  writeln('- -- -  HeLP 4 BiN2iNC -   -- ');
  writeln('- 1994,III.3, Lublin, Poland, Earth, Milky Way, Sun System.... ');
  writeln;
  writeln('This util has been coded by Paradise (a.k.a Marcin Jaskowiak),');
  writeln('to help you with converting binary files to assembler data inc.');
  writeln('Here comes the usage...');
  writeln;
  writeln('Options:             Info: ');
  writeln('   /help              - show this help ');
  writeln('   /word              - turn on word mode (standard is byte) ');
  writeln('   /hex               - turn on hex mode (standard is dec) ');
  writeln('                        example: the "db 68" will be replaced by ');
  writeln('                        "db 044h" etc, etc.. ');
  writeln('   /bin               - turn on binary mode, same as /hex but ');
  writeln('                        for example: "db 3" will be replaced by ');
  writeln('                        "db 00000011b" or "db 0000000000000011b" ');
  writeln('                        in word mode ');
  writeln('   /ascii             - same as /hex & /bin but byte for ex. "db 65" ');
  writeln('                        will be replace by "db ''A''" ');
  writeln;
  pause;
  writeln('If you have some problems or comments you can mail me to : ');
  writeln(' paradise@bachus.umcs.lublin.pl or ');
  writeln(' paradise@ajax.umcs.lublin.pl or ');
  writeln(' paradise@anon.penet.fi ');
  writeln;
  writeln('You can also catch me on IRC on #coders or *private* :) or chat ');
  writeln('me on mpoli bbs. ');
  writeln;
  writeln('My snail-mail address is : ');
  writeln(' Marcin Jaskowiak ');
  writeln(' Ul.Zarnowiecka 3/114 ');
  writeln(' 20-630 Lublin, Poland ');
  writeln;
  writeln('That''s all folks!');
  Halt(0);
end;

procedure ParseOptions;
var
  cnt : byte;
  pst : string;
begin
  { default options }
  wordmode:=false;
  binmode:=false;
  hexmode:=false;
  decmode:=true;
  asciimode:=false;
  { read parameters }
  for cnt:=1 to paramcount do
  begin
    pst:=paramstr(cnt);
    if pst='/word' then wordmode:=true else
    if (pst='/help') or (pst='/h') or (pst='/?') then ShowHelp else
    if pst='/hex' then
    begin
      hexmode:=true;
      decmode:=false;
      binmode:=false;
      asciimode:=false;
    end else
    if pst='/ascii' then
    begin
      asciimode:=true;
      decmode:=false;
      binmode:=false;
      hexmode:=false;
    end else
    if pst='/bin' then
    begin
      binmode:=true;
      decmode:=false;
      hexmode:=false;
      asciimode:=false;
    end else
    begin
     if cnt=1 then input_name:=pst;
     if cnt=2 then output_name:=pst;
    end;
  end;
end;

procedure Ask(title : string; var result : string);
begin
  write(title);
  readln(result);
end;

function NoFile(fname : string): boolean;
var
  okie : boolean;
  ff   : file;
begin
  assign(ff,fname);
  reset(ff,1);
  okie:=(IOResult=0);
  if okie then close(ff);
  NoFile:=not okie;
end;

procedure Error(title : string);
begin
  writeln('Error! ',title,'.');
  writeln('Abnormal program termination.');
  halt(1);
end;

procedure Warning(title: string);
begin
  writeln('Warning! ',title,'.');
end;

procedure Convert;
begin
 if asciimode and wordmode then Error('Cannot use word and ascii mode together');
 writeln('Converting "',input_name,'" to "',output_name,'".');
 assign(input_file,input_name);
 assign(output_file,output_name);
 reset(input_file,1);
 rewrite(output_file);
 fsize:=filesize(input_file);
 if (fsize mod 2<>0) and wordmode then
 begin
   dec(fsize);
   Warning('File size fail, size truncated');
 end;
 if wordmode then fsize:=fsize div 2;
 line:='     db ';
 for counter :=1 to fsize do
 begin
   if wordmode then blockread(input_file,w,2)
               else blockread(input_file,b,1);
   if hexmode  then
   begin
     if wordmode then vstr:=Word2Hex(w)
                 else vstr:=Byte2Hex(b);
   end;
   if binmode  then
   begin
     if wordmode then vstr:=Word2Bin(w)
                 else vstr:=Byte2Bin(b);
   end;
   if decmode  then
   begin
     if wordmode then vstr:=Word2Dec(w)
                 else vstr:=Byte2Dec(b);
   end;
   if asciimode  then
   begin
     vstr:=Byte2Asc(b);
   end;
   line:=line+vstr;
   if length(line)>MaxLen then
   begin
     writeln(output_file,line);
     line:='     db ';
   end else line:=line+',';
 end;
 if line[length(line)]=',' then line[length(line)]:=' ';
 if line<>'     db ' then writeln(output_file,line);
 close(input_file);
 close(output_file);
end;

begin
  writeln;
  writeln('BiN2iNC version 1.1 (c) 1995 by Paradise');
  writeln('Use param "/help" for help and info.');
  ParseOptions;
  if input_name='' then Ask('Enter input name : ',input_name);
  if input_name='' then Error('Interrupted by user');
  if pos('.',input_name)=0 then input_name:=input_name+'.';
  if NoFile(input_name) then Error('Cannot find input file');
  name:=copy(input_name,1,pos('.',input_name))+'inc';
  if output_name='' then Ask('Enter output name ('+name+') : ',output_name);
  if output_name='' then output_name:=name;
  Convert;
  writeln('That''s all folks!');
end.


