//
// PROGRAM FILE:  fnt2bdf.c
//
// PURPOSE:    This file contains the individual methods
//	       that compose the fnt2bdf class.
//
// PROGRAMMER: Kevin Carothers
//
// PLACE:      Transaction Technology, Inc.
//

#define MAP_BEG	118 

extern "C" {
#include <stdio.h>
}
#include <stream.h>
#include <sys/param.h>
#include <sys/types.h>

#include "fnt2bdf.hh"


CPE_FONT::CPE_FONT(char *fnt_file_name)
{
void usage(void);
FILE   *fp;
int     ic=0, done = FALSE;
 
    cpe_max_bytes = 0;	// member data member initialization
    strcpy(cpe_filename, fnt_file_name);
 
    if(strcmp(cpe_filename, "") == 0)
        usage();
 
    if((fp = fopen(cpe_filename, "r")) == (FILE *) 0)
        usage();

    for(done=FALSE;done != TRUE; ) {
        file_buffer[cpe_max_bytes] = (unsigned char) getc(fp);
        if (!feof(fp) && cpe_max_bytes < BUFMAX)
            cpe_max_bytes++;
        else
            done = TRUE;
        }
    fclose(fp);

    // 
    // Read the file -- now set up the font pointers, etc...
    //
    bcopy(file_buffer, (char *) &cpe_font_struct.hdr, sizeof(struct fnt_hdrS));

    {    	// set up the charWidth/charOffset  structure pairs (dfCharTable)...
    int l_fchar = return_data_value(dfChar, cpe_font_struct.hdr.dfFirstChar),		 //  dfFirstChar; 
        l_lchar = return_data_value(dfChar, cpe_font_struct.hdr.dfLastChar); 		 //  dfLastChar; 

    int l_len = l_lchar-l_fchar, l_ptr = MAP_BEG;

    // malloc size = (# chars) * sizeof(WinCharS)
    if((cpe_font_struct.dfCharTable = (struct WinCharS *) calloc(sizeof(struct WinCharS), l_len)) == NULL) {
	printf("can't malloc room for dfCharTable\n");
	exit(0);
	}

    // NOW, convert them all to UNIX (lton) notation...
    for(ic=0; ic < l_len; ic++) {
   	cpe_font_struct.dfCharTable[ic].charWidth = return_data_value(dfShort, &file_buffer[l_ptr]);
	l_ptr += 2;	// bump by sizeof(short)


	if( return_data_value(dfShort, cpe_font_struct.hdr.dfVersion) == 0x200) {
	    cpe_font_struct.dfCharTable[ic].charOffset = 
			return_data_value(dfShort, &file_buffer[l_ptr]);
	    l_ptr += 2;	// bump by sizeof(long)
	    }
	else { 	//  Windows Version 3.0 type font
	    cpe_font_struct.dfCharTable[ic].charOffset = 
			return_data_value(dfLong, &file_buffer[l_ptr]);
	    l_ptr += 4;	// bump by sizeof(long)
	    }
	}
    }

   
}

CPE_FONT::~CPE_FONT(void)
{
}

void
CPE_FONT::dump_font_hdr(void)
{
int	ret_value;

    printf("Font Header:   \n");
    printf("    dfVersion = 0x%x\n", 
	return_data_value(dfShort, cpe_font_struct.hdr.dfVersion));   	    //  dfVersion[2]; 	

    printf("    dfSize = 0x%x\n", 
	return_data_value(dfLong, cpe_font_struct.hdr.dfSize));    	    //  dfSize[4];            
    printf("    dfCopyright = %s\n", 
	cpe_font_struct.hdr.dfCopyright);      			//  dfCopyright[60];      

    printf("    dfType = 0x%x\n", 
	return_data_value(dfShort, cpe_font_struct.hdr.dfType));    	    //  dfType[2];

    printf("    dfPoints = 0x%x\n", 
	return_data_value(dfShort, cpe_font_struct.hdr.dfPoints));    	    //  dfPoints[2];

    printf("    dfVertRes = 0x%x\n", 
	return_data_value(dfShort, cpe_font_struct.hdr.dfVertRes));    	    //  dfVertRes[2]

    printf("    dfHorizRes = 0x%x\n", 
	return_data_value(dfShort, cpe_font_struct.hdr.dfHorizRes));        //  dfHorizRes[2]

    printf("    dfAscent = 0x%x\n", 
	return_data_value(dfShort, cpe_font_struct.hdr.dfAscent));    	    //  dfAscent[2];

    printf("    dfInternalLeading = 0x%x\n", 
	return_data_value(dfShort, cpe_font_struct.hdr.dfInternalLeading));   //  dfInternalLeading

    printf("    dfExternalLeading = 0x%x\n", 
	return_data_value(dfShort, cpe_font_struct.hdr.dfExternalLeading));   //  dfExternalLeading[2]; 

    printf("    dfItalic = 0x%x\n", 
	return_data_value(dfChar, cpe_font_struct.hdr.dfItalic));    	    //  dfItalic

    printf("    dfUnderline = 0x%x\n", 
	return_data_value(dfChar, cpe_font_struct.hdr.dfUnderline));       //  dfUnderline;

    printf("    dfStrikeOut = 0x%x\n", 
	return_data_value(dfChar, cpe_font_struct.hdr.dfStrikeOut));       //  dfStrikeOut;

    printf("    dfWeight = 0x%x\n", 
	return_data_value(dfShort, cpe_font_struct.hdr.dfWeight));    	    //  dfWeight[2]; 

    printf("    dfCharSet = 0x%x\n", 
	return_data_value(dfChar, cpe_font_struct.hdr.dfCharSet));    	    //  dfCharSet; 

    printf("    dfPixWidth = 0x%x\n", 
	return_data_value(dfShort, cpe_font_struct.hdr.dfPixWidth));        //  dfPixWidth[2]

    printf("    dfPixHeight = 0x%x\n", 
	return_data_value(dfShort, cpe_font_struct.hdr.dfPixHeight));      //  dfPixHeight[2]

    printf("    dfPitchAndFamily = 0x%x\n", 
	return_data_value(dfChar, cpe_font_struct.hdr.dfPitchAndFamily)); //  dfPitchAndFamily

    printf("    dfAvgWidth = 0x%x\n", 
	return_data_value(dfShort, cpe_font_struct.hdr.dfAvgWidth));        //  dfAvgWidth[2];

    printf("    dfMaxWidth = 0x%x\n", 
	return_data_value(dfShort, cpe_font_struct.hdr.dfMaxWidth));   	    //  dfMaxWidth[2];

    printf("    dfFirstChar = 0x%x\n", 
	return_data_value(dfChar, cpe_font_struct.hdr.dfFirstChar));       //  dfFirstChar;

    printf("    dfLastChar = 0x%x\n", 
	return_data_value(dfChar, cpe_font_struct.hdr.dfLastChar));    	    //  dfLastChar;

    printf("    dfDefaultChar = 0x%x\n", 
	return_data_value(dfChar, cpe_font_struct.hdr.dfDefaultChar));   //  dfDefaultChar;

    printf("    dfBreakChar = 0x%x\n", 
	return_data_value(dfChar, cpe_font_struct.hdr.dfBreakChar));       //  dfBreakChar; 

    printf("    dfWidthBytes = 0x%x\n", 
	return_data_value(dfShort, cpe_font_struct.hdr.dfWidthBytes));    //  dfWidthBytes[2];

    printf("    dfDevice = 0x%x\n", 
	return_data_value(dfLong, cpe_font_struct.hdr.dfDevice));    	    //  dfDevice[4];

    printf("    dfFace = 0x%x\n", 
	return_data_value(dfLong, cpe_font_struct.hdr.dfFace));   //  dfFace[4];

    printf("    dfBitsPointer = 0x%x\n", 
	return_data_value(dfLong, cpe_font_struct.hdr.dfBitsPointer)); //  dfBitsPointer[4];

    printf("    dfBitsOffset = 0x%x\n", 
	return_data_value(dfLong, cpe_font_struct.hdr.dfBitsOffset));    //  dfBitsOffset[4];

    // Not Used: printf("    dfReserved = 0x%x\n", 
	// Not Used: 	return_data_value(dfChar, cpe_font_struct.hdr.dfReserved));    	    //  dfReserved;

    // Not Used: printf("    dfFlags = 0x%x\n", 
	// Not Used: return_data_value(dfLong, cpe_font_struct.hdr.dfFlags));    	    //  dfFlags[4];

    // Not Used: printf("    dfAspace = 0x%x\n", 
	// Not Used: return_data_value(dfShort, cpe_font_struct.hdr.dfAspace));    	    //  dfAspace[2];

    // Not Used: printf("    dfBspace = 0x%x\n", 
	// Not Used: return_data_value(dfShort, cpe_font_struct.hdr.dfBspace));    	    //  dfBspace[2];

    // Not Used: printf("    dfCspace = 0x%x\n", 
	// Not Used: return_data_value(dfShort, cpe_font_struct.hdr.dfCspace));    	    //  dfCspace[2];

    // Not Used: printf("    dfColorTable = 0x%x\n", 
	// Not Used: return_data_value(dfShort, cpe_font_struct.hdr.dfColorTable));    //  dfColorTable[4];

    // Not Used: printf("    dfReserved1 = 0x%x\n", 
	// Not Used: return_data_value(dfLong, cpe_font_struct.hdr.dfReserved1));    //  dfReserved1[0][4];

}

void
CPE_FONT::dump_font_bitmaps(void)
{
int	ic, l_tot, ret_value;
    int l_fchar = return_data_value(dfChar, cpe_font_struct.hdr.dfFirstChar), //  dfFirstChar; 
        l_lchar = return_data_value(dfChar, cpe_font_struct.hdr.dfLastChar);  //  dfLastChar; 

    int l_len = l_lchar-l_fchar, 
	l_ptr = MAP_BEG,
	l_hgt = return_data_value(dfChar, cpe_font_struct.hdr.dfPixHeight); 

    // first, adjust l_len for unmapped chars, and last char...
    // NOW, convert them all to UNIX (lton) notation...
    for(ic=0; ic < l_len; ic++) {
	int rowidx, l_span,		// how many char-cols wide is char?
	    l_idx = cpe_font_struct.dfCharTable[ic].charOffset;

	if(cpe_font_struct.dfCharTable[ic].charWidth == 0) {
	    printf("\nChar 0x%x  is Unmapped...\n\n", ic);
	    l_fchar++;	// Go to next one
	    continue;
	    }

	l_span = (int) (cpe_font_struct.dfCharTable[ic].charWidth-1)/8; 

	printf("\n\nChar = 0x%x   (\"0x%x\")\n", ic, l_fchar);

	for(rowidx=0; rowidx < l_hgt; rowidx++) {
	    switch(l_span) {
		case(0):	// 1-7 pixels wide font
		    {
		    printf("%s\n", dotdash(file_buffer[l_idx+rowidx]));
		    break;
		    }
		
		case(1):	// 8-15 pixels wide font
		    {
		    printf("%s", dotdash(file_buffer[l_idx+rowidx]));
		    printf("%s", dotdash(file_buffer[l_idx+l_hgt+rowidx]));
		    printf("\n");
		    break;
		    }

		case(2):	// 16-23 pixels wide font
		    {
		    printf("%s", dotdash(file_buffer[l_idx+rowidx]));
		    printf("%s", dotdash(file_buffer[l_idx+l_hgt+rowidx]));
		    printf("%s", dotdash(file_buffer[l_idx+(2*l_hgt)+rowidx]));
		    printf("\n");
		    break;
		    }

		case(3):	// 24-31 pixels wide font
		    {
		    printf("%s", dotdash(file_buffer[l_idx+rowidx]));
		    printf("%s", dotdash(file_buffer[l_idx+l_hgt+rowidx]));
		    printf("%s", dotdash(file_buffer[l_idx+(2*l_hgt)+rowidx]));
		    printf("%s", dotdash(file_buffer[l_idx+(3*l_hgt)+rowidx]));
		    printf("\n");
		    break;
		    }

		default:
		    printf("Character  0x%x is TOO WIDE (%d)!\n", ic, cpe_font_struct.dfCharTable[ic].charWidth);
		    break;
		}
	    }
	l_fchar++;	// Go to next one
	}
}


void
CPE_FONT::dump_bdf(void)
{
int	ic, ret_value;
int     l_fchar = return_data_value(dfChar, cpe_font_struct.hdr.dfFirstChar), //  dfFirstChar; 
        l_lchar = return_data_value(dfChar, cpe_font_struct.hdr.dfLastChar);  //  dfLastChar; 

int     l_len = l_lchar-l_fchar, 
        l_ptr = MAP_BEG,
        l_hgt = return_data_value(dfChar, cpe_font_struct.hdr.dfPixHeight); 
FILE   *fp;
char    l_filename[256];

    make_bdf_filename(l_filename);	// this is the name we'll use for our output file

    if((fp = fopen(l_filename, "w")) == (FILE *) 0)   {
	printf("Couldn't open \"%s\" for output. Bye...\n", l_filename);
	exit(-1);
	}

    dump_bdf_hdr();	// Write the header (up to the 1st STARTCHAR cmd)

    // NOW, convert all chars to UNIX (lton) notation...
    for(ic=0; ic < l_len; ic++) {
	int rowidx, l_span,		// how many char-cols wide is char?
	    l_idx = cpe_font_struct.dfCharTable[ic].charOffset;

	l_span = (int) (cpe_font_struct.dfCharTable[ic].charWidth-1)/8; 

	printf("STARTCHAR %d  \n", ic);
	printf("ENCODING %d\n",   l_fchar);
	printf("SWIDTH    %d    %d \n", 
		cpe_font_struct.dfCharTable[ic].charWidth*1000, 
		l_hgt*1000);

	printf("DWIDTH    %d    %d \n", 
		cpe_font_struct.dfCharTable[ic].charWidth, l_hgt);

	printf("BBX  %d  %d  %d   %d\n",
		cpe_font_struct.dfCharTable[ic].charWidth, l_hgt, 0, 0);

	printf("BITMAP\n");
	for(rowidx=0; rowidx < l_hgt; rowidx++) {
	    switch(l_span) {
		case(0):	// 1-7 pixels wide font
		    {
		    printf("%02X\n", (int) file_buffer[l_idx+rowidx]);
		    break;
		    }
		
		case(1):	// 8-15 pixels wide font
		    {
		    printf("%02X%02X", 
			(int) file_buffer[l_idx+rowidx], file_buffer[l_idx+l_hgt+rowidx]);
		    printf("\n");
		    break;
		    }

		case(2):	// 16-23 pixels wide font
		    {
		    printf("%02X%02X%02X", 
			file_buffer[l_idx+rowidx],
		        file_buffer[l_idx+l_hgt+rowidx],
		        file_buffer[l_idx+(2*l_hgt)+rowidx]);
		    printf("\n");
		    break;
		    }

		case(3):	// 24-31 pixels wide font
		    {
		    printf("%02X%02X%02X%02X", 
			file_buffer[l_idx+rowidx],
			file_buffer[l_idx+l_hgt+rowidx],
			file_buffer[l_idx+(2*l_hgt)+rowidx],
			file_buffer[l_idx+(3*l_hgt)+rowidx]);
		    printf("\n");
		    break;
		    }

		default:
		    printf("Character  is TOO WIDE!\n");
		    break;
		}
	    }
	printf("ENDCHAR\n");

	l_fchar++;	// Go to next one
	}
printf("ENDFONT\n");
}


int
CPE_FONT::return_data_value(enum data_types dtype, unsigned char * pChr)
{
int   ret_val = 0;

    switch(dtype) {
	case (dfChar): {
	    ret_val = (int) pChr[0];
	    break;
	    }
	case(dfShort): {
	    ret_val = 0;
	    ret_val = pChr[0];
	    ret_val += (pChr[1] << 8);	   // ms byte
	    break;
	    }
	case(dfLong): {
	    int  i;
	    ret_val = 0;

	    for(i=3; i >= 0; i--)  {
		ret_val += pChr[i] << (8*i);
		}
	    break;
	    }
	}  /* End CASE */

    return ret_val;
}



char *
CPE_FONT::dotdash(char iChr)
{
    static char   sBuf[128];
    unsigned char lmask = (unsigned char) 0x01;
    int i, j;

    sBuf[8] = '\0';	// null-terminate

    for(i=7; i >= 0; i--) {
	sBuf[i] =  (iChr & lmask) ? '*' : '.';
	lmask <<= 1;
	}

    return sBuf;
}



void
CPE_FONT::make_bdf_filename(char   *lP)
{
void  usage(void);
char  l_tmp[256],
     *l_index;

    if(strlen(cpe_filename) == 0)
	usage();

    strcpy(l_tmp, cpe_filename);	// start building the file name
    l_index = index(l_tmp, '.');

    if( l_index != (char *) 0)
	strcpy(l_tmp, ".bdf");	// append new extension
    else
	strncat(l_tmp, ".bdf", 4);    // append to end of filename

    strcpy(lP, l_tmp);
}




void
CPE_FONT::dump_bdf_hdr(void)
{
int     l_fchar = return_data_value(dfChar, cpe_font_struct.hdr.dfFirstChar), //  dfFirstChar; 
        l_lchar = return_data_value(dfChar, cpe_font_struct.hdr.dfLastChar);  //  dfLastChar; 
int     l_len = l_lchar-l_fchar;

    printf("STARTFONT   2.1\n");

    printf("FONT XXX\n");
    printf("SIZE  %d  %d   %d\n",  
	return_data_value(dfShort, cpe_font_struct.hdr.dfPixHeight),
	return_data_value(dfShort, cpe_font_struct.hdr.dfHorizRes),
	return_data_value(dfShort, cpe_font_struct.hdr.dfVertRes));    	    //  dfVertRes[2]

    printf("FONTBOUNDINGBOX %d  %d  %d  %d\n",
	return_data_value(dfShort, cpe_font_struct.hdr.dfMaxWidth),
        return_data_value(dfChar, cpe_font_struct.hdr.dfPixHeight),
   	0, 0);

    printf("STARTPROPERTIES  1\n");

    printf("FONT_ASCENT %d\n",  
	return_data_value(dfShort, cpe_font_struct.hdr.dfAscent));    	    //  dfAscent[2];

    printf("ENDPROPERTIES\n");

    printf("CHARS  %d\n",  l_len);
    return;
}
