//
// PROGRAM FILE:  fnt2bdf.c
//
// PURPOSE:  This program "rips" a .fnt file into it's 
//           individual constituent fields, and then:
//		a.  Either displays the contents
//		b.  converts the .fnt file into a
//		    .bdf file
//
// PROGRAMMER: Kevin Carothers
//
// PLACE:      Transaction Technology, Inc.
//
 

extern "C" {
#include <stdio.h>
}
#include <stream.h>
#include <sys/param.h>
#include <sys/types.h>

#include "fnt2bdf.hh"


main(int argc, char **argv)
{
    void usage();

    if(argc < 2)
	usage();

    CPE_FONT    cpe_font(argv[1]);	// rip it up

    // cpe_font.dump_font_hdr();
    // cpe_font.dump_font_bitmaps();

    cpe_font.dump_bdf();

}

void
usage()
{
    printf("Usage:   fnt2bdf <windows 3.x .font file>\n");
    exit(-1);
}
