/*****************************************************************************
 VGL.H

 Include this header file in any modules that use VGL routines.  Although
 all VGL routines are prototyped here, you don't *have* to link in all the
 VGL source files.  For example, the VGLKEY.C module will work even without
 *any* other VGL modules linked.  VGLGIF.C doesn't require anything else
 either.  VGLFONTS.C calls routines in VGL386.ASM and VGLLINE.C so if you
 use fonts you'll have to link in these two modules as well.  Anyway, you'll
 sort it all out.

 Mark
 morley@camosun.bc.ca
*****************************************************************************/

#define VGL_NUMKEYS    12                /* Set this to the number of keys   */
										/* you wish to trap in the keyboard */
										/* handling routines                */

extern char vglKeyStatus[VGL_NUMKEYS];  /* You can test if a given key is   */
										/* being held down by testing if    */
										/* its corresponding byte in this   */
										/* array is 1 or 0 (1==down)        */

#define VGL_UPARROW        { 72, 200 }  /* Don't change any of these values */
#define VGL_DOWNARROW      { 80, 208 }  /* unless they are different for    */
#define VGL_LEFTARROW      { 75, 203 }  /* your particular keyboard (this   */
#define VGL_RIGHTARROW     { 77, 205 }  /* is unlikely, I think).           */
#define VGL_HOME           { 71, 199 }  /* The first number is the scan     */
#define VGL_END            { 79, 207 }  /* code that is generated when the  */
#define VGL_PAGEUP         { 73, 201 }  /* key is pressed, the second is    */
#define VGL_PAGEDOWN       { 81, 209 }  /* the scan code generated when it  */
#define VGL_KEYPAD5        { 76, 204 }  /* is released.                     */
#define VGL_CONTROL        { 29, 157 }  /* Insert these values into the     */
#define VGL_ALT            { 56, 184 }  /* list in the VGLKEY.C module as   */
#define VGL_LEFTSHIFT      { 42, 170 }  /* required for your application.   */
#define VGL_RIGHTSHIFT     { 54, 182 }
#define VGL_DELETE		   { 83, 170 }
#define VGL_W			   { 17, 145 }
#define VGL_X			   { 45, 173 }
#define VGL_A			   { 30, 158 }
#define VGL_D			   { 32, 160 }
#define VGL_G			   { 34, 162 }
#define VGL_H			   { 35, 163 }
#define VGL_PLUS		   { 78, 206 }
#define VGL_MINUS		   { 74, 202 }


#define VIDMEM ((char far*)0xa0000000L) /* Handy for loading a GIF directly */
										/* into video memory.               */

typedef struct                          /* Structure that defines a font.   */
{
   unsigned char first;                 /* First character in font          */
   unsigned char last;                  /* Last character in font           */
   unsigned char flags;                 /* Special flags (see below)        */
   unsigned char wswid;                 /* White space width in pixels      */
   unsigned char vspace;                /* Space between rows in pixels     */
   unsigned char hspace;                /* Space between adjacent chars     */
   unsigned char chwid[256];            /* Width of each character          */
   unsigned char chhit[256];            /* Height of each character         */
   signed   char chbas[256];            /* Baseline of each character       */
   unsigned int  choff[256];            /* Offset of bitmap for each char   */
   unsigned int  data;                  /* Size of the bitmap data in bytes */
} VGLFONT;

#define FONT_UPPERCASE         1        /* One and only font flag (so far)  */
                                        /* If set for a font, it means that */
                                        /* lowercase characters will be     */
                                        /* converted to uppercase before    */
                                        /* processing.  DIGITAL is an       */
                                        /* example of such a font.          */
                                        /* Other possible values are        */
                                        /* reserved!!!                      */

vglInit();
vglTerm();
vglVSync();
vglBuffer( char far* buffer );
vglClear( int c );
vglClearL( int lines, int c );
vglUpdate();
vglUpdateW();
vglUpdateL( int lines );
vglUpdateLW( int lines );
vglBox( int x, int y, int width, int height, int c );
vglHLine( int y, int x, int width, int c );
vglCopy( int x, int y, int width, int height );
vglCopyW( int x, int y, int width, int height );
vglPut( int x, int y, int width, int height, char far* buffer );
vglPutSprite( int x, int y, int width, int height, char far* buffer );
vglPutPel( int x, int y, int c );
vglGetPel( int x, int y );
void putpel(int x, int y, int c);
vglSetPal( char far* palette );
vglSetPartPal( int first, int num, char far* palette );
vglBlack();
vglFadeIn( char far* palette );
vglFadeOut( char far* palette );
vglPartFadeIn( int first, int num, char far* palette );
vglPartFadeOut( int first, int num, char far* palette );
vglPartCycleL( int first, int num, char far* palette );
vglPartCycleR( int first, int num, char far* palette );
vglLine( int x1, int y1, int x2, int y2, int c );
vglGif( char* file, char far* buffer, char far* pal, int* width, int* height );
vglBoldOff();
vglBoldOn();
vglGetX();
vglGetY();
vglGotoXY( int x, int y );
vglItalicsOn();
vglItalicsOff();
vglLoadFont( char* font );
vglPutc( int c );
vglPuts( char* s );
vglPutcf( int c );
vglPutsf( char* s );
vglShadowColor( int c );
vglShadowOff();
vglShadowOn( int s );
vglTextColor( int c );
vglUnderlineColor( int c );
vglUnderlineOn( int n );
vglUnderlineOff();
vglTrapKeys();
vglReleaseKeys();
vglMousePresent();
vglInitMouse();
vglShowMouse();
vglHideMouse();
void LimitMouse( int x1, int y1, int x2, int y2 );
HideMouseIf( int x1, int y1, int x2, int y2 );
vglGetMouseStatus( int* x, int* y, int* b );
vglPlayFLI( char* file, char far* buffer, int speed );
setfontfast(int s);