/*----------------------------------------------------------------------*/
/* Copyright (c) 1988-1989						*/
/* by CompuServe Inc., Tucson, AZ.  All Rights Reserved			*/
/* CNVHUF.H can be copied and distributed freely for any		*/
/* non-commercial purposes. CNVHUF.H can only be incorporated		*/
/* into commercial software with the permission of CompuServe Inc.	*/
/*----------------------------------------------------------------------*/

/* Header file CNVHUF.H */

/* Global type definitions for Group 3 FAX work and TIF files */

#define WHITE		(0)
#define BLACK		(1)
#define LONGEST_LINE	(2432)	/* Longest line we expect */
#define LONGEST_RLE	(1266)	/* Most run lengths for longest_line */
#define	FAX_line_width	(1728)	/* Longest line expected from FAX */
#define FAX_page_length	(4000)
#define FAX_min_line	(24)	/* Minimum bits per line (20m sec rule) */

typedef	int
    colors;			/* The two modes are these */

/* Structures in a TIF file as used by GAMMAfax */

typedef struct
    ifd_tag_record		/* Format of tag field(s) */
	{
    	int
    	    IFD_tag,		/* TIF tag describing rest of element */
    	    IFD_type;		/* Type of data referred to by IFD_tag */
	long int
    	    IFD_length;		/* Length of data referred to */
	union
	    {
	    short int
		short_pair[2];	/* 4 bytes are used for either 2 shorts */
	    long int
		long_one;	/* Or one long value */
	    long int
		offset;		/* Or pointer to later in the file */
	    } params;
	} IFD_tag_body;

typedef struct
    ifd_header_record		/* Format of Image File Directory */
	{
	short int
	    IFD_ele_cnt;
	IFD_tag_body
	    IFD_tag_element[20];	/* IFD_ele_cnt number of these */
	char
	    IFD_ptr_params[100];	/* Room for params after directory */
	} IFD_header;

typedef struct
    tif_file_header_record	/* Format of TIF header */
	{
	char
	    TIF_sign[4];	/* Signature */
	long int
	    IFD_offset;		/* Offset to first IFD */
	} TIF_header;

/* Standard TAG_tag's (TT's) and contents: */

/* The following their data in line: */

#define	TT_width	(256)	/* Image width follows */
#define	TT_width_type	(3)	/* uses short integers */
#define	TT_width_cnt	(1L)	/* uses only one parameter */

#define	TT_length	(257)	/* Image length */
#define	TT_length_type	(3)	/* uses short integers */
#define	TT_length_cnt	(1L)	/* uses only one parameter */

#define	TT_PixBits	(258)	/* Bits per pixel */
#define	TT_PixBits_type	(3)	/* uses short integers */
#define	TT_PixBits_cnt	(1L)	/* uses only one parameter */
#define	TT_PixBits_par	(1)	/* Standard value for B/W */

#define	TT_Cmprs	(259)	/* Compression method */
#define	TT_Cmprs_type	(3)	/* uses short integers */
#define	TT_Cmprs_cnt	(1L)	/* uses only one parameter */
#define	TT_Cmprs_par	(3)	/* Standard value for Group3 */

#define	TT_Revrs	(262)	/* Color reversal */
#define	TT_Revrs_type	(3)	/* uses short integers */
#define	TT_Revrs_cnt	(1L)	/* uses only one parameter */
#define	TT_Revrs_par	(0)	/* Standard value for black on white */

#define	TT_MSBend	(266)	/* True if MSB is last */
#define	TT_MSBend_type	(3)	/* uses short integers */
#define	TT_MSBend_cnt	(1L)	/* uses only one parameter */
#define	TT_MSBend_par	(1)	/* Standard value for FAX */

#define	TT_Orient	(274)	/* True if top left is (0,0) */
#define	TT_Orient_type	(3)	/* uses short integers */
#define	TT_Orient_cnt	(1L)	/* uses only one parameter */
#define	TT_Orient_par	(1)	/* Standard value for FAX */

#define	TT_Samps	(277)	/* Number of samples per pixel */
#define	TT_Samps_type	(3)	/* uses short integers */
#define	TT_Samps_cnt	(1L)	/* uses only one parameter */
#define	TT_Samps_par	(1)	/* Standard value for FAX */

#define	TT_Grp3Opt	(292)	/* Encoding scheme within group III */
#define	TT_Grp3Opt_type	(4)	/* Uses long integers */
#define	TT_Grp3Opt_cnt	(1L)	/* uses only one parameter */
#define	TT_Grp3Opt_par	(0)	/* Standard value for Huffman */

#define	TT_Resol	(296)	/* Resolution unit (none, inch, cm ) */
#define	TT_Resol_type	(3)	/* uses short integers */
#define	TT_Resol_cnt	(1L)	/* uses only one parameter */
#define	TT_Resol_par	(2)	/* Standard value for FAX density */

#define	TT_PagNum	(297)	/* This page, Total pages */
#define	TT_PagNum_type	(3)	/* uses short integers */
#define	TT_PagNum_cnt	(2L)	/* uses two parameters */
#define	TT_PagNum_par1	(1)	/* Standard values for first page */
#define	TT_PagNum_par2	(1)	/*                     of only one page */

/* The following use pointers to their data: */
/*	The pointers are integer byte numbers that the data starts
	on in the file */

#define	TT_Title	(270)	/* Title generated by FAX */
#define	TT_Title_type	(2)	/* Uses text */

#define	TT_Image	(273)	/* Image generated by FAX */
#define	TT_Image_type	(3)	/* Integers */

#define	TT_X_dense	(282)	/* X_dense generated by FAX */
#define TT_X_dense_cnt	(1L)	/* Only one parameter */
#define	TT_X_dense_type	(5)	/* Rational fraction */
#define	TT_X_dense_par1	(204)	/* 204 dots per */
#define	TT_X_dense_par2	(1)	/*        1 inch */

#define	TT_Y_dense	(283)	/* Y_dense generated by FAX */
#define TT_Y_dense_cnt	(1L)	/* Only one parameter */
#define	TT_Y_dense_type	(5)	/* Rational fraction */
#define	TT_Y_dense_par1	(196)	/* 196 dots per */
#define	TT_Y_dense_par2	(1)	/*              1 inch */

/* Other fields: */

#define	TIF_sign_par	"II*\000"	/* Text at beginning of TIF file */
#define	TIF_msc_1	((8,0))		/* Additional data there */

typedef	int
    INTER_ARR1[LONGEST_RLE];		/* Highest number of runs in a line */

typedef	struct
    rle_line_record
	{
	int
	    line_length,	/* Total pixels on line */
	    rle_count,		/* Total run-lengths here */
	    rle_pointer;	/* Current entry in rle_list */
	colors
	    rle_color;		/* Color of current run */
	int
	    rle_start_column,	/* Starting column of rle_pointer */
	    current_column;	/* Current pixel position */
	INTER_ARR1
	    rle_list;
	} rle_line;

typedef	int
    node_label;		/* Used for last 4 bits of code */

typedef struct
    huffman_node_record {	/* There is one record per 8 bit possibility */
	unsigned char	bits_consumed;	/* Significant bits in this entry */
	int		run_length;	/* (if over 8 insert 0 here */
	} huffman_node;

typedef huffman_node
	table_1st_bits[256][2],
	table_end_bits[16];

typedef struct
    huffman_code_record {	/* There is one record for each array entry */
	unsigned char
	   code_bits;		/* Length of following code */
	short int
	   code_value;		/* The code itself */
	} huffman_code;

typedef char
    file_name_string[(20)+1];

/* Declare globals */

extern int
	scan_lines;
