/*----------------------------------------------------------------------*/
/* Copyright (c) 1988-1989						*/
/* by CompuServe Inc., Tucson, AZ.  All Rights Reserved			*/
/* DEHUFTAB.H can be copied and distributed freely for any		*/
/* non-commercial purposes. DEHUFTAB.H can only be incorporated		*/
/* into commercial software with the permission of CompuServe Inc.	*/
/*----------------------------------------------------------------------*/

/* DEHUFTAB.H */

/* This header file contains the 5 standard Group III FAX Encoding tables */

huffman_code			/* White "make-up" codes                 */
    huf_wht_makeup[ 27 ] =	/*  based at 64, steps of 64, up to 1728 */
	{
	    { 5, 0033 },	/*   64 */
	    { 5, 0022 },	/*  128 */
	    { 6, 0027 },	/*  192 */
	    { 7, 0067 },	/*  256 */
	    { 8, 0066 },	/*  320 */
	    { 8, 0067 },	/*  384 */
	    { 8, 0144 },	/*  448 */
	    { 8, 0145 },	/*  512 */
	    { 8, 0150 },	/*  576 */
	    { 8, 0147 },	/*  640 */
	    { 9, 0314 },	/*  704 */
	    { 9, 0315 },	/*  768 */
	    { 9, 0322 },	/*  832 */
	    { 9, 0323 },	/*  896 */
	    { 9, 0324 },	/*  960 */
	    { 9, 0325 },	/* 1024 */
	    { 9, 0326 },	/* 1088 */
	    { 9, 0327 },	/* 1152 */
	    { 9, 0330 },	/* 1216 */
	    { 9, 0331 },	/* 1280 */
	    { 9, 0332 },	/* 1344 */
	    { 9, 0333 },	/* 1408 */
	    { 9, 0230 },	/* 1472 */
	    { 9, 0231 },	/* 1536 */
	    { 9, 0232 },	/* 1600 */
	    { 6, 0030 },	/* 1664 */
	    { 9, 0233 }		/* 1728 */
	};

huffman_code			/* Black "make-up" codes                 */
    huf_blk_makeup[ 27 ] =	/*  based at 64, steps of 64, up to 1728 */
	{
	    {10, 0017 },	/*   64 */
	    {12, 0310 },	/*  128 */
	    {12, 0311 },	/*  192 */
	    {12, 0133 },	/*  256 */
	    {12, 0063 },	/*  320 */
	    {12, 0064 },	/*  384 */
	    {12, 0065 },	/*  448 */
	    {13, 0154 },	/*  512 */
	    {13, 0155 },	/*  576 */
	    {13, 0112 },	/*  640 */
	    {13, 0113 },	/*  704 */
	    {13, 0114 },	/*  768 */
	    {13, 0115 },	/*  832 */
	    {13, 0162 },	/*  896 */
	    {13, 0163 },	/*  960 */
	    {13, 0164 },	/* 1024 */
	    {13, 0165 },	/* 1088 */
	    {13, 0166 },	/* 1152 */
	    {13, 0167 },	/* 1216 */
	    {13, 0122 },	/* 1280 */
	    {13, 0123 },	/* 1344 */
	    {13, 0124 },	/* 1408 */
	    {13, 0125 },	/* 1472 */
	    {13, 0132 },	/* 1536 */
	    {13, 0133 },	/* 1600 */
	    {13, 0144 },	/* 1664 */
	    {13, 0145 }		/* 1728 */
	};

huffman_code			/* White "termination" codes         */
    huf_wht_final[ 64 ] =	/*  based at 0, steps of 1, up to 63 */
	{
	    { 8, 0065 },	/*    0 */
	    { 6, 0007 },	/*    1 */
	    { 4, 0007 },	/*    2 */
	    { 4, 0010 },	/*    3 */
	    { 4, 0013 },	/*    4 */
	    { 4, 0014 },	/*    5 */
	    { 4, 0016 },	/*    6 */
	    { 4, 0017 },	/*    7 */
	    { 5, 0023 },	/*    8 */
	    { 5, 0024 },	/*    9 */
	    { 5, 0007 },	/*   10 */
	    { 5, 0010 },	/*   11 */
	    { 6, 0010 },	/*   12 */
	    { 6, 0003 },	/*   13 */
	    { 6, 0064 },	/*   14 */
	    { 6, 0065 },	/*   15 */
	    { 6, 0052 },	/*   16 */
	    { 6, 0053 },	/*   17 */
	    { 7, 0047 },	/*   18 */
	    { 7, 0014 },	/*   19 */
	    { 7, 0010 },	/*   20 */
	    { 7, 0027 },	/*   21 */
	    { 7, 0003 },	/*   22 */
	    { 7, 0004 },	/*   23 */
	    { 7, 0050 },	/*   24 */
	    { 7, 0053 },	/*   25 */
	    { 7, 0023 },	/*   26 */
	    { 7, 0044 },	/*   27 */
	    { 7, 0030 },	/*   28 */
	    { 8, 0002 },	/*   29 */
	    { 8, 0003 },	/*   30 */
	    { 8, 0032 },	/*   31 */
	    { 8, 0033 },	/*   32 */
	    { 8, 0022 },	/*   33 */
	    { 8, 0023 },	/*   34 */
	    { 8, 0024 },	/*   35 */
	    { 8, 0025 },	/*   36 */
	    { 8, 0026 },	/*   37 */
	    { 8, 0027 },	/*   38 */
	    { 8, 0050 },	/*   39 */
	    { 8, 0051 },	/*   40 */
	    { 8, 0052 },	/*   41 */
	    { 8, 0053 },	/*   42 */
	    { 8, 0054 },	/*   43 */
	    { 8, 0055 },	/*   44 */
	    { 8, 0004 },	/*   45 */
	    { 8, 0005 },	/*   46 */
	    { 8, 0012 },	/*   47 */
	    { 8, 0013 },	/*   48 */
	    { 8, 0122 },	/*   49 */
	    { 8, 0123 },	/*   50 */
	    { 8, 0124 },	/*   51 */
	    { 8, 0125 },	/*   52 */
	    { 8, 0044 },	/*   53 */
	    { 8, 0045 },	/*   54 */
	    { 8, 0130 },	/*   55 */
	    { 8, 0131 },	/*   56 */
	    { 8, 0132 },	/*   57 */
	    { 8, 0133 },	/*   58 */
	    { 8, 0112 },	/*   59 */
	    { 8, 0113 },	/*   60 */
	    { 8, 0062 },	/*   61 */
	    { 8, 0063 },	/*   62 */
	    { 8, 0064 }		/*   63 */
	};

huffman_code			/* Black "termination" codes         */
    huf_blk_final[ 64 ] =	/*  based at 0, steps of 1, up to 63 */
	{
	    {10, 0067 },	/*    0 */
	    { 3, 0002 },	/*    1 */
	    { 2, 0003 },	/*    2 */
	    { 2, 0002 },	/*    3 */
	    { 3, 0003 },	/*    4 */
	    { 4, 0003 },	/*    5 */
	    { 4, 0002 },	/*    6 */
	    { 5, 0003 },	/*    7 */
	    { 6, 0005 },	/*    8 */
	    { 6, 0004 },	/*    9 */
	    { 7, 0004 },	/*   10 */
	    { 7, 0005 },	/*   11 */
	    { 7, 0007 },	/*   12 */
	    { 8, 0004 },	/*   13 */
	    { 8, 0007 },	/*   14 */
	    { 9, 0030 },	/*   15 */
	    {10, 0027 },	/*   16 */
	    {10, 0030 },	/*   17 */
	    {10, 0010 },	/*   18 */
	    {11, 0147 },	/*   19 */
	    {11, 0150 },	/*   20 */
	    {11, 0154 },	/*   21 */
	    {11, 0067 },	/*   22 */
	    {11, 0050 },	/*   23 */
	    {11, 0027 },	/*   24 */
	    {11, 0030 },	/*   25 */
	    {12, 0312 },	/*   26 */
	    {12, 0313 },	/*   27 */
	    {12, 0314 },	/*   28 */
	    {12, 0315 },	/*   29 */
	    {12, 0150 },	/*   30 */
	    {12, 0151 },	/*   31 */
	    {12, 0152 },	/*   32 */
	    {12, 0153 },	/*   33 */
	    {12, 0322 },	/*   34 */
	    {12, 0323 },	/*   35 */
	    {12, 0324 },	/*   36 */
	    {12, 0325 },	/*   37 */
	    {12, 0326 },	/*   38 */
	    {12, 0327 },	/*   39 */
	    {12, 0154 },	/*   40 */
	    {12, 0155 },	/*   41 */
	    {12, 0332 },	/*   42 */
	    {12, 0333 },	/*   43 */
	    {12, 0124 },	/*   44 */
	    {12, 0125 },	/*   45 */
	    {12, 0126 },	/*   46 */
	    {12, 0127 },	/*   47 */
	    {12, 0144 },	/*   48 */
	    {12, 0145 },	/*   49 */
	    {12, 0122 },	/*   50 */
	    {12, 0123 },	/*   51 */
	    {12, 0044 },	/*   52 */
	    {12, 0067 },	/*   53 */
	    {12, 0070 },	/*   54 */
	    {12, 0047 },	/*   55 */
	    {12, 0050 },	/*   56 */
	    {12, 0130 },	/*   57 */
	    {12, 0131 },	/*   58 */
	    {12, 0053 },	/*   59 */
	    {12, 0054 },	/*   60 */
	    {12, 0132 },	/*   61 */
	    {12, 0146 },	/*   62 */
	    {12, 0147 }		/*   63 */
	};


huffman_code			/* Large "makeup" codes                    */
    huf_big_makeup[ 13 ] =	/*  based at 1792, steps of 64, up to 2560 */
	{
	    {12, 0010 },	/* 1792 */
	    {12, 0014 },	/* 1856 */
	    {12, 0015 },	/* 1920 */
	    {13, 0022 },	/* 1984 */
	    {13, 0023 },	/* 2048 */
	    {13, 0024 },	/* 2112 */
	    {13, 0025 },	/* 2176 */
	    {13, 0026 },	/* 2240 */
	    {13, 0027 },	/* 2304 */
	    {13, 0034 },	/* 2368 */
	    {13, 0035 },	/* 2432 */
	    {13, 0036 },	/* 2496 */
	    {13, 0037 }		/* 2560 */
	};
