#
# MODULE: GIFTIF.MAK
#
# AUTHOR: Doug Chinnock
#
# FACILITY:
#	MAKE file for building GIFTIF.EXE
#
# PRODUCT: GIFTIF.EXE
#
# REVISIONS:
#
# <001>	24-Sep-88	D. Chinnock	Original
#

#
# Establish default settings
#

list =
model = L
opt = /Oilt /W3 /Zi
switches = /c $(list) /A$(model) $(opt)
lnkopt = /CO

.c.obj:
	cl $(switches) $*.c

# GIFTIF components:

giftif.obj : giftif.c gifbase.h gifreade.h cnvhuf.h rletif.h readgif.h \
		writetif.h expander.h

readgif.obj : readgif.c readgif.h

gifreade.obj : gifreade.c gifreade.h

expander.obj : expander.c expander.h

writetif.obj : writetif.c writetif.h cnvhuf.h

rletif.obj : rletif.c rletif.h dehuftab.h cnvhuf.h writetif.h

gifbase.obj : gifbase.c gifbase.h

# Final EXE

giftif.exe : giftif.obj readgif.obj \
	gifbase.obj gifreade.obj expander.obj writetif.obj rletif.obj
    link $(lnkopt) giftif.obj+readgif.obj+gifbase.obj+gifreade.obj+ \
	expander.obj+writetif.obj+rletif.obj, \
	giftif.exe, giftif.map, ,
