/* HSI2ARR.C -- Coded by Darion.  August 16th, 1994
 * Converts IMAGE ALCHEMY'S HSI RAW format + palette to C arrays
 * And defines.  Coded by Darion (thimj@u.washington.edu) 8-16-94
 * Any Questions?  email me..                                     */

#include <stdio.h>      /* the standards */
#include <dos.h>
#include <stdlib.h>


void help(int);        /* prototyping is wonderful :) */
int getWord(FILE *stream);

/* this header was taken right out of the back of the manual */

typedef struct {
    char magicnum[6];           /* magic numbers for verifying file */
    int version;                /* current version of format.. Currently 4 */
    int width;                  /* width of picture */
    int height;                 /* height of picture */
    int palsize;                /* number of colors */
    int hordpi;                 /* horizontal dots per inch */
    int verdpi;                 /* vertical dots per inch */
    int gamma;                  /* gamma factor */
    char reserved[12];          /* reserved for future use */
	} HSIRAW;

HSIRAW rawhdr;                  /* creates one (1) structure of type HSIRAW */
unsigned char *paldata;         /* unsigned char pointer to be filled in later */
unsigned char *picdata;         /* buffer for holding picture data */

void main(int argc, char *argv[])
{

    FILE *fp, *fp1;             /* File pointers for infile and outfile respectively */
    int x, temp, temp1=0,z;
    int value,blah;			/* generic variables */

    if(argc < 2) help(1);        /* if they think they have a interface, yell at em */

	if ((fp = fopen(argv[1], "rb"))== NULL) /* open .RAW file for read+binary */
		{
		fprintf(stderr, "Cannot open input file.\n"); /* catch any errors */
		help(2);
		}
	fread(rawhdr.magicnum, 6 , 1, fp);  /* read in the first 6 bytes, the 'magicnumbers' */
	rawhdr.version = getWord(fp);	    /* read in the rest of the header */
	rawhdr.width = getWord(fp);	    /* must use special function to get int's */
	rawhdr.height = getWord(fp);        /* function pulled from back of Image Alchemy manual */
	rawhdr.palsize = getWord(fp);	    /* it reads any int on any OS the same */
	rawhdr.hordpi = getWord(fp);
	rawhdr.verdpi = getWord(fp);
	rawhdr.gamma = getWord(fp);
	fread(rawhdr.reserved, 12, 1, fp);

/* this code below validates file, checking the magicnumbers */

	if(rawhdr.magicnum[0] != 0x6d || rawhdr.magicnum[1] != 0x68 ||
	   rawhdr.magicnum[2] != 0x77 || rawhdr.magicnum[3] != 0x61 ||
	   rawhdr.magicnum[4] != 0x6e || rawhdr.magicnum[5] != 0x68)
		{
		fprintf(stderr, "Invalid HSI-RAW file.\n");
		help(3);
		}
/* allocate space for the palette...  the size of the space allocated must be
 * equal to THREE times the amount of colors in the picture.  This is because
 * three BYTE sized values make up ONE palette entry */

	paldata = (char *)malloc(rawhdr.palsize*3);

/* read in the palette, it is the LAST thing after the header.  So
 * you have a 32 byte header, then the palette, then image data.  */

	fread(paldata, rawhdr.palsize * 3, 1, fp);
/* shifts all the palette values right two bits, so they conform with
 * they can be used properly.  0-63 are valid values, not 63-255.  Shifting
 * rid of the upper two bits */

    for(x = 0;x < rawhdr.palsize * 3;x++)
		paldata[x] = paldata[x] >> 2;

/* allocate space for the picture buffer.  I just used the width of the
 * picture for the size */

	picdata = (char *)malloc(rawhdr.width);

/* debug info.. if you want to 'mess' with the code a little bit, I hope this
 * can help		*/

#ifdef DEBUG
	printf("Palsize: %d\n", rawhdr.palsize);
	printf("Allocated: %d\n", rawhdr.palsize * 3);
	printf("Version: %d\n", rawhdr.version);
	printf("Width: %d\n", rawhdr.width);
	printf("Height: %d\n", rawhdr.height);
	printf("Hordpi: %d\n", rawhdr.hordpi);
	printf("Verdpi: %d\n", rawhdr.verdpi);
	printf("Gamma: %d\n", rawhdr.gamma);
#endif

#ifdef DEBUG
	for(temp=0;temp < rawhdr.palsize * 3;temp +=3)
		printf("Pal Data: %d %d %d\n", paldata[temp], paldata[temp+1], paldata[temp+2]);
#endif

/* check for and open output file */
	if ((fp1 = fopen(argv[2], "wb"))== NULL)
		{
		fprintf(stderr, "Cannot open output file.\n");
		help(4);
		}

/* begin to output to file, you can customize your own output files here */
/* fprintf is easy, prints formatted text into a stream, in this case a file */

	fprintf(fp1,"#define PICDATA_COLORS %d\n", rawhdr.palsize);
	fprintf(fp1,"#define PICDATA_HORDPI %d\n", rawhdr.hordpi);
	fprintf(fp1,"#define PICDATA_VERDPI %d\n", rawhdr.verdpi);
	fprintf(fp1,"#define PICDATA_GAMMA %d\n", rawhdr.gamma);
	fprintf(fp1,"#define PICDATA_WIDTH %d\n", rawhdr.width);
	fprintf(fp1,"#define PICDATA_HEIGHT %d\n", rawhdr.height);
	fprintf(fp1,"unsigned char PALDATA[%d] = {\n",rawhdr.palsize * 3);
/* set up the loop in which we will print out our palette data */
/* I just loop from 0 to 765 right here, leaving 3 so I can terminate the */
/* array properly */

	temp = 0;
	for(temp=0;temp < ((rawhdr.palsize * 3)-3);temp += 15)
		{
		fprintf(fp1, "%d,%d,%d, ", paldata[temp], paldata[temp+1], paldata[temp+2]);
		fprintf(fp1, "%d,%d,%d, ", paldata[temp+3], paldata[temp+4], paldata[temp+5]);
		fprintf(fp1, "%d,%d,%d, ", paldata[temp+6], paldata[temp+7], paldata[temp+8]);
		fprintf(fp1, "%d,%d,%d, ", paldata[temp+9], paldata[temp+10], paldata[temp+11]);
		fprintf(fp1, "%d,%d,%d,\n", paldata[temp+12], paldata[temp+13], paldata[temp+14]);
		}
/* terminate the array properly */

	fprintf(fp1, "%d,%d,%d };\n\n", paldata[temp], paldata[temp+1], paldata[temp+2]);
/* start with the picture data */

	fprintf(fp1,"char PICDATA[%d][%d] = {\n",rawhdr.height, rawhdr.width);
	printf("\n\nConverting... ");
/* Basically same process.  I pulled a few tricks to make sure that the lines
 * didnt get OUTRAGEOUSLY long.  Kinda sloppy, but it gets the job done!
 * I loop HEIGHT times.  I read in ONE line of the picture each time through
 * the loop.  I then loop again, disecting that line into the output file. I
 * only go height-1 so I can once again terminate my array properly */

	if(rawhdr.width < 20) value = rawhdr.width;
	else value = 30;
	for(temp = 0;temp < rawhdr.height-1; temp++)
		{
		fread(picdata, rawhdr.width, 1, fp);
		temp1=0;
		while(temp1 < rawhdr.width)
			{
			for(z = 0;z < value;z++)
				{
				if(temp1 == rawhdr.width) break;
				fprintf(fp1, "%d,", picdata[temp1++]);
				}
			fprintf(fp1, "\n");
			}
		}
/* here is where I terminate the array, I just read in the last line and
 * disect it until I have one left, then I print the last one with the closing
 * bracket */

	fread(picdata, rawhdr.width, 1, fp);
	temp1 = 0;
	while(temp1 < (rawhdr.width-1))
			{
			for(z = 0;z < value;z++)
				{
				if(temp1 == (rawhdr.width-1)) break;
				fprintf(fp1, "%d,", picdata[temp1++]);
				}
			fprintf(fp1, "\n");
			}
	fprintf(fp1, "%d };",picdata[temp1]);
}

void help(int errorlevel)
{
	printf("\n");
	printf("HSI2ARR -- Converts HSI Raw format to C Array\n");
	printf("     By Darion (thimj@u.washington.edu)\n");
	printf("\n");
	printf("Usage: hsi2arr <input file> <output file>\n");
	printf("Example: hsi2arr eddings.raw eddings.h\n");

	exit(errorlevel);
}

/* here is that routine I mentioned above, pulls an integer out of a stream
 * regardless of the HIGH or LOW position of the bytes, I guess some OS's
 * differ in the way that they arrange the bytes of their integers */

int getWord(FILE *stream)
{
	register int temp;
	temp=getc(stream) << 8;
	return(getc(stream) | temp);
}
