From: rochester!pt.cs.cmu.edu!cadre!pitt!hoffman (Bob Hoffman)
Newsgroups: comp.sys.intel,misc.wanted,comp.misc,comp.sources.wanted
Subject: Re: Motorola S19 Format
Date: 23 Mar 89 16:53:13 GMT
Reply-To: hoffman@vax.cs.pittsburgh.edu (Bob Hoffman)

wfp5p@euclid.acc.Virginia.EDU (William F. Pemberton) writes:
>I am looking for a program to convert from Motorola S19 Hex format to Intel
>Hex format.

Here it is, enjoy!

	---Bob.

/*
 * Convert Motorola S1/S9 hex files to Intel hex.
 *
 * R. B. Hoffman, July 1985.
 *
 * usage:   hexcvt < motorola-file > intel-file
 */

#include <stdio.h>

char line[256];

main() {
	int bc, val, cksm, fcksm, i;
	long laddr;

	while (fgets(line, 256, stdin) != NULL) {
		if (line[0] != 'S')
			continue;
		if (line[1] == '9')
			break;
		if (line[1] != '1')
			continue;
		sscanf(&line[2],"%2x",&bc);
		sscanf(&line[4],"%4x",&laddr);
		printf(":%02X%04X00", bc-3, laddr);
		cksm = bc + (laddr & 0xFF) + ((laddr >> 8) & 0xFF);
		for (i=0; i<(bc-3); i++) {
			sscanf(&line[i*2 + 8], "%2x", &val);
			cksm += val;
			printf("%02X", val);
		}
		sscanf(&line[(bc-3)*2 + 8], "%2x", &fcksm);
		cksm = ~cksm & 0xFF;
		if (cksm != fcksm)
			fprintf(stderr,"cksm=%02x, fcksm=%02x\n", cksm, fcksm);
		printf("%02X\n", (cksm+4) & 0xFF);
	}
	printf(":0000000000\n");
}
-- 
Bob Hoffman, N3CVL       {allegra, bellcore, cadre, idis, psuvax1}!pitt!hoffman
Pitt Computer Science    hoffman@vax.cs.pittsburgh.edu
