#include <stdio.h>
#include <stdlib.h>

#define MAXLEN 70
#define NO_ERR 0
#define OUTFILE_ERR 1
#define INFILE_ERR 2
#define BUFFERGET_ERR 3

typedef struct PCX_HEADER {
  char manufacturer;
  char version;
  char encoding;
  char bits_per_pixel;
  int  xmin,ymin;
  int  xmax,ymax;
  int  hres;
  int  vres;
  char palette16[48];
  char reserved;
  char color_planes;
  int  bytes_per_line;
  int  palette_type;
  char filler[58];
} pcx_header;

struct IMG {
  char far *buffer;
  unsigned int xsize;
  unsigned int ysize;
} image;


char *ERROR[4]  = { { "No Errors"},
                    { "Could not create OUTPUT file."},
                    { "Could not open INPUT file."},
                    { "Could not ALLOCATE memory."} };

int MakeText(char *outname)
{

  FILE *outstream;
  char far *BufferPtr;
  unsigned int i, len, line_length;
  unsigned int dotcount=0, dotplot;

  BufferPtr = image.buffer;
  len = image.xsize * image.ysize;
  dotplot = len/30;
  outstream = fopen(outname,"w+t");
  if (outstream == (FILE *)NULL)
  {
    fprintf(stderr,"Can't open output file [ %s ]!\n", outname);
    return(1);
  }
  fprintf(outstream,"// FM Flat mode image file\n");
  fprintf(outstream,"// Original Save File: %s\n",outname);
  fprintf(outstream,"// Size =%u\n", image.xsize*image.ysize);
  fprintf(outstream,"// Xsize=%u, Ysize=%u\n", image.xsize, image.ysize);
  fprintf(outstream,"unsigned char far IMAGE[] = {\n");
  fprintf(outstream,"  "); line_length=2;
  printf("0%           50%          100%\n");
  printf("+----------------------------+\n");
  for(i = 0; i < len; i++, dotcount++)
  {
    if(dotcount == dotplot)
    {
      dotcount=0;
      printf("+");
    }
    fprintf(outstream,"0x%+0.2X,",BufferPtr[i]);
    line_length+=5;
    if(line_length > MAXLEN)
    {
      fprintf(outstream,"\n  ");
      line_length=2;
    }
  }
  printf("\ndone\n");
  fseek(outstream,-1,SEEK_END);
  fclose(outstream);
  return(0);
}

int loadpcx(char * filename)
{
  FILE *infile;
  char far * ImagePtr;
  unsigned int x, i=0;
  unsigned int Points;
  int c;
  pcx_header pcxhead;
  if ((infile=fopen(filename,"rb"))==NULL) return(2);
  fseek(infile,0L,SEEK_SET);
  fread(&pcxhead,sizeof(pcx_header),1,infile);
  image.xsize = (pcxhead.xmax-pcxhead.xmin) + 1;
  image.ysize = (pcxhead.ymax-pcxhead.ymin) + 1;
  Points = image.xsize * image.ysize;
  image.buffer = (char far *) malloc(Points);
  if(image.buffer==NULL) return(3);
  ImagePtr=image.buffer;
  for (i=0;i<Points;++i)
  {
    c=fgetc(infile) & 0xff;
    if((c & 0xc0) == 0xc0) 
    {
      x=c & 0x3f;
      c=fgetc(infile);
      while(x--)
      {
        *(ImagePtr++)=c;
        i++;
      }
      i--;
    }
    else
    {
      *(ImagePtr++)=c;
    }
  }
  fclose(infile);
  return(0);
}

void ExitFunction(void)
{
  if(image.buffer) free(image.buffer);
}

void DisplayError(int error)
{
  printf("ERROR: %s\n", ERROR[error]);
  exit(error);
}

void main(int argc, char *argv[])
{
  int error;
  atexit(ExitFunction);
  printf("\n\n\n");
  printf("PCX to TEXT file converter, By Mark C. Williston\n");
  printf("------------------------------------------------\n");
  printf("Converts 256 color PCX files to TEXT files which\n");
  printf("can be directly compiled in C programs.  Handles\n");
  printf("image files 64K or less.\n");
  printf("------------------------------------------------\n");
  if(argc<3)
  {
    printf("Usage - PCX2TXT filename.PCX filename.ext\n");
    exit(-1);
  }
  error = loadpcx(argv[1]);
  if(error) DisplayError(error);
  MakeText(argv[2]);
}
