PROGRAM TestPPP;

{

  This is a little example program of how to show a picture, created with
  PPPic and PPPal...

  (c) Eric van der Staay a.k.a. Magician/Silicon Limited

  For questions, bugs (I'm sure there will be some), other routines,
  contact me:

                Eric van der Staay (Magician/SCL)
                IJweg 133a
                1161 EV Zwanenburg
                Holland
                ++31(0)2907-2039

                Internet addy: StagVl1@Bouw.Tno.Nl

  If you spread this program, be sure to include all these files:

  PPPIC.EXE     - Picture converter
  PPPAL.EXE     - Palette converter
  TESTPPP.PAS   - Example program
  LOGO.PCX      - Example logo PCX file
  LOGO.PAS      - Example logo PAS picture file
  LOGOPAL.PAS   - Example logo PAS palette file
  PPP.DOC       - Documentation

}

{$i Logo.Pas}
{$i LogoPal.Pas}

Var SegLogo : Word;     { Segment adress of the logo    }
    SegPal  : Word;     { Segment adress of the palette }
    OfsLogo : Word;     { Offset addres of the logo     }
    OfsPal  : Word;     { Offset addres of the palette  }

{---------------------------------------------------------------------------}

Procedure VideoMode(Mode:Byte);

{ Change the videomode... }

Begin
     Asm
        Mov AH,$00
        Mov AL,mode
        Int $10
     End;
End;

{---------------------------------------------------------------------------}

Procedure InitPPP;

{ Initialite picture + palette offsets/segments... }

Begin
     SegLogo:=Seg(Logo);
     OfsLogo:=Ofs(Logo)+3;
     SegPal:=Seg(LogoPalette);
     OfsPal:=Ofs(LogoPalette)+3;
End;

{---------------------------------------------------------------------------}

Procedure Palette(PalSeg,PalOfs:Word);

{ Initialise the palette... }

Begin
     Asm
	Mov AX,PalSeg
	Mov ES,AX
	Mov DX,PalOfs
	Mov AH,$10
	Mov AL,$12
	Mov BX,$0000
	Mov CX,$00ff
	Int $10
     End;
End;

{---------------------------------------------------------------------------}

Procedure Picture(XPos,YPos,XSize,YSize:Integer; Segment,Offset:Word);

{ Show the picture... }

Var Y : Integer;
    X : Integer;

Begin
     X:=XSize+1;
     For Y:=0 To YSize-1 Do
         Move(Mem[SegMent:Offset+(Y*X)],Mem[$A000:XPos+((Y+YPos)*320)],X);
End;

{---------------------------------------------------------------------------}

Begin
     VideoMode($13);                            { Go to 320x200x256  }
     InitPPP;                                   { Init the segs/offs }
     Palette(SegPal,OfsPal);                    { Set the palette    }
     Picture(57,50,205,53,SegLogo,OfsLogo);     { Display the piccy  }
     Readln;
     VideoMode(3);                              { Back to 80x25x16   }
End.