Option Explicit

Sub Main ()
   
   ' If a command line file was specified, we open that file
   ' and strip it instead of showing the dialog
   If Command$ <> "" Then
      If FileExists%(Command$) Then
         frmMain.Show
         StripLink Command$
         End
      Else
         Beep
         MsgBox "File not found: " & Command$
      End If
      End
   Else
      frmMain.Show
      ' Start the browser automatically
      frmMain!cmdBrowse.Value = True
   End If

End Sub

Sub StripLink (Filename$)

' Description
'     Extracts any HTML-format links from a file and saves them in a file
'     by the same name with the extension ".LNK"
'
' Parameters
'     Name              Type     Value
'     -------------------------------------------------------------------------
'     Filename$         String   The file where the links are to be extracted
'
' Returns
'     Nothing
'
' Last updated by Jens Balchen 21.11.95



Dim f%, ff%, t$
Dim s%, e%
Dim percent&, total&
Dim i%, a%
Dim hl$
Dim in_another_line%
ReDim LineData$(0)
Dim LineCount%

   On Error GoTo Err_Handler

   ' Opens the file, reads the data and saves the lines
   ' that have a hyperlink.

   ' Set the mousepointer to hourglass
   Screen.MousePointer = 11

   ' Get a free file handle
   f% = FreeFile
   ' Open the HTML file in read mode
   Open Filename$ For Input As #f%
   ' Get a free file handle
   ff% = FreeFile
   ' Open the output file name, which is the old filename
   ' + "lnk"
   Open Left$(Filename$, InStr(Filename$, ".")) & "LNK" For Output As #ff%
      ' Find the total number of bytes to read
      total& = LOF(f%)
      ' Loop through the entire file
      Do While Not EOF(f%)
         in_another_line% = True
         ' Read one line
         Line Input #f%, t$
         ' Count the number of bytes read (including CR + LF)
         percent& = percent& + Len(t$) + 2
         ' Calculate the percent and show it in the status label
         frmMain!lblStatus = "Reading " & CInt(percent& * 100 / total&) & "%"
         ' Refresh it to make it update on the screen
         frmMain!lblStatus.Refresh
         ' Save the string in the array
         LineCount% = LineCount% + 1
         ReDim Preserve LineData$(LineCount%)
         LineData$(LineCount%) = t$
         ' Now do a search in the string for a hyperlink
         For i% = 1 To Len(t$)
            If Mid$(LCase$(t$), i%, 7) = "<a href" Then
               ' Save the position
               s% = i%
               in_another_line% = False
            ElseIf Mid$(LCase$(t$), i%, 4) = "</a>" Then
               e% = i% + 4
               If in_another_line% Then
                  ' Extract the data from all the lines read since the last reset
                  ' of the array. The first array element is the line where
                  ' the s% is pointing to.
                  For a% = 1 To LineCount%
                     If a% = 1 Then
                        hl$ = Right$(LineData$(a%), Len(LineData$(a%)) - s% + 1)
                     Else
                        hl$ = hl$ & LineData$(a%)
                     End If
                  Next
                  ' Then add the last piece
                  hl$ = hl$ & Mid$(t$, 1, e%)
               Else
                  ' Just extract the text between s% and e%
                  hl$ = Mid$(t$, s%, e% - s%)
               End If
               ' Print the data to the file
               Print #ff%, hl$
               ' Reset the array
               Erase LineData$
               LineCount% = 0
               s% = 0
            End If
            If s% = 0 Then
               Erase LineData$
               LineCount% = 0
            End If
         Next
      ' Next line
      Loop
   ' Update label with status
   frmMain!lblStatus = "Wrote " & Left$(Filename$, InStr(Filename$, ".")) & "LNK"

Exit_Sub:
   ' CLose both file
   Close #f%
   Close #ff%
   ' Reset mousepointer
   Screen.MousePointer = 0
   ' Exit
   Exit Sub

Err_Handler:
   ' if there was an error, display it in the status
   ' label
   frmMain!lblStatus = "Error: " & Error$(Err)
   ' Then exit
   Resume Exit_Sub

End Sub

