Option Explicit

Function FileExists% (filename$)

' Description
'     Checks 'filename$' to find wether the filename given
'     exists.
'
' Parameters
'     Name              Type     Value
'     -------------------------------------------------------------
'     filename$         String   The filename to be checked
'
' Returns
'     True if the file exists
'     False if the file does not exist
'
' Last updated by Jens Balchen 21.11.95


Dim f%

   ' Trap any errors that may occur
   On Error Resume Next

   ' Get a free file handle to avoid using a file handle already in use
   f% = FreeFile
   ' Open the file for reading
   Open filename$ For Input As #f%
   ' Close it
   Close #f%
   ' If there was an error, Err will be <> 0. In that case, we return False
   FileExists% = Not (Err <> 0)

End Function

