/* VAP2VOX - Translate .VAP file to library of .VOX files 5-27-88/IHM */

/* VAP2VOX <filename[.VAP]> [<optional offset>] */

#include <stdio.h>
#include <ctype.h>
#include "vapdir.h"

#define	BUFSIZE	2048

extern errno;

char outfname[16];
FILE *infp, *outfp;
unsigned int msg_offset = 0;		/* Default 0 offset */

VAPDIRHDR dirhead;
VAPENTRY *dirptr;

char msgbuf[BUFSIZE];

main (argc, argv)
int argc;
char **argv;
   {
	long i, j, k, l, m, n;

	if (argc < 2)
		error("usage: %s filename[.VAP] [<offset>]\n", argv[0]);

	if (!(infp = fopen(argv[1], "r+b")))
		error("%s: input file '%s' doesn't exist\n", argv[0], argv[1]);
	if (argc > 2)
	   {
		if (!isdigit(argv[2][0]))
			error("%s: nonnumeric offset specified\n", argv[0]);

		msg_offset = atoi(argv[2]);
	   }
	/* For now, we assume that if we got this far, the file is vaild */
	fread(&dirhead, sizeof(dirhead), 1, infp);	/* Suck in header */

	/* Allocate memory for retrieval table */
	dirptr = (VAPENTRY *) malloc(dirhead.max_prompts * sizeof(VAPENTRY));

	/* Read in retrieval table */
	fread(dirptr, sizeof(VAPENTRY), dirhead.max_prompts, infp);

	printf("%ld prompt%s\n",dirhead.total_prompts, dirhead.total_prompts==1?"":"s");
		for (l = 0; l < dirhead.total_prompts; ++l)
	   {
		if (!dirptr[l].length)
		   {
			printf("0 length message %ld - skipping\n", l+1);
			continue;
		   }
		fseek(infp, dirptr[l].start, SEEK_SET);	/* Seek to speech */
		sprintf(outfname, "msg%d.vox", msg_offset++);
		if (!(outfp = fopen(outfname, "w+b")))
			error("%s: can't open output file - error %d\n", argv[0], errno);
		for (n = 0, j = BUFSIZE; j == BUFSIZE;)
		   {
			if ((i = dirptr[l].length - n) < j)
				j = i;
			j = fread(msgbuf, 1, j, infp);
			if (fwrite(msgbuf, 1, j, outfp) != j)
				error("%s: file write error %d\n", argv[0], errno);
			n += j;

		   }
		fclose(outfp);
		printf("%s - %ld bytes written\n", outfname, n);
	   }
   }


error (template, arg1, arg2, arg3, arg4)
char *template;
int arg1, arg2, arg3, arg4;
   {
	fprintf(stderr, template, arg1, arg2, arg3, arg4);
	exit(1);
   }
