/* VOX2VAP - Translate .VOX file to library of .VAP files 5-27-88/IHM */
#include <stdio.h>
#include "vapdir.h"

#define	MAXPROMPT 500

VAPDIRHDR vhdr;
VAPENTRY vent[MAXPROMPT];
FILE	*fp;
int	prompts;
char	buffah[512];

main()

{
char	vapfname[40],voxpfx[40],fname[100];
int	i,j,k;
int	lowvox,hivox,totalvap;
int	samprate = 6052;
FILE	*ifp;

	printf("Enter vap file name:");
	fflush(stdout);
	scanf("%s",vapfname);
	strcat(vapfname,".vap");
	printf("Enter prefix for vox file names (use none for none) :");
	fflush(stdout);
	scanf("%s",voxpfx);
	if (!strcmp(voxpfx,"none")) voxpfx[0] = 0;
	printf("Enter low vox file number:");
	fflush(stdout);
	scanf("%d",&lowvox);
	printf("Enter high vox file number:");
	fflush(stdout);
	scanf("%d",&hivox);
	printf("Enter max number of prompts in VAP file:");
	scanf("%d",&totalvap);

	vhdr.max_prompts = totalvap;
	vhdr.sampling_rate = samprate;
	prompts = vhdr.total_prompts = (hivox - lowvox) + 1;
	vhdr.reserved0 = 0;
	vhdr.bytes = 0;
	vhdr.reserved1 = 0;

	fp = fopen(vapfname,"wb");
	if (!fp)
	   {
		perror("vap file open");
		exit(255);
	   }		

	for(i = 0; i < MAXPROMPT; i++)
	   {
		vent[i].start = 0;
		vent[i].length = 0;
		vent[i].text = 0;
	   }
		
	writedir();

	for(i = 0; i < prompts; i++)
	   {
		sprintf(fname,"%s%d.vox",voxpfx,i + lowvox);
		ifp = fopen(fname,"rb");
		if (!ifp) continue;
		vent[i].start = ftell(fp);
		while(j = fread(buffah,1,512,ifp))
		   {
			if (j < 0)
			   {
				perror("read");
				exit(255);
			   }
			vent[i].length += j;
			if (fwrite(buffah,1,j,fp) != j)
			   {
				perror("write");
				exit(255);
			   }
			if (j < 512) break;
		   }
		printf("%s, length %ld, offset %ld\n",
			fname,vent[i].length,vent[i].start);
		fclose(ifp);
	   }
	
	vhdr.bytes = ftell(fp);
	fflush(fp);
	fseek(fp,0L,0);
	writedir();
	fclose(fp);
	exit(0);
}

writedir()
{

	if (fwrite(&vhdr,sizeof(vhdr),1,fp) != 1)
	   {
		perror("header write");
		exit(255);
	   }

	if (fwrite(vent,sizeof(VAPENTRY),prompts,fp) != prompts)
	   {
		perror("directory write");
		exit(255);
	   }
	return(0);
}
