#ifndef _GET_SCAN_DEF
#define _GET_SCAN_DEF


/*
get_scan() -- get scan code for a printable character

(From "C++ Communications Utilities" by Holmes and Flanders, p. 40)

Modified slightly by Shawn A. Clifford, sac@eng.ufl.edu
to include the space character and the escape character.

This function returns the scan code for a valid ASCII character, else
it returns a zero.
*/

static unsigned char get_scan(unsigned char c)  // ASCII character to convert
{
static char scan_codes[] =                      // scan codes for ' ' thru ~
   {
   0x39, 0x02, 0x28, 0x04, 0x05, 0x06, 0x08, 0x28, 0x0A, 0x0B, 0x09,
   0x0D, 0x33, 0x0C, 0x34, 0x35, 0x0B, 0x02, 0x03, 0x04, 0x05, 0x06,
   0x07, 0x08, 0x09, 0x0A, 0x27, 0x27, 0x33, 0x0D, 0x34, 0x35, 0x03,
   0x1E, 0x30, 0x2E, 0X20, 0x12, 0x21, 0x22, 0x23, 0x17, 0x24, 0x25,
   0x26, 0x32, 0x31, 0x18, 0x19, 0x10, 0x13, 0x1F, 0x14, 0x16, 0x2F,
   0x11, 0x2D, 0x15, 0x2C, 0x1A, 0x2B, 0x1B, 0x07, 0x0C, 0x29, 0x1E,
   0x30, 0x2E, 0x20, 0x12, 0x21, 0x22, 0x23, 0x17, 0x24, 0x25, 0x26,
   0x32, 0x31, 0x18, 0x19, 0x10, 0x13, 0x1F, 0x14, 0x16, 0x2F, 0x11,
   0x2D, 0x15, 0x2C, 0x1A, 0x2B, 0x1B, 0x29
   };

   if (c >= ' ' && c <= '~') return (scan_codes[c - ' ']);
   if (c == '\033') return (1);                 // ESC key

   /* Default.  Not a valid character. */
   return (0);

} /* get_scan() */


#endif
