{$A-,B-,D-,E-,F-,I-,L-,N-,O-,R-,S-,V-}
{$M 8096,0,0}

program Ports;

(***********************************************************************
 NOTICE
 ======
     This program and every file distributed with it are copyright (C)
 by the authors, who retain authorship both of the pre-compiled and
 compiled codes.  Their use and distribution are unrestricted, as long
 as nobody gets any richer in the process.  Although these programs
 were developed to the best of the authors abilities, no guarantees
 can be given as to their performance.  By using them, the user
 accepts all risks and the authors decline all liability.
************************************************************************)

uses crt;

const
  num : integer = 0;

var
  p1, p2, p3, p4, p5, p6, p7 : string;
  code               : word;
  port1, port2       : word;
  i, by, by2         : byte;
  byt, wrd           : word;


procedure error;
begin
  writeln('Program Ports v. 1.3');
  writeln('Copyright (c) 1991. J. Campione/C.R.Parkinson.');
  writeln('September 17 1991.');
  inc(Textattr,128);
  write('  WARNING!');
  dec(Textattr,128);
  writeln(' This program can modify the memory and the chips in your computer...');
  writeln('  - Byte IN (from port): Ports i $INPT <!> <return>');
  writeln('  - Byte OUT (to port) : Ports o $OUTP <byte val> <!> <return>');
  writeln('  - Bytes OUT/IN       : Ports u $OUTP <byte val> $INPT <!> <return>');
  writeln('  - Bytes OUT/OUT      : Ports a $OUTP <byte val> $OUTP <byte val> <!> <return>');
  writeln('  - Word OUT (to port) : Ports w $OUTP <word val> <!> <return>');
  writeln('  The last byte value is returned as the errorlevel (exept with "Ports w").');
  writeln('  The INPT, OUTP addresses can be entered as $hex or dec numbers.');
  writeln('  The optional "!" parameter causes the display of the port byte value.');
  writeln('  The optional "#xxxx" parameter operates only with "u" and "a". The "xxxx"');
  writeln('  represents 0-9999 miliseconds of delay between the two port accesses.');
  halt(1);
end;


{ ************************************************** }
{ Tranforms a word into a hex number string.         }
{ Taken from MEMMAP in PC Mag, Jun 12 1990, p. 343.  }
{ -Jose-                                             }
{ ************************************************** }
function w2x(w: word): string;
const hexdigit: array[0..15] of char = '0123456789ABCDEF';
begin
  w2x:= hexdigit[hi(w) shr 4] + hexdigit[hi(w) and $0F] +
        hexdigit[lo(w) shr 4] + hexdigit[lo(w) and $0F];
end;


{ ************************************************** }
{ Tranforms a byte into a binary number string.      }
{ This one may not be as elegant but it is mine...   }
{ -Jose-                                             }
{ ************************************************** }

function power(a,b:real):real;
begin
  power:= exp(b * ln(a));
end;

function byte2binstr(by: byte): string;
var
  i: integer;
  pow : integer;
  bit : byte;
  strbit : string[1];
  strbin : string[8];
begin
  strbin:= '';
  for i:= 7 downto 0 do begin
    pow:= round(power(2,i));
    bit:= by div pow;
    str(bit,strbit);
    strbin:= strbin + strbit;
    by:= by - pow * bit;
  end;
  byte2binstr:= strbin;
end;


begin

  p1:= paramstr(1);
  p2:= paramstr(2);
  p3:= paramstr(3);
  p4:= paramstr(4);
  p5:= paramstr(5);
  p6:= paramstr(6);
  p7:= paramstr(7);

  { *********************** }
  { Process first parameter }
  { *********************** }
  if (ord(p1[0]) <> 1) then error;
  case upcase(p1[1]) of
   'I' : if (paramcount < 2) then error;
   'O' : if (paramcount < 3) then error;
   'U' : if (paramcount < 4) then error;
   'A' : if (paramcount < 5) then error;
   'W' : if (paramcount < 3) then error;
   else error;
  end;

  { ********************************** }
  { process second parameter (port1)   }
  { ********************************** }
  val(p2,port1,code);
  if (code <> 0) then error;

  { ********************************** }
  { Process 3rd parameter (byte value) }
  { ********************************** }
  if upcase(p1[1]) in ['O','U','A'] then begin
    val(p3,byt,code);
    if (byt > 255) or (byt < 0) then error else by:= byt;
    if code <> 0 then error;
  end;

  { ********************************** }
  { Process 3rd parameter (word value) }
  { ********************************** }
  if upcase(p1[1]) in ['W'] then begin
    val(p3,byt,code);
    if (byt < 0) then error else wrd:= byt;
    if code <> 0 then error;
  end;

  { ********************************** }
  { Process 4th parameter (port2)      }
  { ********************************** }
  if upcase(p1[1]) in ['U','A'] then begin
    val(p4,port2,code);
    if code <> 0 then error;
  end;

  { ********************************** }
  { Process 5th parameter (byte value) }
  { ********************************** }
  if upcase(p1[1]) in ['A'] then begin
    val(p5,byt,code);
    if (byt > 255) or (byt < 0) then error else by2:= byt;
    if code <> 0 then error;
  end;

  { ************************************* }
  { Process 6th parameter (delay in msec) }
  { ************************************* }
  if upcase(p1[1]) in ['A','U'] then begin
    if p6[1] = '#' then begin
      val(copy(p6,2,ord(p6[0])-1),num,code);
      if (num < 0) or (num > 9999) then error;
      if code <> 0 then error;
    end;
  end;

  { ***************************** }
  { Take action and report result }
  { ***************************** }
  case upcase(p1[1]) of
   'I' : by:= port[port1];
   'O' : port[port1]:= by;
   'U' : if num = 0 then begin
           port[port1]:= by;
           by:= port[port2];
         end else begin
           port[port1]:= by;
           delay(num);
           by:= port[port2];
         end;
   'A' : if num = 0 then begin
           port[port1]:= by;
           port[port2]:= by2;
           by:= by2;
         end else begin
           port[port1]:= by;
           delay(num);
           port[port2]:= by2;
           by:= by2;
         end;
   'W' : begin
           portw[port1]:= wrd;
           by:= 0;
         end;
  end;
  i:= 0;
  while i < paramcount do begin
    inc(i);
    if paramstr(i) = '!' then
      if upcase(p1[1]) = 'W' then writeln('Port word = ',wrd,'d, ',w2x(wrd),'h.')
      else writeln('Port byte = ',by,'d, ',w2x(by),'h, ',byte2binstr(by),'b.');
  end;
  if ((p7[1] = '!') and (p6[1] = '#')) or
     ((p6[1] = '!') and (p5[1] = '#')) then
     writeln('delay = ',num,' msecs.');
  halt(by);
end.