;*********************************************************************    
;
;PRNWATCH - Printer Watch
;  this tsr program "monitors" all printer activity via INT 17h
;
;*********************************************************************    

	DOSSEG
	.MODEL  LARGE
	.STACK 2000d
	.DATA

pspseg  DW      0
prev    DB      0

	.CODE

old17   dd      0

;=====================================================================
tsr     PROC    FAR
	push ds                         ;save all registers
	push es                         ;save all registers
	push ax                         ;save all registers
	push cx                         ;save all registers
	push dx                         ;save all registers
	push bx                         ;save all registers
	push sp                         ;save all registers
	push bp                         ;save all registers
	push si                         ;save all registers
	push di                         ;save all registers

	cmp al,13d                      ;is the char a CR?
	je OK                           ;yes, go print it

	cmp al,10d                      ;is the char a LF?
	je OK                           ;yes, go print it

	cmp al,27d                      ;is the char an ESC?
	je OK                           ;yes, go print it

	cmp al,09d                      ;is the char a TAB?
	jne LowAscii                    ;no, skip next section
	
	mov cx,3                        ;convert 1 tab to 3 spaces

ConvertTab:
	mov ah,0Eh                      ;function to write teletype mode
	mov al,20h                      ;write a space char
	mov bh,0                        ;write it on page 0
	int 10h                         ;call BIOS to do it
	loop ConvertTab                 ;do it 3 times

LowAscii:
	cmp al,20h                      ;is the char a SPACE or higher?
	jb Done                         ;no, it's below - ignore it

OK:                                     ;if we get here, we're printing
	mov dx,DGROUP                   ;get previous program's DGROUP
	mov ds,dx                       ;put it in ds
	mov ah,0Eh                      ;function to write teletype mode
	mov bh,0                        ;write it on page 0
	int 10h                         ;call BIOS to do it

Done:        
	pop di                          ;restore register
	pop si                          ;restore register
	pop bp                          ;restore register
	pop sp                          ;restore register
	pop bx                          ;restore register
	pop dx                          ;restore register
	pop cx                          ;restore register
	pop ax                          ;restore register
	pop es                          ;restore register
	pop ds                          ;restore register
	jmp old17                       ;jump back to previous program
tsr     endp
;=====================================================================



;=====================================================================
; First run of program starts HERE!
; Shift TSR procedure to TSR memory
;
start:  
	mov     ax,DGROUP               ;set DGROUP for storage of resident code
	mov     ds,ax                   ;put it in ds
	mov     ax,es                   ;
	mov     pspseg,ax               ;set vector to point to TSR proc
	mov     ax,3517H                ;set function to set vector to our int
	int     21H                     ;call DOS to do it
	mov     WORD PTR old17,bx       ;save segment of previous program
	mov     WORD PTR old17+2,es     ;save offset of previous program
	push    ds                      ;store current DS
	lea     dx,tsr                  ;move address of start of TSR
	mov     ax,cs                   ;routine to DX
	mov     ds,ax                   ;
	mov     ax,2517H                ;get address of interrupt
	int     21H                     ;call DOS to do it
	pop     ds                      ;restore data segment
	mov     dx,ss                   ;
	sub     dx,pspseg               ;get amount of memory of only TSR
	mov     ax,3100H                ;routine so only it will be stored
	int     21h                     ;shift to TSR
	end     start                   ;end the program as a TSR

	.EXIT
;=====================================================================

	END
