/*
    BMCompile is the part of the Boyer-Moore string search algorithm that
	 "compiles" the search string.  Pattern is a pointer to the search string,
	 pl is the length, in bytes, of the search string, and d is a pointer to
	 a 256 entry integer array to hold the "compiled" string.  It is a
	 separate function to allow "compilation" once for many searches such as
	 searching the lines of a file.
*/
BMCompile (Pattern, pl, d)
char *Pattern;
int pl, d[];
{	
	int i;

	for (i=0; i<256; i++) d[i] = pl;
	for (i=0; i<pl-1; i++) d[Pattern[i]] = pl - i - 1;
	}

/*
    BMCompile is the part of the Boyer-Moore string search algorithm that
	 "compiles" the search string.  Pattern is a pointer to the search string,
	 pl is the length, in bytes, of the search string, and d is a pointer to
	 a 256 entry integer array to hold the "compiled" string.  It is a
	 separate function to allow "compilation" once for many searches such as
	 searching the lines of a file.
*/
BMCompileI (Pattern, pl, d)
char *Pattern;
int pl, d[];
{	
	int i;

	for (i=0; i<256; i++) d[i] = pl;
	for (i=0; i<pl-1; i++) d[toupper(Pattern[i])] = pl - i - 1;
	}

/*
    BMSearch is the actual search algorithm for the Boyer-Moore string
	 search.  The search string, Pattern, must be "compiled" by BMCompile
	 before BMSearch is called.  Line is a pointer to the string to be
	 searched and sl is its length in bytes.  Pattern is a pointer to the
	 string to search for and pl is its length in bytes.  d is a pointer
	 to the 256 entry integer array that contains the "compiled" form of
	 Pattern.  BMSearch returns -1 if Pattern is not contained in line and
	 the pointer to the first matching character if it is contained in line.
	 This version of BMSearch is case sensitive.
*/
BMSearch (Line, sl, Pattern, pl, d)
char *Line, *Pattern;
int sl, pl, d[];
{	
	int i, j, k, io;

	i = pl; 
	io = 0;
	do {	
		io = i;
		j = pl; 
		k = i;
		do {	
			k--; 
			j--;
			}
		while ((j >= 0) && (Pattern[j] == Line[k]));
		i = i + d[Line[i-1]];
		}
	while ((j >= 0) && (i <= sl));
	if (j < 0) return(io - pl);
	else return(-1);
	}

/*
    BMSearch is the actual search algorithm for the Boyer-Moore string
	 search.  The search string, Pattern, must be "compiled" by BMCompile
	 before BMSearch is called.  Line is a pointer to the string to be
	 searched and sl is its length in bytes.  Pattern is a pointer to the
	 string to search for and pl is its length in bytes.  d is a pointer
	 to the 256 entry integer array that contains the "compiled" form of
	 Pattern.  BMSearch returns -1 if Pattern is not contained in line and
	 the pointer to the first matching character if it is contained in line.
	 This version of BMSearch is case insensitive.
*/
BMSearchI (Line, sl, Pattern, pl, d)
char *Line, *Pattern;
int sl, pl, d[];
{	
	int i, j, k, io;

	i = pl; 
	io = 0;
	do {	
		io = i;
		j = pl; 
		k = i;
		do {	
			k--; 
			j--;
			}
		while ((j >= 0) && (toupper(Pattern[j]) == toupper(Line[k])));
		i = i + d[toupper(Line[i-1])];
		}
	while ((j >= 0) && (i <= sl));
	if (j < 0) return(io - pl);
	else return(-1);
	}


