#include <stdio.h>
#include <ctype.h>

struct PatternStruct {
	struct PatternStruct *Next;
	char *Pattern;
	int *d;
	}

main (argc, argv)
int argc;
char *argv[];
{	 
	extern int BMSearch(), BMSearchI();
	extern void BMCompile(), BMCompileI();
	char *malloc();

	struct {
		struct PatternStruct *Head, *Current;
		}
	PatQueue;

	char Line[256], Pattern[81], FileName[68];
	int lnno, sl, pl, p, i, fp;
	int d[256];
	FILE *F1;
	struct PatternStruct *t;

	int (* Search) ();
	void (* Compile) ();

	fprintf(stderr, "FINDSTR Version 1.01: August 5, 1986\n\n");
	Search = BMSearchI; Compile = BMCompileI;

	for (i=1; i<argc; i++) {
		if (argv[i][0] == '-') {
			switch (toupper(argv[i][1])) {
				case 'C':
					Search = BMSearch; Compile = BMCompile;
					break;
				default:
					fprintf(stderr, "Invalid option: %s\n", argv[i]);
					exit(1);
					break;
				}
			}
		}
	PatQueue.Head = PatQueue.Current = (struct PatternStruct *) NULL;
	fprintf(stderr, "Enter search patterns, 1 per line\n");
	fprintf(stderr, "NULL line terminates\n");
	while (fgets(Pattern, 80, stdin)) {
		pl = strlen(Pattern); 
		Pattern[--pl] = 0x00;
		if (pl == 0) break;
		t = (struct PatternStruct *) malloc(sizeof(struct PatternStruct));
		if (t == NULL) {
			fprintf(stderr, "Insufficient memory for pattern: %s\n", Pattern);
			continue;
			}
		t->Pattern = malloc(pl+1);
		if (t->Pattern == 0) {
						fprintf(stderr, "Insufficient memory for pattern: %s\n", Pattern);
			continue;
			}
		t->d = (int *) malloc(256 * sizeof(int));
		if (t->d == 0) {
			fprintf(stderr, "Insufficient memory for pattern: %s\n", Pattern);
			continue;
			}
		strcpy(t->Pattern, Pattern);
		(* Compile) (Pattern, pl, t->d);
		t->Next = NULL;
		if (PatQueue.Head == NULL) PatQueue.Head = t;
		else PatQueue.Current->Next = t;
		PatQueue.Current = t;
		}
	for (fp=1; fp<argc; fp++) {
		if (argv[fp][0] == '-') continue;
		if ((F1 = fopen(argv[fp], "r")) == 0) {
			fprintf(stderr, "Can't find file: %s\n", argv[fp]);
			continue;
			}
		printf("--%s--\n", argv[fp]);
		lnno = 0;
		while (fgets(Line, 255, F1)) {
			sl = strlen(Line); 
			Line[--sl] = 0x00;
			lnno++;
			for (t=PatQueue.Head; t != NULL; t = t->Next) {
				if ((p = (* Search) (Line, sl, t->Pattern, strlen(t->Pattern),
						t->d)) >= 0) {
					printf("%s %4d: %s\n", t->Pattern, lnno, Line);
					}
				}
			}
		fclose(F1);
		}
	}
