@echo off
REM *******************************************************
REM *** DelOld.bat - Act like DEL, but delete file that ***
REM *** ver.1        are more than a certain number of  ***
REM ***              days old.                          ***
REM *******************************************************

CEnviD %0.bat %1 %2 %3 %4 %5 %6 %7 %8 %9
GOTO CENVI_EXIT

Instructions()
{
   puts("\a")
   puts(`DelOld - Delete old file; files more than X days old`)
   puts(``)
   puts(`USAGE: DelOld <FileSpec> <Age> [/P] [/R] [/S] [/H]`)
   puts(``)
   puts(`WHERE: FileSpec - Any file specification, including wildcards`)
   puts(`       Age - Age, in days, of files to delete`)
   puts(`       /P - Prompt before deleting each file`)
   puts(`       /R - Recursive; work in current and subirectories`)
   puts(`       /S - Include files with the SYSTEM attribute`)
   puts(`       /H - Include files with the HIDDEN attribute`)
   puts(``)
   puts(`EXAMPLE: This will delete all *.bak file on C: at least 10 days old`)
   puts(`            DelOld C:\*.bak 10 /R /S /H`)
   puts(``)
}

#include <OptParms.lib>

Prompt;  // options
AgeInSeconds;
Attrib;
FileSpec;
dta; // disk transfer address

main(argc,argv)
{
   // get the command-line options
   Prompt = OptionalParameter(argc,argv,"P");
   Recurse = OptionalParameter(argc,argv,"R");
   System = OptionalParameter(argc,argv,"S");
   Hidden = OptionalParameter(argc,argv,"H");

   // get file name and age
   InputFileSpec = argv[1];
   Age = atoi(argv[2]);
   AgeInSeconds = Age * 24 * 60 * 60;

   // if parameters weren't valid then print instructions and leave
   if ( argc != 3  ||  Age < 1 ) {
      Instructions();
      return EXIT_FAILURE;
   }

   // Build list of matching files
   Attrib = FATTR_RDONLY | FATTR_ARCHIVE;
   if ( System ) Attrib |= FATTR_SYSTEM;
   if ( Hidden ) Attrib |= FATTR_HIDDEN;

   // break into directory and file spec
   if ( InitialDir = SplitFileName(InputFileSpec).dir );
   strcpy(FileSpec,InputFileSpec + strlen(InitialDir));

   GetDTA();

   if ( Recurse )
      DirCount = BuildDirectoryList(DirList,InitialDir);
   // always perform in top directory
   DelOldFilesInDirectory(InitialDir);
   // Perform this operation in every subdirectory of current directory
   if ( Recurse ) {
      for ( i = 0; i < DirCount; i++ ) {
         strcat(DirList[i].name,"\\");
         DelOldFilesInDirectory(DirList[i].name);
      }
   }

   return EXIT_SUCCESS;
}

BuildDirectoryList(pDirList,pInitialDir)
{
   printf("Building directory list...");
   sprintf(DirSpec,"%s*.*",pInitialDir);
   if ( pDirList = Directory(DirSpec,True,
                            FATTR_RDONLY|FATTR_HIDDEN|FATTR_SYSTEM|FATTR_SUBDIR|FATTR_ARCHIVE,
                            FATTR_SUBDIR) ) {
      DirCount = 1 + GetArraySpan(pDirList);
   } else
      DirCount = 0
   printf(" Done.\n");
   return DirCount;
}

DelOldFilesInDirectory(pDir)
   // delete each file matching FileSpec that is at least Age old
{
   FirstFile = True;
   while ( FileName = FindNextFileEntry(FirstFile,pDir,FileTime,FileAttr) ) {
      FirstFile = False;
      if ( AgeInSeconds <= difftime(time(),FileTime) ) {
         DeleteFile(pDir,FileName,FileTime,FileAttr);
      }
   }
}

DeleteFile(pDir,pFileName,pFileTime,pAttrib)
{
   strftime(TimeBuf,"%m-%d-%y",localtime(pFileTime));
   // print name of file, date, and age in days
   sprintf(FullFileName,"%s%s",pDir,pFileName);
   printf("%-58s %s Age: %.1f\n",FullFileName,TimeBuf,
          float(difftime(time(),pFileTime)) / (24 * 60 * 60) );

   // if rd_only then explain that cannot delete
   if ( FATTR_RDONLY & pAttrib ) {
      printf("\n\a\tCANNOT DELETE READ-ONLY FILE!!!\n");
   } else {
      if ( Prompt ) {
         printf("Delete? (Y/N) ");
         Answer = toupper(getch());
         while ( !strchr("YN",Answer) ) {
            printf("\a");
            Answer = toupper(getch());
         }
         printf("%c\n",Answer);
      }
      if ( !Prompt  ||  Answer == 'Y' )
         remove(FullFileName);
   }
}

GetDTA()
{
   reg.ah = 0x2F;
   interrupt(0x21,reg);
   dta = Address(reg.es,reg.bx);
}

FindNextFileEntry(pFirstEntry,pDir,pTime,pAttrib)
{
   if ( pFirstEntry ) {
      reg.ah = 0x4E;
      reg.cx = Attrib;
      sprintf(FullFileName,"%s%s",pDir,FileSpec);
      reg.ds = segment(FullFileName);
      reg.dx = offset(FullFileName);
   } else {
      reg.ah = 0x4F;
   }
   if ( !interrupt(0x21,reg) )
      return NULL;

   pAttrib = peek(dta+21);
   // determine date in format we recognized
   lDate = peek(dta+24,UWORD16);
   tm.tm_year = 80 + (lDate>>9) & 0x7F;
   tm.tm_mon = ((lDate>>5) & 0xF) - 1;
   tm.tm_mday = lDate & 0x1F;
   lTime = peek(dta+22,UWORD16);
   tm.tm_hour = (lTime>>11) & 1F;
   tm.tm_min = (lTime>>5) & 3F;
   tm.tm_sec = (lTime & 0x1F) * 2;
   pTime = mktime(tm);
   FileNameFound = peek(dta+30,13);
   return FileNameFound;
}

:CENVI_EXIT
