@echo off
:: ***************************************************************
:: *** FloppyIn.bat - Check if there is a floppy disk in drive ***
:: *** ver.2          A: or B:, set ERRORLEVEL 1 if there is   ***
:: ***                not, else ERRORLEVEL 0 if there is       ***
:: ***************************************************************

:: CHECK FOR VALID A, B, a, or b
   if "%1" == "A" GOTO VALID_DRIVE
   if "%1" == "a" GOTO VALID_DRIVE
   if "%1" == "B" GOTO VALID_DRIVE
   if "%1" == "b" GOTO VALID_DRIVE
   CEnviD printf("USAGE: FloppyIn  < A | a | B | b >\a\n")
   CEnviD printf("       ERRORLEVEL 1 if NO FLOPPY; else ERRORLEVEL 0\n") return(1)
   GOTO FLOPPYIN_EXIT

:VALID_DRIVE
:: Try to read a sector 3 times, return 1 if cannot read
   CEnviD "#include '%0,bat,::CODE' IsFloppyIn('%1')"
   IF ERRORLEVEL 1 ECHO NO FLOPPY IN DRIVE
   IF NOT ERRORLEVEL 1 ECHO FLOPPY IS IN DRIVE
   ::Code  IsFloppyIn(Drive)
   ::Code  {
   ::Code     BLObSize(buf,5000)// prepare a big buffer
   ::Code     for ( i = 0; i < 3; i++ ) {
   ::Code        reg.ah = 2           // code for reading sectors
   ::Code        reg.al = 1           // read one sector
   ::Code        reg.ch = 0           // track number
   ::Code        reg.cl = 1           // sector number
   ::Code        reg.dh = 0           // disk side (0 or 1)
   ::Code        reg.dl = toupper(Drive) - 'A'
   ::Code        reg.es = segment(buf) // es:bx point to buffer
   ::Code        reg.bx = offset(buf)
   ::Code        if ( interrupt(0x13,reg,outreg) )
   ::Code         exit(0)  // floppy read OK (carry flag not set)
   ::Code     }
   ::Code     // If finished loop without finding floppy, then error
   ::Code     exit(1)
   ::Code  }

:FLOPPYIN_EXIT
