@echo off
REM ********************************************************************
REM *** PrntScrn.bat - Two methods of sending the screen to the      ***
REM *** ver.2          printer.  One method uses the BIOS interrupt  ***
REM ***                as used by pressing the PrtScr key.  The      ***
REM ***                The other method reads the text of the screen ***
REM ***                with CEnvi routines and prints that.          ***
REM ********************************************************************

CEnviD %0.bat %1 %2 %3 %4 %5
GOTO CENVI_EXIT

Instruction()
{
   puts(``)
   puts(`PrntScrn - Print screen contents to standard printer device`)
   puts(``)
   puts(`USAGE: PrntScrn < BIOS | SMART >`)
   puts(``)
   puts(`WHERE: BIOS: Use bios call; identical to pressing PrintScreen key`)
   puts(`       SMART: Read text contents of screen and print text contents`)
   puts(`              using standard CEnvi calls`)
   puts(``)
   puts(`EXAMPLE: PrntScrn BIOS`)
   puts(`         PrntScrn SMART`)
   puts(``)
   exit(EXIT_FAILURE);
}

main(argc,argv)
{
   if ( 2 != argc ||
        (stricmp(argv[1],"BIOS") && stricmp(argv[1],"SMART")) )
      Instruction();
   if ( !stricmp(argv[1],"BIOS") )
      BiosPrintScreen();
   else
      SmartPrintScreen();
}

BiosPrintScreen()
{
   reg.ah = 0;
   interrupt(0x05,reg);
}

SmartPrintScreen()
{
   system("ScrnSave.bat PRN");
}

:CENVI_EXIT
