@echo off
REM ********************************************************************
REM *** Which.bat - Show when command would be executed by searching ***
REM *** ver.1       for command along path.                          ***
REM ********************************************************************
CEnviD %0.bat %1 %2
GOTO CENVI_EXIT

#include "Netware.lib"

if( defined(_WINDOWS_) || defined(_NTWIN_) || defined(_NTCON_) )
{
  ExecuteOrder = { ".CMM", ".COM", ".EXE", ".BAT", ".PIF" };
} else if( defined(_OS2_) )
{
  ExecuteOrder = { ".CMM", ".COM", ".EXE", ".CMD", ".BAT" };
} else {
  ExecuteOrder = { ".CMM", ".COM", ".EXE", ".BAT" };
}


Instructions()
{
   printf("\a\n")
   puts(`Which - Determine which command in PATH will execute, and what order`)
   puts(``)
   puts(`SYNTAX: Which <CommandSpec>`)
   puts(``)
   puts(`WHERE: CommandSpec is any file spec.  If CommandSpec has no extension then`)
   printf(`       will search executables in this order:`)
   for ( i = 0; i <= GetArraySpan(ExecuteOrder); i++ )
      printf(" %s",ExecuteOrder[i])
   puts(``)
   puts(`EXAMPLES: Which EDIT`)
   puts(`          Which SESSION.C*`)
   exit(EXIT_FAILURE);
}

/* ---------------------------------------------------------------------- */

   #define HKEY_CLASSES_ROOT       0x80000000
   #define HKEY_CURRENT_USER       0x80000001
   #define HKEY_LOCAL_MACHINE      0x80000002
   #define HKEY_USERS              0x80000003
   #define HKEY_PERFORMANCE_DATA   0x80000004

   #define REG_SZ                       1

RegCloseKey(pHKey)
{
   return DynamicLink("ADVAPI32","RegCloseKey",STDCALL,pHKey);
}

RegCreateKey(pHKey,pSubKeyStr,pGetHKey)
{
   lRet = DynamicLink("ADVAPI32","RegCreateKeyA",STDCALL,pHKey,pSubKeyStr,lGetHKey);
   pGetHKey = lGetHKey;
   return lRet;
}

RegQueryValueEx(pHKey,pValueName,pGetType,pGetData,pGetDataSize)
{
   lRet = DynamicLink("ADVAPI32","RegQueryValueExA",STDCALL,
                      pHKey,pValueName,0,lGType,NULL,lBufSize);
   if ( !lRet ) {
      BLObSize(pGetData,lBufSize);
      lRet = DynamicLink("ADVAPI32","RegQueryValueExA",STDCALL,
                         pHKey,pValueName,0,lGetType,pGetData,pointer(lBufSize));
      pGetType = lGetType;
      pGetDataSize = lBufSize;
   }
   return lRet;                     
}

/* ---------------------------------------------------------------------- */

main(argc,argv)
{
   if ( argc != 2 )   Instructions();

   NameParts = SplitFileName(argv[1]);
   if ( NameParts.dir[0] ) {
      printf("\aWHICH will not work with directory specifications.\n");
      exit(EXIT_FAILURE);
   }

   // if extension then use it, else use our extension list
   if ( NameParts.ext[0] ) {
      Extensions[0] = NameParts.ext;
      ExtensionCount = 1;
   } else {
      Extensions = ExecuteOrder;
      ExtensionCount = 1 + GetArraySpan(ExecuteOrder);
   }
   // get prioritized list of all directories
   PathCount = BuildPathList(PathList);

   // for each directory, find all of the matching files
   FindCount = 0;
   for ( PathIdx = 0; PathIdx < PathCount; PathIdx++ ) {
      for ( ExtensionIdx = 0; ExtensionIdx < ExtensionCount; ExtensionIdx++ ) {
         FindCount += FindFileInDirectory(PathList[PathIdx],NameParts.name,Extensions[ExtensionIdx]);
      }
   }

   if ( !FindCount ) {
      printf("\aNo commands found for %s\n",argv[1]);
      exit(EXIT_FAILURE);
   }

}

Count = 0;
List[0] = "";
strcpy(List[Count++],FullPath("."));

AddDir(dir)
{
  for( i=0;i<Count;i++ )
    if( !stricmp(List[i],dir) ) return;   // Already looking there
  strcpy(List[Count++],dir);
}

BuildPathList(List1)
{
   // get full path of each directory from the PATH variable
   if ( Path = getenv("PATH") ) {
      for ( Dir = strtok(Path,";"); Dir; Dir = strtok(NULL,";") ) {
         if ( Dir[0] ) AddDir(Dir);
      }
   }

   if( defined(_OS2_) || defined(_DOS_) || defined(_DOS32_) || defined(_NTCON_) )
      {
         if ( Path = getenv("CMMPATH") ) {
            for ( Dir = strtok(Path,";"); Dir; Dir = strtok(NULL,";") ) {
               if ( Dir[0] ) AddDir(Dir);
            }
         }
      }
   if( defined(_WINDOWS_) )
     {
       buffer = ""; SetArraySpan(buffer,100);
       DynamicLink("KERNEL","GETPROFILESTRING",SWORD16,PASCAL,
                   "CEnvi","CMMPATH","",buffer,100);
       if( buffer[0] )
         {
           for ( Dir = strtok(buffer,";"); Dir; Dir = strtok(NULL,";") ) {
             if ( Dir[0] ) AddDir(Dir);
           }
         }
     }
   if( defined(_NTWIN_) )
     {
       Path = ""; SetArraySpan(Path,200);
       RegCreateKey(HKEY_LOCAL_MACHINE,"Software\\Nombas\\CEnviWNT",lKey);
       RegQueryValueEx(lkey,"CMMPATH",REG_SZ,Path,200);
       RegCloseKey(lkey);

       for ( Dir = strtok(Path,";"); Dir; Dir = strtok(NULL,";") ) {
         if ( Dir[0] ) AddDir(Dir);
       }
      }

   // make sure each element in path list ends in '\'
   for ( i = 0; i < Count; i++ ) {
      if ( strcmp(":\\",List[i]+1) )
         strcat(List[i],"\\");
   }

   List1 = List;

   return Count;
}

FindFileInDirectory(DirSpec,NameSpec,ExtSpec)
{
   sprintf(FindSpec,"%s%s%s",DirSpec,NameSpec,ExtSpec);
   if ( !(FindList = Directory(FindSpec,False,_A_RDONLY|_A_ARCH)) )
      return 0;

   Count = 1 + GetArraySpan(FindList);
   for ( i = 0; i < Count; i++ )
      printf("  %s\n",FindList[i].name);
   return Count;
}

:CENVI_EXIT
