/* DOS VERSION */

/* This sample program demonstrates the use of the .EXE file validation */
/* system. This program simply checks whether its .EXE file is valid,   */
/* and displays a message accordingly. To rebuild this file, create a   */
/* "makefile" / "project file" that includes exedemo.c and exevalid.c.  */
/* After compiling the .EXE file, use the exestamp program to create a  */
/* valid hash stamp in the .EXE file.                                   */

/* Include the EXEValid header file. */
#include "exevalid.h"

    
/* Program execution begins here. */
int main(int argc, char *argv[])
{
   if(argc < 1)
   {
      /* Check that EXE filename has been provided. */
      printf("EXE file name is unknown.\n");
      return(0);
   }

   /* Validate EXE and act accordingly. */
   switch(ValidateEXE(argv[0]))
   {
      case kInvalid:
         printf("EXE file does not have a valid hash stamp; aborting.\n");
         return(1);
      case kGeneralFailure:
         printf("Internal error - not enough system resources available.\n");
         return(1);
   }
   
   /* Program execution will only get to this point if .EXE is valid. */
   printf("EXE file is valid, proceeding normally.\n");

   /* Exit program. */   
   return(0);
}


