' DemoAppD - QuickBASIC / DOS version of the RegKey demonstration program.
'            Demonstrates the use of file-based registration key validation
'            within a program using the RegKey system. Displays one of two
'            simple messages based upon whether or not the user is
'            registered. To test in registerd mode, use KeyGen to generate
'            a *.KEY registration key file for DemoApp, and place that file
'            in the current default directory. To test in unregistered mode
'            remove any valid *.KEY files from the current default directory.

' The following line must appear in any program using RegKey
' $INCLUDE: 'regkeyqb.bi'


DIM SHARED RegisteredMode AS INTEGER     ' Variable to store mode to operate in
DIM SHARED RegistrationString AS STRING      ' To store name of registered user



' Check for a valid registration key file

' The following information is passed to the RegKeyFileValidate() function
'    "*.KEY"             - Filespec of registration key file
'    "0C9HMN1NDL"        - Application's validation code
'    "Your Name", 0      - Your RegKey registration info
'    RegistrationString$ - Where registration string will be placed
'    255                 - Maximum size of registration string
'    RegisteredMode%     - Where to store result of validation

Result = RegKeyFileValidate("*.KEY", "0C9HMN1NDL", "Your Name", 0, RegistrationString$, 255, RegisteredMode%)

CLS

IF RegisteredMode% = RKRegistered THEN
   ' If we are operating in registered mode, display registered message

   PRINT "DemoApp is registered to: "; RegistrationString$
   PRINT "Thanks for registering DemoApp!"

ELSE
   ' If we are operating in UNregistered mode, display UNregistered message

   PRINT "DemoApp is NOT registered"
   PRINT "Please remember to register DemoApp!"
END IF
